/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.Context;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.utils.Utils;

public class EmailCommandInstruction
extends AbstractCommandInstruction {
    static final String PREFIX = "email";
    private String msg;
    private final List<String> tos = new ArrayList<String>();

    EmailCommandInstruction(Context context, String instruction, int line) {
        super(context, instruction, line);
        Pattern p = Pattern.compile("email\\s+(.*)\\s*with\\s+(.*)", 2);
        Matcher m = p.matcher(instruction);
        if (m.matches()) {
            this.syntaxicallyCorrect = true;
            this.tos.addAll(Utils.splitNicely(m.group(1), ","));
            this.msg = m.group(2).trim().replace("\\n", "\n");
        }
    }

    @Override
    public List<ParsingError> doValidate() {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (Utils.isEmptyOrWhitespaces(this.msg)) {
            result.add(this.error(ErrorCode.CMD_EMAIL_NO_MESSAGE));
        }
        return result;
    }

    public String getMsg() {
        return this.msg;
    }

    public List<String> getTos() {
        return this.tos;
    }
}

