/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.roboconf.core.dsl.ParsingModelValidator;
import net.roboconf.core.dsl.parsing.AbstractBlock;
import net.roboconf.core.dsl.parsing.AbstractBlockHolder;
import net.roboconf.core.dsl.parsing.BlockBlank;
import net.roboconf.core.dsl.parsing.BlockComment;
import net.roboconf.core.dsl.parsing.BlockComponent;
import net.roboconf.core.dsl.parsing.BlockFacet;
import net.roboconf.core.dsl.parsing.BlockImport;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.errors.RoboconfErrorHelpers;
import net.roboconf.core.internal.dsl.parsing.FileDefinitionParser;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.SourceReference;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.utils.ModelUtils;
import net.roboconf.core.utils.Utils;

public class FromGraphDefinition {
    private final File rootDirectory;
    private final boolean flexParsing;
    private final Collection<ParsingError> errors = new ArrayList<ParsingError>();
    private final Map<Object, SourceReference> objectToSource = new HashMap<Object, SourceReference>();
    private Map<String, ComponentData> componentNameToComponentData;
    private Map<String, FacetData> facetNameToFacetData;
    private Set<File> importsToProcess;
    private Set<File> processedImports;
    private final Map<String, String> typeAnnotations = new HashMap<String, String>();

    public FromGraphDefinition(File rootDirectory) {
        this(rootDirectory, false);
    }

    public FromGraphDefinition(File rootDirectory, boolean flexParsing) {
        this.rootDirectory = rootDirectory;
        this.flexParsing = flexParsing;
    }

    public Collection<ParsingError> getErrors() {
        return this.errors;
    }

    public Set<File> getProcessedImports() {
        return this.processedImports;
    }

    public Map<Object, SourceReference> getObjectToSource() {
        return this.objectToSource;
    }

    public Map<String, String> getTypeAnnotations() {
        return this.typeAnnotations;
    }

    public Graphs buildGraphs(File file) {
        this.componentNameToComponentData = new HashMap<String, ComponentData>();
        this.facetNameToFacetData = new HashMap<String, FacetData>();
        this.importsToProcess = new HashSet<File>();
        this.processedImports = new HashSet<File>();
        this.errors.clear();
        this.typeAnnotations.clear();
        this.importsToProcess.add(file);
        while (!this.importsToProcess.isEmpty()) {
            File importedFile = this.importsToProcess.iterator().next();
            this.importsToProcess.remove(importedFile);
            this.processedImports.add(importedFile);
            if (!importedFile.exists()) {
                ParsingError error = new ParsingError(ErrorCode.CO_UNREACHABLE_FILE, file, 0);
                error.setDetails(ErrorDetails.file(importedFile));
                this.errors.add(error);
                continue;
            }
            FileDefinition currentDefinition = new FileDefinitionParser(importedFile, false).read();
            ArrayList<ParsingError> currentErrors = new ArrayList<ParsingError>();
            currentErrors.addAll(currentDefinition.getParsingErrors());
            StringBuilder lastComment = new StringBuilder();
            for (AbstractBlock block : currentDefinition.getBlocks()) {
                currentErrors.addAll(ParsingModelValidator.validate(block));
                if (block instanceof BlockComment) {
                    lastComment.append(((BlockComment)block).getContent().trim() + "\n");
                    continue;
                }
                if (block instanceof BlockBlank) {
                    lastComment.setLength(0);
                    continue;
                }
                if (lastComment.length() <= 0 || !(block instanceof AbstractBlockHolder)) continue;
                String comment = lastComment.toString().replaceAll("#\\s*", "").trim();
                this.typeAnnotations.put(((AbstractBlockHolder)block).getName(), comment);
            }
            if (currentDefinition.getFileType() != 3 && currentDefinition.getFileType() != 1 && currentDefinition.getFileType() != 4) {
                ParsingError error = new ParsingError(ErrorCode.CO_NOT_A_GRAPH, file, 0);
                error.setDetails(ErrorDetails.unrecognized(FileDefinition.fileTypeAsString(currentDefinition.getFileType())));
                currentErrors.add(error);
            }
            this.errors.addAll(currentErrors);
            if (!this.flexParsing && RoboconfErrorHelpers.containsCriticalErrors(currentErrors)) continue;
            this.processInstructions(currentDefinition);
        }
        if (this.flexParsing || this.errors.isEmpty()) {
            this.checkNameCollisions();
        }
        if (this.flexParsing || this.errors.isEmpty()) {
            this.checkUnicity();
        }
        if (this.flexParsing || this.errors.isEmpty()) {
            this.resolveComponents();
        }
        if (this.flexParsing || this.errors.isEmpty()) {
            this.resolveFacets();
        }
        return this.buildFinalGraphs();
    }

    private void processInstructions(FileDefinition definition) {
        for (AbstractBlock block : definition.getBlocks()) {
            switch (block.getInstructionType()) {
                case 3: {
                    this.processComponent((BlockComponent)block);
                    break;
                }
                case 2: {
                    this.processFacet((BlockFacet)block);
                    break;
                }
                case 1: {
                    this.processImport((BlockImport)block);
                    break;
                }
            }
        }
    }

    private void processImport(BlockImport block) {
        String uri = block.getUri().trim();
        File newDefFile = new File(this.rootDirectory, uri);
        if (!this.processedImports.contains(newDefFile)) {
            this.importsToProcess.add(newDefFile);
        }
    }

    private void processFacet(BlockFacet block) {
        FacetData data = this.facetNameToFacetData.get(block.getName());
        if (data != null) {
            data.blocks.add(block);
        } else {
            data = new FacetData();
            data.object = new Facet(block.getName());
            ((Facet)data.object).exportedVariables.putAll(ModelUtils.getExportedVariables(block));
            data.childrenNames.addAll(ModelUtils.getPropertyValues(block, "children"));
            data.extendedFacetNames.addAll(ModelUtils.getPropertyValues(block, "extends"));
            data.blocks.add(block);
            this.facetNameToFacetData.put(block.getName(), data);
        }
    }

    private void processComponent(BlockComponent block) {
        ComponentData data = this.componentNameToComponentData.get(block.getName());
        if (data != null) {
            data.blocks.add(block);
        } else {
            data = new ComponentData();
            data.object = new Component(block.getName());
            ((Component)data.object).exportedVariables.putAll(ModelUtils.getExportedVariables(block));
            ((Component)data.object).setInstallerName(ModelUtils.getPropertyValue(block, "installer"));
            for (String s : ModelUtils.getPropertyValues(block, "imports")) {
                Boolean external;
                Boolean optional = s.toLowerCase().endsWith("(optional)");
                if (optional.booleanValue()) {
                    s = s.substring(0, s.length() - "(optional)".length()).trim();
                }
                if ((external = Boolean.valueOf(s.toLowerCase().startsWith("external"))).booleanValue()) {
                    s = s.substring("external".length()).trim();
                }
                ((Component)data.object).addImportedVariable(new ImportedVariable(s, optional, external));
            }
            data.extendedComponentName = ModelUtils.getPropertyValue(block, "extends");
            data.childrenNames.addAll(ModelUtils.getPropertyValues(block, "children"));
            data.facetNames.addAll(ModelUtils.getPropertyValues(block, "facets"));
            data.blocks.add(block);
            this.componentNameToComponentData.put(block.getName(), data);
        }
    }

    private void checkNameCollisions() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.componentNameToComponentData.keySet());
        names.retainAll(this.facetNameToFacetData.keySet());
        for (String name : names) {
            ComponentData cd = this.componentNameToComponentData.get(name);
            this.errors.addAll(cd.error(ErrorCode.CO_CONFLICTING_NAME, ErrorDetails.name(name)));
            FacetData fd = this.facetNameToFacetData.get(name);
            this.errors.addAll(fd.error(ErrorCode.CO_CONFLICTING_NAME, ErrorDetails.name(name)));
        }
    }

    private void checkUnicity() {
        for (Data data : this.componentNameToComponentData.values()) {
            if (data.blocks.size() <= 1) continue;
            this.errors.addAll(data.error(ErrorCode.CO_ALREADY_DEFINED_COMPONENT, ErrorDetails.component(((AbstractType)data.object).getName())));
        }
        for (Data data : this.facetNameToFacetData.values()) {
            if (data.blocks.size() <= 1) continue;
            this.errors.addAll(data.error(ErrorCode.CO_ALREADY_DEFINED_FACET, ErrorDetails.facet(((AbstractType)data.object).getName())));
        }
    }

    private void resolveComponents() {
        for (ComponentData data : this.componentNameToComponentData.values()) {
            AbstractBlockHolder holder = (AbstractBlockHolder)data.blocks.get(0);
            SourceReference sr = new SourceReference(data.object, holder.getFile(), holder.getLine());
            this.objectToSource.put(data.object, sr);
            if (!Utils.isEmptyOrWhitespaces(data.extendedComponentName)) {
                ComponentData extendedComponentData = this.componentNameToComponentData.get(data.extendedComponentName);
                if (extendedComponentData != null) {
                    ((Component)data.object).extendComponent((Component)extendedComponentData.object);
                } else {
                    this.errors.addAll(data.error(ErrorCode.CO_INEXISTING_COMPONENT, ErrorDetails.component(data.extendedComponentName)));
                }
            }
            for (String s : data.facetNames) {
                FacetData facetData = this.facetNameToFacetData.get(s);
                if (facetData != null) {
                    ((Component)data.object).associateFacet((Facet)facetData.object);
                    continue;
                }
                this.errors.addAll(data.error(ErrorCode.CO_INEXISTING_FACET, ErrorDetails.facet(s)));
            }
            for (String s : data.childrenNames) {
                ComponentData componentData = this.componentNameToComponentData.get(s);
                FacetData facetData = this.facetNameToFacetData.get(s);
                if (componentData != null) {
                    ((Component)data.object).addChild(componentData.object);
                    continue;
                }
                if (facetData != null) {
                    ((Component)data.object).addChild(facetData.object);
                    continue;
                }
                this.errors.addAll(data.error(ErrorCode.CO_INEXISTING_CHILD, ErrorDetails.name(s)));
            }
        }
    }

    private void resolveFacets() {
        for (FacetData data : this.facetNameToFacetData.values()) {
            AbstractBlockHolder holder = (AbstractBlockHolder)data.blocks.get(0);
            SourceReference sr = new SourceReference(data.object, holder.getFile(), holder.getLine());
            this.objectToSource.put(data.object, sr);
            for (String s : data.extendedFacetNames) {
                FacetData facetData = this.facetNameToFacetData.get(s);
                if (facetData != null) {
                    ((Facet)data.object).extendFacet((Facet)facetData.object);
                    continue;
                }
                this.errors.addAll(data.error(ErrorCode.CO_INEXISTING_FACET, ErrorDetails.facet(s)));
            }
            for (String s : data.childrenNames) {
                ComponentData componentData = this.componentNameToComponentData.get(s);
                FacetData facetData = this.facetNameToFacetData.get(s);
                if (componentData != null) {
                    ((Facet)data.object).addChild(componentData.object);
                    continue;
                }
                if (facetData != null) {
                    ((Facet)data.object).addChild(facetData.object);
                    continue;
                }
                this.errors.addAll(data.error(ErrorCode.CO_INEXISTING_CHILD, ErrorDetails.name(s)));
            }
        }
    }

    private Graphs buildFinalGraphs() {
        Graphs result = new Graphs();
        for (ComponentData cd : this.componentNameToComponentData.values()) {
            if (!ComponentHelpers.findAllAncestors((Component)cd.object).isEmpty()) continue;
            result.getRootComponents().add((Component)cd.object);
        }
        for (FacetData data : this.facetNameToFacetData.values()) {
            result.getFacetNameToFacet().put(((Facet)data.object).getName(), (Facet)data.object);
        }
        return result;
    }

    private static class FacetData
    extends Data<Facet> {
        Collection<String> extendedFacetNames = new HashSet<String>();

        private FacetData() {
        }
    }

    private static class ComponentData
    extends Data<Component> {
        String extendedComponentName;
        Collection<String> facetNames = new HashSet<String>();

        private ComponentData() {
        }
    }

    private static class Data<T extends AbstractType> {
        T object;
        Collection<String> childrenNames = new HashSet<String>();
        List<AbstractBlockHolder> blocks = new ArrayList<AbstractBlockHolder>();

        private Data() {
        }

        List<ParsingError> error(ErrorCode code, ErrorDetails ... details) {
            ArrayList<ParsingError> errors = new ArrayList<ParsingError>();
            for (AbstractBlockHolder block : this.blocks) {
                ParsingError error = new ParsingError(code, block.getDeclaringFile().getEditedFile(), block.getLine(), details);
                errors.add(error);
            }
            return errors;
        }
    }
}

