/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.roboconf.core.dsl.parsing.AbstractBlock;
import net.roboconf.core.dsl.parsing.BlockBlank;
import net.roboconf.core.dsl.parsing.BlockComment;
import net.roboconf.core.dsl.parsing.BlockComponent;
import net.roboconf.core.dsl.parsing.BlockFacet;
import net.roboconf.core.dsl.parsing.BlockProperty;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.ExportedVariable;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.utils.Utils;

public class FromGraphs {
    public FileDefinition buildFileDefinition(Graphs graphs, File targetFile, boolean addComment) {
        FileDefinition result = new FileDefinition(targetFile);
        result.setFileType(1);
        if (addComment) {
            String s = "# File created from an in-memory model,\n# without a binding to existing files.";
            BlockComment initialComment = new BlockComment(result, s);
            result.getBlocks().add(initialComment);
            result.getBlocks().add(new BlockBlank(result, "\n"));
        }
        HashSet<String> alreadySerializedNames = new HashSet<String>();
        for (Component c : ComponentHelpers.findAllComponents(graphs)) {
            if (alreadySerializedNames.contains(c.getName())) continue;
            alreadySerializedNames.add(c.getName());
            result.getBlocks().addAll(this.buildComponent(result, c, addComment));
            for (Facet f : ComponentHelpers.findAllFacets(c)) {
                if (alreadySerializedNames.contains(f.getName())) continue;
                alreadySerializedNames.add(f.getName());
                result.getBlocks().addAll(this.buildFacet(result, f, addComment));
            }
        }
        for (Facet f : graphs.getFacetNameToFacet().values()) {
            if (alreadySerializedNames.contains(f.getName())) continue;
            alreadySerializedNames.add(f.getName());
            result.getBlocks().addAll(this.buildFacet(result, f, addComment));
        }
        return result;
    }

    private Collection<AbstractBlock> buildComponent(FileDefinition file, Component component, boolean addComment) {
        String s;
        BlockProperty p;
        ArrayList<AbstractBlock> result = new ArrayList<AbstractBlock>();
        if (addComment) {
            StringBuilder sb = new StringBuilder();
            sb.append("# Component '");
            sb.append(component.getName());
            sb.append("'");
            result.add(new BlockComment(file, sb.toString()));
        }
        BlockComponent blockComponent = new BlockComponent(file);
        blockComponent.setName(component.getName());
        result.add(blockComponent);
        result.add(new BlockBlank(file, "\n"));
        if (component.getExtendedComponent() != null) {
            p = new BlockProperty(file, "extends", component.getExtendedComponent().getName());
            blockComponent.getInnerBlocks().add(p);
        }
        if (!Utils.isEmptyOrWhitespaces(component.getInstallerName())) {
            p = new BlockProperty(file, "installer", component.getInstallerName());
            blockComponent.getInnerBlocks().add(p);
        }
        if (!Utils.isEmptyOrWhitespaces(s = this.writeCollection(component.getFacets()))) {
            p = new BlockProperty(file, "facets", s);
            blockComponent.getInnerBlocks().add(p);
        }
        StringBuilder sb = new StringBuilder();
        Iterator<ImportedVariable> it = component.importedVariables.values().iterator();
        while (it.hasNext()) {
            ImportedVariable var = it.next();
            if (var.isExternal()) {
                sb.append("external");
                sb.append(" ");
            }
            sb.append(var.getName());
            if (var.isOptional()) {
                sb.append(" ");
                sb.append("(optional)");
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        if (!Utils.isEmptyOrWhitespaces(sb.toString())) {
            p = new BlockProperty(file, "imports", sb.toString());
            blockComponent.getInnerBlocks().add(p);
        }
        if (!Utils.isEmptyOrWhitespaces(s = this.writeExportedVariables(component))) {
            p = new BlockProperty(file, "exports", s);
            blockComponent.getInnerBlocks().add(p);
        }
        if (!Utils.isEmptyOrWhitespaces(s = this.writeCollection(component.getChildren()))) {
            p = new BlockProperty(file, "children", s);
            blockComponent.getInnerBlocks().add(p);
        }
        return result;
    }

    private Collection<AbstractBlock> buildFacet(FileDefinition file, Facet facet, boolean addComment) {
        BlockProperty p;
        ArrayList<AbstractBlock> result = new ArrayList<AbstractBlock>();
        if (addComment) {
            StringBuilder sb = new StringBuilder();
            sb.append("# Facet '");
            sb.append(facet.getName());
            sb.append("'");
            result.add(new BlockComment(file, sb.toString()));
        }
        BlockFacet blockFacet = new BlockFacet(file);
        blockFacet.setName(facet.getName());
        result.add(blockFacet);
        result.add(new BlockBlank(file, "\n"));
        String s = this.writeCollection(facet.getExtendedFacets());
        if (!Utils.isEmptyOrWhitespaces(s)) {
            p = new BlockProperty(file, "extends", s);
            blockFacet.getInnerBlocks().add(p);
        }
        if (!Utils.isEmptyOrWhitespaces(s = this.writeExportedVariables(facet))) {
            p = new BlockProperty(file, "exports", s);
            blockFacet.getInnerBlocks().add(p);
        }
        if (!Utils.isEmptyOrWhitespaces(s = this.writeCollection(facet.getChildren()))) {
            p = new BlockProperty(file, "children", s);
            blockFacet.getInnerBlocks().add(p);
        }
        return result;
    }

    private String writeExportedVariables(AbstractType type) {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, ExportedVariable>> it = type.exportedVariables.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ExportedVariable> entry = it.next();
            sb.append(entry.getKey());
            String variableValue = entry.getValue().getValue();
            if (!Utils.isEmptyOrWhitespaces(variableValue)) {
                sb.append("=\"");
                sb.append(variableValue);
                sb.append("\"");
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private String writeCollection(Collection<? extends AbstractType> types) {
        StringBuilder sb = new StringBuilder();
        Iterator<? extends AbstractType> it = types.iterator();
        while (it.hasNext()) {
            sb.append(it.next().getName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

