/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl.parsing;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.roboconf.core.dsl.parsing.AbstractBlock;
import net.roboconf.core.model.ParsingError;

public class FileDefinition {
    public static final int UNDETERMINED = 0;
    public static final int GRAPH = 1;
    public static final int INSTANCE = 2;
    public static final int AGGREGATOR = 3;
    public static final int EMPTY = 4;
    private File editedFile;
    private int fileType = 0;
    private final List<ParsingError> parsingErrors = new ArrayList<ParsingError>();
    private final List<AbstractBlock> blocks = new ArrayList<AbstractBlock>();

    public FileDefinition(File editedFile) {
        this.editedFile = editedFile;
    }

    public void setEditedFile(File editedFile) {
        this.editedFile = editedFile;
    }

    public File getEditedFile() {
        return this.editedFile;
    }

    public List<ParsingError> getParsingErrors() {
        return this.parsingErrors;
    }

    public List<AbstractBlock> getBlocks() {
        return this.blocks;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int fileType) {
        if (fileType != 1 && fileType != 2 && fileType != 3 && fileType != 4) {
            throw new IllegalArgumentException("The file type was expected to be GRAPH, INSTANCE, AGGREGATOR or EMPTY.");
        }
        this.fileType = fileType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.editedFile.getName());
        sb.append(" with ");
        sb.append(this.blocks.size());
        sb.append(" block");
        if (this.blocks.size() > 1) {
            sb.append("s");
        }
        return sb.toString();
    }

    public static String fileTypeAsString(int fileType) {
        String result;
        switch (fileType) {
            case 3: {
                result = "aggregator";
                break;
            }
            case 1: {
                result = "graph";
                break;
            }
            case 2: {
                result = "intsnace";
                break;
            }
            case 0: {
                result = "undetermined";
                break;
            }
            default: {
                result = "unknown";
            }
        }
        return result;
    }
}

