/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.errors;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public enum ErrorCode {
    P_IO_ERROR(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_ONE_BLOCK_PER_LINE(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_PROPERTY_ENDS_WITH_SEMI_COLON(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_IMPORT_ENDS_WITH_SEMI_COLON(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_O_C_BRACKET_EXTRA_CHARACTERS(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_C_C_BRACKET_EXTRA_CHARACTERS(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_O_C_BRACKET_MISSING(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_C_C_BRACKET_MISSING(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_UNRECOGNIZED_BLOCK(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_INVALID_PROPERTY(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_INVALID_PROPERTY_OR_INSTANCE(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_INVALID_FILE_TYPE(ErrorLevel.SEVERE, ErrorCategory.PARSING, new String[0]),
    P_EMPTY_FILE(ErrorLevel.WARNING, ErrorCategory.PARSING, new String[0]),
    PM_INVALID_BLOCK_TYPE(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_UNKNOWN_PROPERTY_NAME(ErrorLevel.WARNING, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_FORBIDDEN_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_EMPTY_PROPERTY_VALUE(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_EMPTY_IMPORT_LOCATION(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_EMPTY_FACET_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_EMPTY_REFERENCED_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_EMPTY_COMPONENT_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_EMPTY_VARIABLE_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_INVALID_CHILD_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, "[a-zA-Z_](\\w|-|\\.)*"),
    PM_INVALID_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, "[a-zA-Z_](\\w|-|\\.)*"),
    PM_INVALID_EXPORT_COMPLEX_VALUE(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_INVALID_EXPORTED_VAR_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_EXTERNAL_IS_KEYWORD_FOR_IMPORTS(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, "external"),
    PM_INVALID_IMPORTED_VAR_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_INVALID_INSTALLER_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, "[a-zA-Z_](\\w|-| |\\.)*"),
    PM_INVALID_INSTANCE_ELEMENT(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_INVALID_INSTANCE_COUNT(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_USELESS_INSTANCE_COUNT(ErrorLevel.WARNING, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_PROPERTY_NOT_APPLIABLE(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_DUPLICATE_PROPERTY(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_MISSING_INSTANCE_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_INVALID_INSTANCE_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, "[a-zA-Z_](\\w|-| |\\.)*"),
    PM_DOT_IS_NOT_ALLOWED(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_INCOMPLETE_IMPORTED_VAR_NAME(ErrorLevel.SEVERE, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_MALFORMED_COMMENT(ErrorLevel.WARNING, ErrorCategory.PARSING_MODEL, new String[0]),
    PM_MALFORMED_BLANK(ErrorLevel.WARNING, ErrorCategory.PARSING_MODEL, new String[0]),
    CO_NOT_A_GRAPH(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_NOT_INSTANCES(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_UNREACHABLE_FILE(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_ALREADY_DEFINED_FACET(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_ALREADY_DEFINED_COMPONENT(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_CYCLE_IN_COMPONENTS_INHERITANCE(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_ALREADY_DEFINED_INSTANCE(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_CONFLICTING_INFERRED_INSTANCE(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_INEXISTING_CHILD(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_INEXISTING_COMPONENT(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_INEXISTING_FACET(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_CONFLICTING_NAME(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    CO_GRAPH_COULD_NOT_BE_BUILT(ErrorLevel.SEVERE, ErrorCategory.CONVERSION, new String[0]),
    RM_MISSING_APPLICATION_NAME(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_INVALID_APPLICATION_NAME(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, "[a-zA-Z_](\\w|[-.() ])*"),
    RM_MISSING_APPLICATION_DSL_ID(ErrorLevel.WARNING, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_MISSING_APPLICATION_VERSION(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_MISSING_APPLICATION_GEP(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_MISSING_APPLICATION_GRAPHS(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_MISSING_APPLICATION_EXPORT_PREFIX(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_INVALID_APPLICATION_VERSION(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_DOT_IS_NOT_ALLOWED(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_EMPTY_COMPONENT_NAME(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_EMPTY_FACET_NAME(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_INVALID_COMPONENT_NAME(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, "[a-zA-Z_](\\w|-| |\\.)*"),
    RM_INVALID_FACET_NAME(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, "[a-zA-Z_](\\w|-| |\\.)*"),
    RM_EMPTY_COMPONENT_INSTALLER(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_INVALID_COMPONENT_INSTALLER(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, "[a-zA-Z_](\\w|-| |\\.)*"),
    RM_COMPONENT_IMPORTS_EXPORTS(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_ROOT_INSTALLER_MUST_BE_TARGET(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_EMPTY_VARIABLE_NAME(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_INVALID_VARIABLE_NAME(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, "[a-zA-Z_](\\w|-|\\.)*"),
    RM_INVALID_APPLICATION_EXPORT_PREFIX(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, "[a-zA-Z_](\\w|-| |\\.)*"),
    RM_MAGIC_INSTANCE_VARIABLE(ErrorLevel.WARNING, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_MISSING_VARIABLE_VALUE(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_AMBIGUOUS_OVERRIDING(ErrorLevel.WARNING, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_INVALID_EXTERNAL_EXPORT(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_ALREADY_DEFINED_EXTERNAL_EXPORT(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_INVALID_RANDOM_KIND(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_NO_VALUE_FOR_RANDOM(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_CYCLE_IN_COMPONENTS(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_CYCLE_IN_COMPONENTS_INHERITANCE(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_CYCLE_IN_FACETS_INHERITANCE(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_NO_ROOT_COMPONENT(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_NOT_A_ROOT_COMPONENT(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_UNRESOLVABLE_VARIABLE(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_UNRESOLVABLE_FACET_VARIABLE(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_EMPTY_INSTANCE_NAME(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_INVALID_INSTANCE_NAME(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, "[a-zA-Z_](\\w|-| |\\.)*"),
    RM_EMPTY_INSTANCE_COMPONENT(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_MISSING_INSTANCE_PARENT(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_INVALID_INSTANCE_PARENT(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_UNREACHABLE_COMPONENT(ErrorLevel.SEVERE, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_ORPHAN_FACET(ErrorLevel.WARNING, ErrorCategory.RUNTIME_MODEL, new String[0]),
    RM_ORPHAN_FACET_WITH_CHILDREN(ErrorLevel.WARNING, ErrorCategory.RUNTIME_MODEL, new String[0]),
    PROJ_NO_GRAPH_DIR(ErrorLevel.SEVERE, ErrorCategory.PROJECT, new String[0]),
    PROJ_NO_DESC_DIR(ErrorLevel.SEVERE, ErrorCategory.PROJECT, new String[0]),
    PROJ_NO_DESC_FILE(ErrorLevel.SEVERE, ErrorCategory.PROJECT, new String[0]),
    PROJ_MISSING_GRAPH_EP(ErrorLevel.SEVERE, ErrorCategory.PROJECT, new String[0]),
    PROJ_MISSING_INSTANCE_EP(ErrorLevel.SEVERE, ErrorCategory.PROJECT, new String[0]),
    PROJ_EXTRACT_TEMP(ErrorLevel.SEVERE, ErrorCategory.PROJECT, new String[0]),
    PROJ_EXTRACT_ZIP(ErrorLevel.SEVERE, ErrorCategory.PROJECT, new String[0]),
    PROJ_DELETE_TEMP(ErrorLevel.WARNING, ErrorCategory.PROJECT, new String[0]),
    PROJ_READ_DESC_FILE(ErrorLevel.SEVERE, ErrorCategory.PROJECT, new String[0]),
    PROJ_INVALID_EXTERNAL_EXPORTS(ErrorLevel.SEVERE, ErrorCategory.PROJECT, new String[0]),
    PROJ_NO_RESOURCE_DIRECTORY(ErrorLevel.WARNING, ErrorCategory.PROJECT, new String[0]),
    PROJ_APPLICATION_TEMPLATE_NOT_FOUND(ErrorLevel.SEVERE, ErrorCategory.PROJECT, new String[0]),
    PROJ_INVALID_COMMAND_EXT(ErrorLevel.SEVERE, ErrorCategory.PROJECT, ".commands"),
    PROJ_INVALID_RULE_EXT(ErrorLevel.SEVERE, ErrorCategory.PROJECT, ".drl"),
    PROJ_UNREACHABLE_FILE(ErrorLevel.WARNING, ErrorCategory.PROJECT, new String[0]),
    PROJ_INVALID_FILE_LOCATION(ErrorLevel.WARNING, ErrorCategory.PROJECT, new String[0]),
    REC_PUPPET_DISLIKES_WILDCARD_IMPORTS(ErrorLevel.WARNING, ErrorCategory.RECIPES, new String[0]),
    REC_PUPPET_HAS_NO_RBCF_MODULE(ErrorLevel.SEVERE, ErrorCategory.RECIPES, new String[0]),
    REC_PUPPET_HAS_TOO_MANY_RBCF_MODULES(ErrorLevel.SEVERE, ErrorCategory.RECIPES, new String[0]),
    REC_PUPPET_MISSING_PARAM_IMPORT_DIFF(ErrorLevel.SEVERE, ErrorCategory.RECIPES, new String[0]),
    REC_PUPPET_MISSING_PARAM_RUNNING_STATE(ErrorLevel.SEVERE, ErrorCategory.RECIPES, new String[0]),
    REC_PUPPET_MISSING_PARAM_FROM_IMPORT(ErrorLevel.WARNING, ErrorCategory.RECIPES, new String[0]),
    REC_PUPPET_SYNTAX_ERROR(ErrorLevel.SEVERE, ErrorCategory.RECIPES, new String[0]),
    REC_SCRIPT_NO_SCRIPTS_DIR(ErrorLevel.SEVERE, ErrorCategory.RECIPES, new String[0]),
    REC_ARTIFACT_ID_IN_LOWER_CASE(ErrorLevel.WARNING, ErrorCategory.RECIPES, new String[0]),
    REC_MISSING_README(ErrorLevel.WARNING, ErrorCategory.RECIPES, new String[0]),
    REC_OFFICIAL_GROUP_ID(ErrorLevel.WARNING, ErrorCategory.RECIPES, "net.roboconf.recipes"),
    REC_NON_MATCHING_ARTIFACT_ID(ErrorLevel.WARNING, ErrorCategory.RECIPES, new String[0]),
    REC_AVOID_INSTANCES(ErrorLevel.WARNING, ErrorCategory.RECIPES, new String[0]),
    REC_TARGET_NO_ID(ErrorLevel.SEVERE, ErrorCategory.RECIPES, new String[0]),
    REC_TARGET_NO_HANDLER(ErrorLevel.SEVERE, ErrorCategory.RECIPES, new String[0]),
    REC_TARGET_INVALID_FILE_OR_CONTENT(ErrorLevel.SEVERE, ErrorCategory.RECIPES, new String[0]),
    REC_TARGET_CONFLICTING_ID(ErrorLevel.SEVERE, ErrorCategory.RECIPES, new String[0]),
    REC_TARGET_NO_NAME(ErrorLevel.WARNING, ErrorCategory.RECIPES, new String[0]),
    REC_TARGET_NO_PROPERTIES(ErrorLevel.SEVERE, ErrorCategory.RECIPES, new String[0]),
    CMD_INVALID_TARGET_ID(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_NO_MATCHING_INSTANCE(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_NOT_AN_ACCEPTABLE_PARENT(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_CANNOT_HAVE_ANY_PARENT(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_NOT_A_SCOPED_INSTANCE(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_NOT_A_ROOT_INSTANCE(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_UNRECOGNIZED_INSTRUCTION(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_INVALID_INSTANCE_STATUS(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_INSTABLE_INSTANCE_STATUS(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_EMPTY_VARIABLE_NAME(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_MISSING_INSTANCE_NAME(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_INVALID_INSTANCE_NAME(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, "[a-zA-Z_](\\w|-| |\\.)*"),
    CMD_MISSING_COMPONENT_NAME(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_INEXISTING_COMPONENT(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_MISSING_PARENT_INSTANCE(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_CONFLICTING_INSTANCE_NAME(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_EMAIL_NO_MESSAGE(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_NO_INSTRUCTION(ErrorLevel.WARNING, ErrorCategory.COMMANDS, new String[0]),
    CMD_UNRESOLVED_VARIABLE(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_INVALID_SYNTAX(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_MISSING_TARGET_FILE(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_MISSING_COMMAND_NAME(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_INEXISTING_COMMAND(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_INEXISTING_COMMAND_FILE(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_LOOPING_COMMAND(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_NASTY_LOOPING_COMMAND(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_INVALID_DATE_PATTERN(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_NO_MIX_FOR_PATTERNS(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    CMD_INVALID_INDEX_PATTERN(ErrorLevel.SEVERE, ErrorCategory.COMMANDS, new String[0]),
    RULE_IO_ERROR(ErrorLevel.SEVERE, ErrorCategory.RULES, new String[0]),
    RULE_EMPTY_NAME(ErrorLevel.SEVERE, ErrorCategory.RULES, new String[0]),
    RULE_INVALID_SYNTAX(ErrorLevel.SEVERE, ErrorCategory.RULES, new String[0]),
    RULE_EMPTY_WHEN(ErrorLevel.SEVERE, ErrorCategory.RULES, new String[0]),
    RULE_EMPTY_THEN(ErrorLevel.SEVERE, ErrorCategory.RULES, new String[0]),
    RULE_UNKNOWN_COMMAND(ErrorLevel.SEVERE, ErrorCategory.RULES, new String[0]),
    REST_TARGET_CONTAINS_ERROR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_TARGET_ASSOCIATION_ERROR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_TARGET_HINT_ERROR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_AUTH_NO_MNGR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_AUTH_FAILED(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_SCHEDULER_IS_UNAVAILABLE(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_INEXISTING(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_MISSING_PROPERTY(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_DELETION_ERROR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_IO_ERROR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_UNDETAILED_ERROR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_MESSAGING_ERROR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_SAVE_ERROR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_MNGMT_ZIP_ERROR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_MNGMT_INVALID_TPL(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_MNGMT_INVALID_URL(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_MNGMT_CONFLICT(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_MNGMT_APP_SHUTDOWN_ERROR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_MNGMT_INVALID_IMAGE(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_APP_EXEC_ERROR(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_DEBUG_AGENT_KO(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]),
    REST_DEBUG_MSG_SENT(ErrorLevel.SEVERE, ErrorCategory.REST, new String[0]);

    private static final Map<ErrorCategory, AtomicInteger> CAT_TO_ID;
    private final ErrorCategory category;
    private final ErrorLevel level;
    private int errorId;
    private String[] i18nProperties;

    private ErrorCode(ErrorLevel level, ErrorCategory category, String ... i18nProperties) {
        this.category = category;
        this.level = level;
        this.i18nProperties = i18nProperties;
    }

    public ErrorCategory getCategory() {
        return this.category;
    }

    public ErrorLevel getLevel() {
        return this.level;
    }

    public int getErrorId() {
        return this.errorId;
    }

    public String[] getI18nProperties() {
        return Arrays.asList(this.i18nProperties).toArray(new String[this.i18nProperties.length]);
    }

    static {
        CAT_TO_ID = new HashMap<ErrorCategory, AtomicInteger>();
        for (ErrorCategory errorCategory : ErrorCategory.values()) {
            CAT_TO_ID.put(errorCategory, new AtomicInteger(0));
        }
        for (Enum enum_ : ErrorCode.values()) {
            ((ErrorCode)enum_).errorId = CAT_TO_ID.get((Object)((ErrorCode)enum_).category).getAndIncrement();
        }
    }

    public static enum ErrorLevel {
        SEVERE,
        WARNING;

    }

    public static enum ErrorCategory {
        PARSING,
        PARSING_MODEL,
        CONVERSION,
        RUNTIME_MODEL,
        PROJECT,
        RECIPES,
        COMMANDS,
        RULES,
        EXECUTION,
        REST;

    }
}

