/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.errors.i18n;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.utils.Utils;

public class TranslationBundle
extends ListResourceBundle {
    public static final String DETAILS_SEPARATOR = "@details-separator@";
    public static final String EN = "en_EN";
    public static final String FR = "fr_FR";
    static final List<String> LANGUAGES = Arrays.asList("en_EN", "fr_FR");
    static final String ROW_PATTERN = "\"([^\"]+)\"\\s*:\\s*\"([^\"]+)\"";
    private final String lang;

    public TranslationBundle(String lang) {
        this.lang = TranslationBundle.resolve(lang);
    }

    public String getLang() {
        return this.lang;
    }

    @Override
    protected Object[][] getContents() {
        Map<String, String> map = TranslationBundle.loadContent(this.lang);
        Object[][] result = new Object[map.size()][2];
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result[i][0] = entry.getKey();
            result[i][1] = entry.getValue();
            ++i;
        }
        return result;
    }

    public static String resolve(String lang) {
        String result = !LANGUAGES.contains(lang) ? EN : lang;
        return result;
    }

    static Map<String, String> loadContent(String lang) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            InputStream in = TranslationBundle.class.getResourceAsStream("/" + lang + ".json");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Utils.copyStreamSafely(in, os);
            String content = os.toString("UTF-8");
            Matcher m = Pattern.compile(ROW_PATTERN).matcher(content);
            while (m.find()) {
                String s = m.group(2);
                try {
                    ErrorCode ec = ErrorCode.valueOf(m.group(1));
                    for (int i = 0; i < ec.getI18nProperties().length; ++i) {
                        s = s.replace("{" + i + "}", ec.getI18nProperties()[i]);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                result.put(m.group(1), s);
            }
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(TranslationBundle.class.getName());
            Utils.logException(logger, e);
        }
        return result;
    }
}

