/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.internal.dsl.parsing;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.utils.Utils;

public class ExportedVariablesParser {
    public final Map<String, String> rawNameToVariables = new LinkedHashMap<String, String>();
    public final List<ParsingError> errors = new ArrayList<ParsingError>();
    private int cursor;

    public void parse(String line, File sourceFile, int lineNumber) {
        this.rawNameToVariables.clear();
        this.errors.clear();
        this.cursor = 0;
        while (this.cursor < line.length()) {
            char c = line.charAt(this.cursor);
            if (Character.isWhitespace(c) || c == ',') {
                ++this.cursor;
            }
            this.recognizeVariable(line, sourceFile, lineNumber);
        }
    }

    private void recognizeVariable(String line, File sourceFile, int lineNumber) {
        char c = '#';
        StringBuilder sb = new StringBuilder();
        while (this.cursor < line.length()) {
            char c2 = line.charAt(this.cursor);
            c = c2;
            if (c2 == ',' || c == 61) break;
            sb.append(c);
            ++this.cursor;
        }
        String variableName = sb.toString().trim();
        if (c == ',' || this.cursor >= line.length()) {
            if (Utils.isEmptyOrWhitespaces(variableName)) {
                this.errors.add(new ParsingError(ErrorCode.PM_EMPTY_VARIABLE_NAME, sourceFile, lineNumber));
            } else {
                this.rawNameToVariables.put(variableName, null);
            }
            return;
        }
        ++this.cursor;
        sb = new StringBuilder();
        while (this.cursor < line.length() && (c = line.charAt(this.cursor)) != ',' && c != '\"') {
            sb.append(c);
            ++this.cursor;
        }
        if (c == ',' || this.cursor >= line.length()) {
            String value = sb.toString().trim();
            if (value.isEmpty()) {
                value = null;
            }
            this.rawNameToVariables.put(variableName, value);
            return;
        }
        if (!Utils.isEmptyOrWhitespaces(sb.toString())) {
            this.errors.add(new ParsingError(ErrorCode.PM_INVALID_EXPORT_COMPLEX_VALUE, sourceFile, lineNumber, ErrorDetails.variable(variableName)));
            ++this.cursor;
            return;
        }
        ++this.cursor;
        sb = new StringBuilder();
        while (this.cursor < line.length() && (c = line.charAt(this.cursor)) != '\"') {
            sb.append(c);
            ++this.cursor;
        }
        if (c != '\"') {
            this.errors.add(new ParsingError(ErrorCode.PM_INVALID_EXPORT_COMPLEX_VALUE, sourceFile, lineNumber, ErrorDetails.variable(variableName)));
            return;
        }
        ++this.cursor;
        while (this.cursor < line.length() && (c = line.charAt(this.cursor)) != ',') {
            if (Character.isWhitespace(c)) {
                ++this.cursor;
                continue;
            }
            this.errors.add(new ParsingError(ErrorCode.PM_INVALID_EXPORT_COMPLEX_VALUE, sourceFile, lineNumber, ErrorDetails.variable(variableName)));
            return;
        }
        this.rawNameToVariables.put(variableName, sb.toString());
        ++this.cursor;
    }
}

