/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.internal.dsl.parsing;

import java.util.Iterator;
import net.roboconf.core.dsl.ParsingModelValidator;
import net.roboconf.core.dsl.parsing.AbstractBlock;
import net.roboconf.core.dsl.parsing.AbstractBlockHolder;
import net.roboconf.core.dsl.parsing.BlockBlank;
import net.roboconf.core.dsl.parsing.BlockComment;
import net.roboconf.core.dsl.parsing.BlockComponent;
import net.roboconf.core.dsl.parsing.BlockFacet;
import net.roboconf.core.dsl.parsing.BlockImport;
import net.roboconf.core.dsl.parsing.BlockInstanceOf;
import net.roboconf.core.dsl.parsing.BlockProperty;
import net.roboconf.core.dsl.parsing.FileDefinition;

public class FileDefinitionSerializer {
    private String lineSeparator = System.getProperty("line.separator");

    public FileDefinitionSerializer() {
    }

    public FileDefinitionSerializer(String lineSeparator) {
        if (lineSeparator != null) {
            this.lineSeparator = lineSeparator;
        }
    }

    public String write(FileDefinition definitionFile, boolean writeComments) {
        StringBuilder sb = new StringBuilder();
        Iterator<AbstractBlock> it = definitionFile.getBlocks().iterator();
        while (it.hasNext()) {
            sb.append(this.write(it.next(), writeComments));
            if (!it.hasNext()) continue;
            sb.append(this.lineSeparator);
        }
        return sb.toString();
    }

    public String write(AbstractBlock block, boolean writeComments) {
        String result = null;
        switch (block.getInstructionType()) {
            case 3: {
                result = this.write((BlockComponent)block, writeComments);
                break;
            }
            case 2: {
                result = this.write((BlockFacet)block, writeComments);
                break;
            }
            case 6: {
                result = this.write((BlockInstanceOf)block, writeComments, 0);
                break;
            }
            case 1: {
                result = this.write((BlockImport)block, writeComments);
                break;
            }
            case 0: {
                result = this.write((BlockProperty)block, writeComments);
                break;
            }
            case 4: {
                result = this.write((BlockComment)block, writeComments);
                break;
            }
            case 5: {
                result = this.write((BlockBlank)block, writeComments);
                break;
            }
        }
        return result;
    }

    public String write(BlockImport block, boolean writeComments) {
        StringBuilder sb = new StringBuilder();
        sb.append("import ");
        sb.append(block.getUri());
        sb.append(";");
        if (writeComments && block.getInlineComment() != null) {
            sb.append(block.getInlineComment());
        }
        return sb.toString();
    }

    public String write(BlockComponent block, boolean writeComments) {
        return this.writePropertiesHolder(block, writeComments, 0);
    }

    public String write(BlockFacet block, boolean writeComments) {
        return "facet " + this.writePropertiesHolder(block, writeComments, 0);
    }

    public String write(BlockInstanceOf block, boolean writeComments, int indentationLevel) {
        StringBuilder sb = new StringBuilder();
        this.indent(sb, indentationLevel);
        sb.append("instance of");
        sb.append(" ");
        sb.append(this.writePropertiesHolder(block, writeComments, indentationLevel));
        return sb.toString();
    }

    public String write(BlockBlank block, boolean writeComments) {
        StringBuilder sb = new StringBuilder();
        if (ParsingModelValidator.validate(block).isEmpty()) {
            sb.append(block.getContent());
        } else {
            sb.append(this.lineSeparator);
        }
        return sb.toString();
    }

    public String write(BlockProperty block, boolean writeComments) {
        StringBuilder sb = new StringBuilder();
        sb.append(block.getName());
        sb.append(": ");
        sb.append(block.getValue());
        sb.append(";");
        if (writeComments && block.getInlineComment() != null) {
            sb.append(block.getInlineComment());
        }
        return sb.toString();
    }

    public String write(BlockComment block, boolean writeComments) {
        StringBuilder sb = new StringBuilder();
        if (writeComments) {
            if (ParsingModelValidator.validate(block).isEmpty()) {
                sb.append(block.getContent());
            } else {
                for (String s : block.getContent().split("\n")) {
                    if (!s.trim().startsWith("#")) {
                        sb.append("# ");
                    }
                    sb.append(s);
                    sb.append(this.lineSeparator);
                }
            }
        }
        return sb.toString();
    }

    private String writePropertiesHolder(AbstractBlockHolder holder, boolean writeComments, int indentationLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(holder.getName());
        sb.append(" {");
        if (writeComments && holder.getInlineComment() != null) {
            sb.append(holder.getInlineComment());
        }
        for (AbstractBlock block : holder.getInnerBlocks()) {
            sb.append(this.lineSeparator);
            if (block.getInstructionType() == 6) {
                sb.append(this.write((BlockInstanceOf)block, writeComments, indentationLevel + 1));
                continue;
            }
            if (block.getInstructionType() == 0) {
                this.indent(sb, indentationLevel + 1);
            }
            sb.append(this.write(block, writeComments));
        }
        sb.append(this.lineSeparator);
        this.indent(sb, indentationLevel);
        sb.append("}");
        if (writeComments && holder.getClosingInlineComment() != null) {
            sb.append(holder.getClosingInlineComment());
        }
        return sb.toString();
    }

    private void indent(StringBuilder sb, int indentationLevel) {
        for (int i = 0; i < indentationLevel; ++i) {
            sb.append("\t");
        }
    }
}

