/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.ModelError;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.utils.ResourceUtils;
import net.roboconf.core.utils.Utils;

public class TargetValidator {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean failed = false;
    private String fileName;
    private Object modelObject;
    private final List<ModelError> errors = new ArrayList<ModelError>();
    private Properties props;

    public TargetValidator(String propertiesFileContent) {
        this.props = new Properties();
        try {
            this.props.load(new ByteArrayInputStream(propertiesFileContent.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            this.failed = true;
            Utils.logException(this.logger, e);
        }
    }

    public TargetValidator(File propertiesFile) {
        try {
            this.props = Utils.readPropertiesFile(propertiesFile);
            this.fileName = propertiesFile.getName();
        }
        catch (Exception e) {
            this.failed = true;
            Utils.logException(this.logger, e);
        }
    }

    public TargetValidator(File propertiesFile, Object modelObject) {
        this(propertiesFile);
        this.modelObject = modelObject;
    }

    public void validate() {
        ErrorDetails details = null;
        if (this.fileName != null) {
            details = ErrorDetails.file(this.fileName);
        }
        if (this.failed) {
            this.errors.add(new ModelError(ErrorCode.REC_TARGET_INVALID_FILE_OR_CONTENT, this.modelObject, details));
        } else {
            String name;
            String handler;
            String id = this.props.getProperty("id");
            if (Utils.isEmptyOrWhitespaces(id)) {
                this.errors.add(new ModelError(ErrorCode.REC_TARGET_NO_ID, this.modelObject, details));
            }
            if (Utils.isEmptyOrWhitespaces(handler = this.props.getProperty("handler"))) {
                this.errors.add(new ModelError(ErrorCode.REC_TARGET_NO_HANDLER, this.modelObject, details));
            }
            if (Utils.isEmptyOrWhitespaces(name = this.props.getProperty("name"))) {
                this.errors.add(new ModelError(ErrorCode.REC_TARGET_NO_NAME, this.modelObject, details));
            }
        }
    }

    public List<ModelError> getErrors() {
        return this.errors;
    }

    public Properties getProperties() {
        return this.props;
    }

    public static List<ModelError> parseDirectory(File directory) {
        return TargetValidator.parseDirectory(directory, null);
    }

    public static List<ModelError> parseDirectory(File directory, Component c) {
        ArrayList<ModelError> result = new ArrayList<ModelError>();
        HashSet<String> targetIds = new HashSet<String>();
        for (File f : Utils.listDirectFiles(directory, ".properties")) {
            TargetValidator tv = new TargetValidator(f, c);
            tv.validate();
            result.addAll(tv.getErrors());
            String id = tv.getProperties().getProperty("id");
            if (targetIds.contains(id)) {
                result.add(new ModelError(ErrorCode.REC_TARGET_CONFLICTING_ID, tv.modelObject, ErrorDetails.name(id)));
            }
            targetIds.add(id);
        }
        if (targetIds.isEmpty()) {
            result.add(new ModelError(ErrorCode.REC_TARGET_NO_PROPERTIES, (Object)null, ErrorDetails.directory(directory)));
        }
        return result;
    }

    public static List<ModelError> parseTargetProperties(File projectDirectory, Component c) {
        File dir = ResourceUtils.findInstanceResourcesDirectory(projectDirectory, c);
        List<ModelError> errors = dir.isDirectory() && !Utils.listAllFiles(dir, ".properties").isEmpty() ? TargetValidator.parseDirectory(dir, c) : new ArrayList<ModelError>(0);
        return errors;
    }
}

