/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.beans;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;

public class Application
extends AbstractApplication
implements Serializable {
    private static final long serialVersionUID = -4753958407033243184L;
    private final ApplicationTemplate template;
    private final Map<String, Set<String>> applicationBindings = new ConcurrentHashMap<String, Set<String>>();

    public Application(ApplicationTemplate template) {
        this.template = template;
        if (template != null) {
            template.associateApplication(this);
            for (Instance rootInstance : template.getRootInstances()) {
                this.getRootInstances().add(InstanceHelpers.replicateInstance(rootInstance));
            }
        }
    }

    public Application(String name, ApplicationTemplate template) {
        this(template);
        this.setName(name);
    }

    public ApplicationTemplate getTemplate() {
        return this.template;
    }

    @Override
    public Graphs getGraphs() {
        return this.template == null ? null : this.template.getGraphs();
    }

    public Map<String, String> getExternalExports() {
        return this.template != null ? this.template.externalExports : new HashMap(0);
    }

    public boolean equals(Object obj) {
        return obj instanceof Application && Objects.equals(this.name, ((Application)obj).getName());
    }

    public int hashCode() {
        return this.name == null ? 29 : this.name.hashCode();
    }

    public Application name(String name) {
        this.name = name;
        return this;
    }

    public Application description(String description) {
        this.description = description;
        return this;
    }

    public Application directory(File directory) {
        this.directory = directory;
        return this;
    }

    public void removeAssociationWithTemplate() {
        if (this.template != null) {
            this.template.removeApplicationAssocation(this);
        }
    }

    public void bindWithApplication(String externalExportPrefix, String applicationName) {
        Set<String> bounds = this.applicationBindings.get(externalExportPrefix);
        if (bounds == null) {
            bounds = new LinkedHashSet<String>();
            this.applicationBindings.put(externalExportPrefix, bounds);
        }
        bounds.add(applicationName);
    }

    public boolean unbindFromApplication(String externalExportPrefix, String applicationName) {
        boolean result = false;
        Set<String> bounds = this.applicationBindings.get(externalExportPrefix);
        if (bounds != null) {
            result = bounds.remove(applicationName);
            if (bounds.isEmpty()) {
                this.applicationBindings.remove(externalExportPrefix);
            }
        }
        return result;
    }

    public boolean replaceApplicationBindings(String externalExportPrefix, Set<String> applicationNames) {
        boolean changed = false;
        Set<String> oldApplicationNames = this.applicationBindings.remove(externalExportPrefix);
        if (oldApplicationNames == null) {
            changed = !applicationNames.isEmpty();
        } else if (oldApplicationNames.size() != applicationNames.size()) {
            changed = true;
        } else {
            oldApplicationNames.removeAll(applicationNames);
            boolean bl = changed = !oldApplicationNames.isEmpty();
        }
        if (!applicationNames.isEmpty()) {
            this.applicationBindings.put(externalExportPrefix, applicationNames);
        }
        return changed;
    }

    public Map<String, Set<String>> getApplicationBindings() {
        return Collections.unmodifiableMap(this.applicationBindings);
    }
}

