/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.Constants;
import net.roboconf.core.errors.RoboconfErrorHelpers;
import net.roboconf.core.model.ModelError;
import net.roboconf.core.model.RuntimeModelValidator;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.DockerAndScriptUtils;
import net.roboconf.core.utils.Utils;

public final class InstanceHelpers {
    private InstanceHelpers() {
    }

    public static String computeInstancePath(Instance inst) {
        StringBuilder sb = new StringBuilder();
        for (Instance current = inst; current != null; current = current.getParent()) {
            StringBuilder currentSb = new StringBuilder("/");
            if (!Utils.isEmptyOrWhitespaces(current.getName())) {
                currentSb.append(current.getName());
            }
            sb.insert(0, currentSb.toString());
        }
        return sb.toString();
    }

    public static boolean haveSamePath(Instance i1, Instance i2) {
        return InstanceHelpers.computeInstancePath(i1).equals(InstanceHelpers.computeInstancePath(i2));
    }

    public static String findInstanceName(String instancePath) {
        String instanceName = "";
        Matcher m = Pattern.compile("([^/]+)$").matcher(instancePath);
        if (m.find()) {
            instanceName = m.group(1);
        }
        return instanceName;
    }

    public static List<Instance> buildHierarchicalList(Instance inst) {
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        ArrayList<Instance> todo = new ArrayList<Instance>();
        if (inst != null) {
            todo.add(inst);
        }
        while (!todo.isEmpty()) {
            Instance current = (Instance)todo.remove(0);
            instanceList.add(current);
            todo.addAll(current.getChildren());
        }
        return instanceList;
    }

    public static void insertChild(Instance parent, Instance child) {
        child.setParent(parent);
        parent.getChildren().add(child);
    }

    public static Map<String, String> findAllExportedVariables(Instance instance) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (instance.getComponent() != null) {
            result.putAll(ComponentHelpers.findAllExportedVariables(instance.getComponent()));
        }
        HashMap<String, HashSet<String>> localNameToFullNames = new HashMap<String, HashSet<String>>();
        for (String string : result.keySet()) {
            String localName = VariableHelpers.parseVariableName(string).getValue();
            HashSet<String> fullNames = (HashSet<String>)localNameToFullNames.get(localName);
            if (fullNames == null) {
                fullNames = new HashSet<String>();
            }
            fullNames.add(string);
            localNameToFullNames.put(localName, fullNames);
        }
        for (Map.Entry entry : instance.overriddenExports.entrySet()) {
            Set fullNames = (Set)localNameToFullNames.get(entry.getKey());
            if (fullNames == null) {
                result.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (fullNames.size() == 1) {
                result.put((String)fullNames.iterator().next(), (String)entry.getValue());
                continue;
            }
            result.put((String)entry.getKey(), (String)entry.getValue());
            for (String name : fullNames) {
                result.put(name, (String)entry.getValue());
            }
        }
        String ip = InstanceHelpers.findRootInstance((Instance)instance).data.get("ip.address");
        if (ip != null) {
            VariableHelpers.updateNetworkVariables(result, ip);
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(result.size());
        for (Map.Entry entry : result.entrySet()) {
            String value = (String)entry.getValue();
            if (value != null) {
                for (Map.Entry<String, String> rbcfMetaVar : DockerAndScriptUtils.buildReferenceMap(instance).entrySet()) {
                    value = value.replace("$(" + rbcfMetaVar.getKey() + ")", rbcfMetaVar.getValue());
                }
            }
            linkedHashMap.put((String)entry.getKey(), value);
        }
        return linkedHashMap;
    }

    public static Instance findInstanceByPath(AbstractApplication application, String instancePath) {
        Collection<Instance> currentList = new ArrayList<Instance>();
        if (application != null) {
            currentList.addAll(application.getRootInstances());
        }
        ArrayList<String> instanceNames = new ArrayList<String>();
        if (instancePath != null) {
            instanceNames.addAll(Arrays.asList(instancePath.split("/")));
        }
        if (instanceNames.size() > 0 && Utils.isEmptyOrWhitespaces((String)instanceNames.get(0))) {
            instanceNames.remove(0);
        }
        Instance result = null;
        for (String instanceName : instanceNames) {
            result = null;
            for (Instance instance : currentList) {
                if (!instanceName.equals(instance.getName())) continue;
                result = instance;
                break;
            }
            if (result == null) break;
            currentList = result.getChildren();
        }
        return result;
    }

    public static Instance findInstanceByPath(Instance rootInstance, String instancePath) {
        Application tempApplication = new Application(new ApplicationTemplate());
        if (rootInstance != null) {
            tempApplication.getRootInstances().add(rootInstance);
        }
        return InstanceHelpers.findInstanceByPath(tempApplication, instancePath);
    }

    public static List<Instance> findInstancesByComponentName(AbstractApplication application, String componentName) {
        ArrayList<Instance> result = new ArrayList<Instance>();
        for (Instance inst : InstanceHelpers.getAllInstances(application)) {
            if (!componentName.equals(inst.getComponent().getName())) continue;
            result.add(inst);
        }
        return result;
    }

    public static Instance findRootInstance(Instance instance) {
        Instance rootInstance = instance;
        while (rootInstance.getParent() != null) {
            rootInstance = rootInstance.getParent();
        }
        return rootInstance;
    }

    public static Instance findScopedInstance(Instance instance) {
        Instance scopedInstance = instance;
        while (scopedInstance.getParent() != null && !InstanceHelpers.isTarget(scopedInstance)) {
            scopedInstance = scopedInstance.getParent();
        }
        return scopedInstance;
    }

    public static List<Instance> findAllScopedInstances(AbstractApplication app) {
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        ArrayList<Instance> todo = new ArrayList<Instance>();
        todo.addAll(app.getRootInstances());
        while (!todo.isEmpty()) {
            Instance current = (Instance)todo.remove(0);
            todo.addAll(current.getChildren());
            if (!InstanceHelpers.isTarget(current)) continue;
            instanceList.add(current);
        }
        return instanceList;
    }

    public static List<Instance> getAllInstances(AbstractApplication application) {
        ArrayList<Instance> result = new ArrayList<Instance>();
        for (Instance instance : application.getRootInstances()) {
            result.addAll(InstanceHelpers.buildHierarchicalList(instance));
        }
        return result;
    }

    public static boolean tryToInsertChildInstance(AbstractApplication application, Instance parentInstance, Instance childInstance) {
        boolean hasAlreadyAChildWithThisName = InstanceHelpers.hasChildWithThisName(application, parentInstance, childInstance.getName());
        boolean success = false;
        if (parentInstance == null) {
            if (!hasAlreadyAChildWithThisName && ComponentHelpers.findAllAncestors(childInstance.getComponent()).isEmpty()) {
                application.getRootInstances().add(childInstance);
                success = true;
            }
        } else if (!hasAlreadyAChildWithThisName && ComponentHelpers.findAllChildren(parentInstance.getComponent()).contains(childInstance.getComponent())) {
            InstanceHelpers.insertChild(parentInstance, childInstance);
            List<Instance> allInstances = InstanceHelpers.getAllInstances(application);
            Collection<ModelError> errors = RuntimeModelValidator.validate(allInstances);
            if (RoboconfErrorHelpers.containsCriticalErrors(errors)) {
                parentInstance.getChildren().remove(childInstance);
                childInstance.setParent(null);
            } else {
                success = true;
            }
        }
        return success;
    }

    public static boolean hasChildWithThisName(AbstractApplication application, Instance parentInstance, String nameToSearch) {
        boolean hasAlreadyAChildWithThisName = false;
        Collection<Instance> list = parentInstance == null ? application.getRootInstances() : parentInstance.getChildren();
        Iterator<Instance> it = list.iterator();
        while (it.hasNext() && !hasAlreadyAChildWithThisName) {
            hasAlreadyAChildWithThisName = Objects.equals(nameToSearch, it.next().getName());
        }
        return hasAlreadyAChildWithThisName;
    }

    public static File findInstanceDirectoryOnAgent(Instance instance) {
        String path = InstanceHelpers.computeInstancePath(instance);
        path = path.substring(1).replace('/', '_').replace(' ', '_');
        String installerName = ComponentHelpers.findComponentInstaller(instance.getComponent());
        return new File(Constants.WORK_DIRECTORY_AGENT, installerName + "/" + path);
    }

    public static int countInstances(String instancePath) {
        return instancePath.split("/").length - 1;
    }

    public static Instance replicateInstance(Instance instance) {
        HashMap<Instance, Instance> instanceToDuplicate = new HashMap<Instance, Instance>();
        ArrayList<Instance> toProcess = new ArrayList<Instance>();
        toProcess.add(instance);
        while (!toProcess.isEmpty()) {
            Instance current = (Instance)toProcess.remove(0);
            Instance copy = new Instance();
            copy.name(current.getName());
            copy.component(current.getComponent());
            copy.channels.addAll(current.channels);
            copy.overriddenExports.putAll(current.overriddenExports);
            instanceToDuplicate.put(current, copy);
            Instance parent = (Instance)instanceToDuplicate.get(current.getParent());
            if (parent != null) {
                InstanceHelpers.insertChild(parent, copy);
            }
            toProcess.addAll(current.getChildren());
        }
        return (Instance)instanceToDuplicate.get(instance);
    }

    public static boolean isTarget(Instance instance) {
        return instance.getComponent() != null && ComponentHelpers.isTarget(instance.getComponent());
    }

    public static void removeOffScopeInstances(Instance scopedInstance) {
        ArrayList<Instance> todo = new ArrayList<Instance>();
        todo.addAll(scopedInstance.getChildren());
        while (!todo.isEmpty()) {
            Instance current = (Instance)todo.remove(0);
            if (InstanceHelpers.isTarget(current)) {
                current.getParent().getChildren().remove(current);
                continue;
            }
            todo.addAll(current.getChildren());
        }
    }

    public static String findRootInstancePath(String scopedInstancePath) {
        String s;
        int index;
        String result = Utils.isEmptyOrWhitespaces(scopedInstancePath) ? "" : (scopedInstancePath.contains("/") ? ((index = (s = scopedInstancePath.replaceFirst("^/*", "")).indexOf(47)) > 0 ? s.substring(0, index) : s) : scopedInstancePath);
        return result;
    }

    public static void fixOverriddenExports(Instance instance) {
        if (!instance.overriddenExports.isEmpty()) {
            Map<String, String> componentExports = ComponentHelpers.findAllExportedVariables(instance.getComponent());
            Iterator<Map.Entry<String, String>> iter = instance.overriddenExports.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                String value = componentExports.get(entry.getKey());
                if (!Objects.equals(value, entry.getValue())) continue;
                iter.remove();
            }
        }
    }
}

