/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.runtime;

public class Preference {
    private final String name;
    private final String value;
    private final PreferenceKeyCategory category;

    public Preference(String name, String value, PreferenceKeyCategory category) {
        this.name = name;
        this.value = value;
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public PreferenceKeyCategory getCategory() {
        return this.category;
    }

    public String toString() {
        return this.name;
    }

    public static enum PreferenceKeyCategory {
        WEB("Web"),
        EMAIL("Email settings (when Roboconf has to send e-mails)"),
        AUTONOMIC("Autonomic"),
        MISCELLANEOUS("Miscellaneous properties");

        private String description;

        private PreferenceKeyCategory(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public static PreferenceKeyCategory which(String s) {
            PreferenceKeyCategory result = null;
            for (PreferenceKeyCategory cat : PreferenceKeyCategory.values()) {
                if (!cat.toString().equalsIgnoreCase(s)) continue;
                result = cat;
                break;
            }
            return result;
        }
    }
}

