/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.userdata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import net.roboconf.core.utils.Utils;

public final class UserDataHelpers {
    public static final String SCOPED_INSTANCE_PATH = "scoped.instance.path";
    public static final String APPLICATION_NAME = "application.name";
    public static final String DOMAIN = "domain";
    public static final String ENCODE_FILE_CONTENT_PREFIX = "@file@";

    private UserDataHelpers() {
    }

    public static String writeUserDataAsString(Map<String, String> messagingConfiguration, String domain, String applicationName, String scopedInstancePath) throws IOException {
        Properties props = UserDataHelpers.writeUserDataAsProperties(messagingConfiguration, domain, applicationName, scopedInstancePath);
        StringWriter writer = new StringWriter();
        props.store(writer, "");
        return writer.toString();
    }

    public static Properties writeUserDataAsProperties(Map<String, String> messagingConfiguration, String domain, String applicationName, String scopedInstancePath) throws IOException {
        Properties result = new Properties();
        if (applicationName != null) {
            result.setProperty(APPLICATION_NAME, applicationName);
        }
        if (scopedInstancePath != null) {
            result.setProperty(SCOPED_INSTANCE_PATH, scopedInstancePath);
        }
        if (domain != null) {
            result.setProperty(DOMAIN, domain);
        }
        if (messagingConfiguration != null) {
            for (Map.Entry<String, String> e : messagingConfiguration.entrySet()) {
                if (e.getValue() == null) continue;
                result.setProperty(e.getKey(), e.getValue());
            }
        }
        UserDataHelpers.interceptLoadingFiles(result);
        return result;
    }

    public static Properties readUserData(String rawProperties, File outputDirectory) throws IOException {
        Properties result = new Properties();
        StringReader reader = new StringReader(rawProperties);
        result.load(reader);
        return UserDataHelpers.processUserData(result, outputDirectory);
    }

    public static Properties processUserData(Properties properties, File outputDirectory) throws IOException {
        UserDataHelpers.interceptWritingFiles(properties, outputDirectory);
        return properties;
    }

    static void interceptLoadingFiles(Properties props) throws IOException {
        Logger logger = Logger.getLogger(UserDataHelpers.class.getName());
        Set<String> keys = props.stringPropertyNames();
        for (String key : keys) {
            if (!key.startsWith(ENCODE_FILE_CONTENT_PREFIX)) continue;
            String realKey = key.substring(ENCODE_FILE_CONTENT_PREFIX.length());
            String value = props.getProperty(realKey);
            if (value == null) {
                logger.fine("No file was specified for " + realKey + ". Skipping it...");
                continue;
            }
            File f = new File(value);
            if (!f.exists()) {
                throw new IOException("File " + f + " was not found.");
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Utils.copyStream(f, os);
            String encodedFileContent = UserDataHelpers.encodeToBase64(os.toByteArray());
            props.put(key, encodedFileContent);
        }
    }

    static void interceptWritingFiles(Properties props, File outputDirectory) throws IOException {
        if (outputDirectory == null) {
            return;
        }
        Logger logger = Logger.getLogger(UserDataHelpers.class.getName());
        Set<String> keys = props.stringPropertyNames();
        for (String key : keys) {
            if (!key.startsWith(ENCODE_FILE_CONTENT_PREFIX)) continue;
            String encodedFileContent = props.getProperty(key);
            String realKey = key.substring(ENCODE_FILE_CONTENT_PREFIX.length());
            if (encodedFileContent == null) {
                logger.fine("No file content was provided for " + realKey + ". Skipping it...");
                continue;
            }
            byte[] fileContent = UserDataHelpers.decodeFromBase64(encodedFileContent);
            String targetFile = props.getProperty(realKey);
            if (targetFile == null) {
                logger.fine("No property named " + realKey + " was found. Skipping it...");
                continue;
            }
            Utils.createDirectory(outputDirectory);
            File output = new File(outputDirectory, new File(targetFile).getName());
            Utils.copyStream(new ByteArrayInputStream(fileContent), output);
            logger.finer("Writing " + key + " from user data in " + output.getAbsolutePath());
            props.remove(key);
            props.setProperty(realKey, output.getAbsolutePath());
        }
    }

    static String encodeToBase64(byte[] bytes) {
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    static byte[] decodeFromBase64(String s) {
        return DatatypeConverter.parseBase64Binary((String)s);
    }
}

