/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.util.HashMap;
import java.util.Map;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;

public final class DockerAndScriptUtils {
    public static final String ROBOCONF_INSTANCE_NAME = "ROBOCONF_INSTANCE_NAME";
    public static final String ROBOCONF_INSTANCE_PATH = "ROBOCONF_INSTANCE_PATH";
    public static final String ROBOCONF_CLEAN_INSTANCE_PATH = "ROBOCONF_CLEAN_INSTANCE_PATH";
    public static final String ROBOCONF_CLEAN_REVERSED_INSTANCE_PATH = "ROBOCONF_CLEAN_REVERSED_INSTANCE_PATH";
    public static final String ROBOCONF_COMPONENT_NAME = "ROBOCONF_COMPONENT_NAME";

    private DockerAndScriptUtils() {
    }

    public static Map<String, String> buildReferenceMap(Instance instance) {
        HashMap<String, String> result = new HashMap<String, String>();
        String instancePath = InstanceHelpers.computeInstancePath(instance);
        result.put(ROBOCONF_INSTANCE_NAME, instance.getName());
        result.put(ROBOCONF_INSTANCE_PATH, instancePath);
        result.put(ROBOCONF_COMPONENT_NAME, instance.getComponent().getName());
        result.put(ROBOCONF_CLEAN_INSTANCE_PATH, DockerAndScriptUtils.cleanInstancePath(instancePath));
        result.put(ROBOCONF_CLEAN_REVERSED_INSTANCE_PATH, DockerAndScriptUtils.cleanReversedInstancePath(instancePath));
        return result;
    }

    public static String cleanInstancePath(String instancePath) {
        return instancePath.replaceFirst("^/", "").replaceAll("[\\W]", "_");
    }

    public static String cleanReversedInstancePath(String instancePath) {
        StringBuilder sb = new StringBuilder();
        for (String s : instancePath.split("/")) {
            if (Utils.isEmptyOrWhitespaces(s)) continue;
            sb.insert(0, s);
            sb.insert(0, "/");
        }
        return DockerAndScriptUtils.cleanInstancePath(sb.toString());
    }
}

