/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.utils.Utils;

public final class ManifestUtils {
    static final String BUNDLE_VERSION = "bundle-version";

    private ManifestUtils() {
    }

    public static String findMavenVersion(String bundleVersion) {
        String result = bundleVersion;
        if (bundleVersion != null) {
            result = bundleVersion.replaceAll("(?i:(\\.|-)SNAPSHOT$)", "-SNAPSHOT");
            Pattern pattern = Pattern.compile("(\\d+\\.\\d+)\\.0(-SNAPSHOT)?$");
            Matcher m = pattern.matcher(result);
            if (m.find()) {
                result = m.replaceFirst("$1$2");
            }
        }
        return result;
    }

    public static String findBundleVersion() {
        return ManifestUtils.findManifestProperty(BUNDLE_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findManifestProperty(String propertyName) {
        String result = null;
        InputStream is = null;
        try {
            is = ManifestUtils.class.getResourceAsStream("/META-INF/MANIFEST.MF");
            Properties props = new Properties();
            props.load(is);
            result = ManifestUtils.findManifestProperty(props, propertyName);
        }
        catch (IOException e) {
            Logger logger = Logger.getLogger(ManifestUtils.class.getName());
            logger.warning("Could not read the bundle manifest. " + e.getMessage());
        }
        finally {
            Utils.closeQuietly(is);
        }
        return result;
    }

    public static String findManifestProperty(Properties props, String propertyName) {
        String result = null;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (!propertyName.equalsIgnoreCase(String.valueOf(entry.getKey()))) continue;
            result = String.valueOf(entry.getValue());
            break;
        }
        return result;
    }
}

