/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.dsl.parsing.AbstractBlockHolder;
import net.roboconf.core.dsl.parsing.BlockProperty;
import net.roboconf.core.internal.dsl.parsing.ExportedVariablesParser;
import net.roboconf.core.model.beans.ExportedVariable;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.Utils;

public final class ModelUtils {
    private ModelUtils() {
    }

    public static String getPropertyValue(AbstractBlockHolder holder, String propertyName) {
        BlockProperty p = holder.findPropertyBlockByName(propertyName);
        return p == null ? null : p.getValue();
    }

    public static List<String> getPropertyValues(AbstractBlockHolder holder, String propertyName) {
        ArrayList<String> result = new ArrayList<String>();
        for (BlockProperty p : holder.findPropertiesBlockByName(propertyName)) {
            result.addAll(Utils.splitNicely(p.getValue(), ","));
        }
        return result;
    }

    public static Map<String, String> getData(AbstractBlockHolder holder) {
        BlockProperty p = holder.findPropertyBlockByName("instance-data");
        HashMap<String, String> result = new HashMap<String, String>();
        String propertyValue = p == null ? null : p.getValue();
        for (String s : Utils.splitNicely(propertyValue, ",")) {
            Map.Entry<String, String> entry = VariableHelpers.parseExportedVariable(s);
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map<String, ExportedVariable> getExportedVariables(AbstractBlockHolder holder) {
        HashMap<String, ExportedVariable> result = new HashMap<String, ExportedVariable>();
        for (BlockProperty p : holder.findPropertiesBlockByName("exports")) {
            result.putAll(ModelUtils.findExportedVariables(p.getValue(), p.getFile(), p.getLine()));
        }
        return result;
    }

    public static Map<String, ExportedVariable> findExportedVariables(String exportedVariablesDecl, File sourceFile, int lineNumber) {
        HashMap<String, ExportedVariable> result = new HashMap<String, ExportedVariable>();
        Pattern pattern = Pattern.compile("random\\[([^]]*)\\](.*)", 2);
        ExportedVariablesParser exportsParser = new ExportedVariablesParser();
        exportsParser.parse(exportedVariablesDecl, sourceFile, lineNumber);
        for (Map.Entry<String, String> entry : exportsParser.rawNameToVariables.entrySet()) {
            ExportedVariable var = new ExportedVariable();
            String variableName = entry.getKey();
            Matcher m = pattern.matcher(variableName);
            if (m.matches()) {
                var.setRandom(true);
                var.setRawKind(m.group(1));
                variableName = m.group(2).trim();
            }
            var.setName(variableName);
            var.setValue(entry.getValue());
            result.put(var.getName(), var);
        }
        return result;
    }
}

