/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.roboconf.core.utils.UriUtils;

public final class Utils {
    private Utils() {
    }

    public static boolean isEmptyOrWhitespaces(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String capitalize(String s) {
        String result = s;
        if (!Utils.isEmptyOrWhitespaces(s)) {
            result = Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase();
        }
        return result;
    }

    public static String removeFileExtension(String filename) {
        String result = filename;
        int index = filename.lastIndexOf(46);
        if (index != -1) {
            result = filename.substring(0, index);
        }
        return result;
    }

    public static List<String> splitNicely(String toSplit, String separator) {
        if (separator == null || separator.isEmpty()) {
            throw new IllegalArgumentException("The separator cannot be null or the empty string.");
        }
        return Utils.splitNicelyWithPattern(toSplit, Pattern.quote(separator));
    }

    public static List<String> splitNicelyWithPattern(String toSplit, String patternSeparator) {
        if (patternSeparator == null || patternSeparator.isEmpty()) {
            throw new IllegalArgumentException("The separator cannot be null or the empty string.");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!Utils.isEmptyOrWhitespaces(toSplit)) {
            for (String s : toSplit.split(patternSeparator)) {
                result.add(s.trim());
            }
        }
        return result;
    }

    public static List<String> filterEmptyValues(List<String> values) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : values) {
            if (Utils.isEmptyOrWhitespaces(s)) continue;
            result.add(s);
        }
        return result;
    }

    public static String format(Collection<String> items, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = items.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String expandTemplate(String s, Properties params) {
        String result;
        if (params == null || params.size() < 1) {
            result = s;
        } else {
            StringBuffer sb = new StringBuffer();
            Pattern pattern = Pattern.compile("\\{\\{\\s*\\S+\\s*\\}\\}");
            Matcher m = pattern.matcher(s);
            while (m.find()) {
                String raw = m.group();
                String varName = m.group().replace('{', ' ').replace('}', ' ').trim();
                String val = params.getProperty(varName);
                val = val == null ? raw : val.trim();
                m.appendReplacement(sb, val);
            }
            m.appendTail(sb);
            result = sb.toString();
        }
        return result;
    }

    public static void closeQuietly(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void copyStreamUnsafelyUseWithCaution(InputStream in, OutputStream os) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
    }

    public static void copyStreamSafely(InputStream in, ByteArrayOutputStream os) throws IOException {
        try {
            Utils.copyStreamUnsafelyUseWithCaution(in, os);
        }
        finally {
            in.close();
        }
    }

    public static void copyStream(InputStream in, File outputFile) throws IOException {
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            Utils.copyStreamUnsafelyUseWithCaution(in, os);
        }
    }

    public static void copyStream(File inputFile, File outputFile) throws IOException {
        try (FileInputStream is = new FileInputStream(inputFile);){
            Utils.copyStream(is, outputFile);
        }
    }

    public static void copyStream(File inputFile, OutputStream os) throws IOException {
        try (FileInputStream is = new FileInputStream(inputFile);){
            Utils.copyStreamUnsafelyUseWithCaution(is, os);
        }
    }

    public static void writeStringInto(String s, File outputFile) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
        Utils.copyStream(in, outputFile);
    }

    public static void appendStringInto(String s, File outputFile) throws IOException {
        OutputStreamWriter fw = null;
        try {
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile, true), StandardCharsets.UTF_8);
            fw.append(s);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(fw);
            throw throwable;
        }
        Utils.closeQuietly(fw);
    }

    public static String readFileContent(File file) throws IOException {
        String result = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Utils.copyStream(file, os);
        result = os.toString("UTF-8");
        return result;
    }

    public static String readFileContentQuietly(File file, Logger logger) {
        String result = "";
        try {
            if (file.exists()) {
                result = Utils.readFileContent(file);
            }
        }
        catch (Exception e) {
            logger.severe("File " + file + " could not be read.");
            Utils.logException(logger, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUrlContent(String url) throws IOException, URISyntaxException {
        String string;
        InputStream in = null;
        try {
            URI uri = UriUtils.urlToUri(url);
            in = uri.toURL().openStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Utils.copyStreamSafely(in, os);
            string = os.toString("UTF-8");
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(in);
            throw throwable;
        }
        Utils.closeQuietly(in);
        return string;
    }

    public static String readUrlContentQuietly(String url, Logger logger) {
        String result = "";
        try {
            result = Utils.readUrlContent(url);
        }
        catch (Exception e) {
            logger.severe("Content of URL " + url + " could not be read.");
            Utils.logException(logger, e);
        }
        return result;
    }

    public static Properties readPropertiesFile(File file) throws IOException {
        Properties result = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            result.load(in);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(in);
            throw throwable;
        }
        Utils.closeQuietly(in);
        return result;
    }

    public static Properties readPropertiesFileQuietly(File file, Logger logger) {
        Properties result = new Properties();
        try {
            if (file.exists()) {
                result = Utils.readPropertiesFile(file);
            }
        }
        catch (Exception e) {
            logger.severe("Properties file " + file + " could not be read.");
            Utils.logException(logger, e);
        }
        return result;
    }

    public static Properties readPropertiesQuietly(String fileContent, Logger logger) {
        Properties result = new Properties();
        try {
            if (fileContent != null) {
                ByteArrayInputStream in = new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8));
                result.load(in);
            }
        }
        catch (Exception e) {
            logger.severe("Properties could not be read from a string.");
            Utils.logException(logger, e);
        }
        return result;
    }

    public static void writePropertiesFile(Properties properties, File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            properties.store(out, "");
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(out);
            throw throwable;
        }
        Utils.closeQuietly(out);
    }

    public static String cleanNameWithAccents(String name) {
        String temp = Normalizer.normalize(name, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(temp).replaceAll("").trim();
    }

    public static void createDirectory(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("The directory " + directory + " could not be created.");
        }
    }

    public static List<File> listAllFiles(File directory) {
        return Utils.listAllFiles(directory, false);
    }

    public static String updateProperties(String propertiesContent, Map<String, String> keyToNewValue) {
        for (Map.Entry<String, String> entry : keyToNewValue.entrySet()) {
            propertiesContent = propertiesContent.replaceFirst("(?mi)^\\s*" + entry.getKey() + "\\s*[:=][^\n]*$", entry.getKey() + " = " + entry.getValue());
        }
        return propertiesContent;
    }

    public static List<File> listAllFiles(File directory, String fileExtension) {
        String ext = fileExtension;
        if (ext != null && !(ext = ext.toLowerCase()).startsWith(".")) {
            ext = "." + ext;
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File f : Utils.listAllFiles(directory)) {
            if (ext != null && !f.getName().toLowerCase().endsWith(ext)) continue;
            result.add(f);
        }
        return result;
    }

    public static List<File> listAllFiles(File directory, boolean includeDirectories) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory.getAbsolutePath() + " does not exist or is not a directory.");
        }
        ArrayList<File> result = new ArrayList<File>();
        ArrayList<File> directoriesToInspect = new ArrayList<File>();
        directoriesToInspect.add(directory);
        while (!directoriesToInspect.isEmpty()) {
            File[] subFiles;
            File currentDirectory = (File)directoriesToInspect.remove(0);
            if (includeDirectories) {
                result.add(currentDirectory);
            }
            if ((subFiles = currentDirectory.listFiles()) == null) continue;
            for (File subFile : subFiles) {
                if (subFile.isHidden() || subFile.getName().startsWith(".")) continue;
                if (subFile.isFile()) {
                    result.add(subFile);
                    continue;
                }
                directoriesToInspect.add(subFile);
            }
        }
        Collections.sort(result, new FileNameComparator());
        return result;
    }

    public static List<File> listDirectFiles(File directory, String fileExtension) {
        String ext = fileExtension;
        if (ext != null && !(ext = ext.toLowerCase()).startsWith(".")) {
            ext = "." + ext;
        }
        ArrayList<File> result = new ArrayList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.isFile() || ext != null && !f.getName().toLowerCase().endsWith(ext)) continue;
                result.add(f);
            }
        }
        return result;
    }

    public static List<File> listDirectories(File root) {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = root.listFiles(new DirectoryFileFilter());
        if (files != null) {
            result.addAll(Arrays.asList(files));
        }
        Collections.sort(result, new FileNameComparator());
        return result;
    }

    public static Map<String, byte[]> storeDirectoryResourcesAsBytes(File directory) throws IOException {
        return Utils.storeDirectoryResourcesAsBytes(directory, new ArrayList<String>(0));
    }

    public static Map<String, byte[]> storeDirectoryResourcesAsBytes(File directory, List<String> exclusionPatteners) throws IOException {
        if (!directory.exists()) {
            throw new IllegalArgumentException("The resource directory was not found. " + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("The resource directory is not a valid directory. " + directory.getAbsolutePath());
        }
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        List<File> resourceFiles = Utils.listAllFiles(directory, false);
        block0: for (File file : resourceFiles) {
            for (String exclusionPattern : exclusionPatteners) {
                if (!file.getName().matches(exclusionPattern)) continue;
                continue block0;
            }
            String key = Utils.computeFileRelativeLocation(directory, file);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Utils.copyStream(file, os);
            result.put(key, os.toByteArray());
        }
        return result;
    }

    public static Map<String, String> storeDirectoryResourcesAsString(File directory) throws IOException {
        Map<String, byte[]> map = Utils.storeDirectoryResourcesAsBytes(directory);
        HashMap<String, String> result = new HashMap<String, String>(map.size());
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            result.put(entry.getKey(), new String(entry.getValue(), StandardCharsets.UTF_8));
        }
        return result;
    }

    public static String computeFileRelativeLocation(File rootDirectory, File subFile) {
        String rootPath = rootDirectory.getAbsolutePath();
        String subPath = subFile.getAbsolutePath();
        if (!subPath.startsWith(rootPath)) {
            throw new IllegalArgumentException("The sub-file must be contained in the directory.");
        }
        if (rootDirectory.equals(subFile)) {
            throw new IllegalArgumentException("The sub-file must be different than the directory.");
        }
        return subPath.substring(rootPath.length() + 1).replace('\\', '/');
    }

    public static void extractZipArchive(File zipFile, File targetDirectory) throws IOException {
        Utils.extractZipArchive(zipFile, targetDirectory, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZipArchive(File zipFile, File targetDirectory, String entryPattern, String removedEntryPrefix) throws IOException {
        if (zipFile == null || targetDirectory == null) {
            throw new IllegalArgumentException("The ZIP file and the target directory cannot be null.");
        }
        if (!zipFile.isFile()) {
            throw new IllegalArgumentException("ZIP file " + targetDirectory.getName() + " does not exist.");
        }
        if (targetDirectory.exists() && !targetDirectory.isDirectory()) {
            throw new IllegalArgumentException("Target directory " + targetDirectory.getName() + " is not a directory.");
        }
        Utils.createDirectory(targetDirectory);
        ZipFile theZipFile = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = theZipFile.entries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String suffix = entry.getName();
                if (entryPattern != null && !suffix.matches(entryPattern)) continue;
                if (removedEntryPrefix != null && suffix.startsWith(removedEntryPrefix)) {
                    suffix = suffix.substring(removedEntryPrefix.length());
                }
                if (Utils.isEmptyOrWhitespaces(suffix)) continue;
                File f = new File(targetDirectory, suffix);
                if (entry.isDirectory()) {
                    Utils.createDirectory(f);
                    continue;
                }
                Utils.createDirectory(f.getParentFile());
                Utils.copyStream(theZipFile.getInputStream(entry), f);
            }
        }
        finally {
            theZipFile.close();
        }
    }

    public static boolean isAncestor(File ancestorCandidate, File file) {
        String path = ancestorCandidate.getAbsolutePath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return file.getAbsolutePath().startsWith(path);
    }

    public static void deleteFilesRecursively(File ... files) throws IOException {
        if (files == null) {
            return;
        }
        ArrayList<File> filesToDelete = new ArrayList<File>();
        filesToDelete.addAll(Arrays.asList(files));
        while (!filesToDelete.isEmpty()) {
            File currentFile = (File)filesToDelete.remove(0);
            if (currentFile == null || !currentFile.exists()) continue;
            File[] subFiles = currentFile.listFiles();
            if (subFiles != null && subFiles.length > 0) {
                filesToDelete.add(0, currentFile);
                filesToDelete.addAll(0, Arrays.asList(subFiles));
                continue;
            }
            if (currentFile.delete()) continue;
            throw new IOException(currentFile.getAbsolutePath() + " could not be deleted.");
        }
    }

    public static void deleteFilesRecursivelyAndQuietly(File ... files) {
        try {
            Utils.deleteFilesRecursively(files);
        }
        catch (IOException e) {
            Logger logger = Logger.getLogger(Utils.class.getName());
            Utils.logException(logger, e);
        }
    }

    public static String writeExceptionButDoNotUseItForLogging(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static void logException(Logger logger, Level logLevel, Throwable t, String message) {
        if (logger.isLoggable(logLevel)) {
            StringBuilder sb = new StringBuilder();
            if (message != null) {
                sb.append(message);
                sb.append("\n");
            }
            sb.append(Utils.writeExceptionButDoNotUseItForLogging(t));
            logger.log(logLevel, sb.toString());
        }
    }

    public static void logException(Logger logger, Level logLevel, Throwable t) {
        Utils.logException(logger, logLevel, t, null);
    }

    public static void logException(Logger logger, Throwable t) {
        Utils.logException(logger, Level.FINEST, t);
    }

    public static boolean isAncestorFile(File potentialAncestor, File file) throws IOException {
        String ancestorPath = potentialAncestor.getCanonicalPath();
        String path = file.getCanonicalPath();
        boolean result = false;
        if (path.startsWith(ancestorPath)) {
            String s = path.substring(ancestorPath.length());
            result = s.isEmpty() || s.startsWith(System.getProperty("file.separator"));
        }
        return result;
    }

    public static void copyDirectory(File source, File target) throws IOException {
        Utils.createDirectory(target);
        for (File sourceFile : Utils.listAllFiles(source, false)) {
            String path = Utils.computeFileRelativeLocation(source, sourceFile);
            File targetFile = new File(target, path);
            Utils.createDirectory(targetFile.getParentFile());
            Utils.copyStream(sourceFile, targetFile);
        }
    }

    public static Map.Entry<String, Integer> findUrlAndPort(String url) {
        Matcher m = Pattern.compile(".*(:\\d+).*").matcher(url);
        String portAsString = m.find() ? m.group(1).substring(1) : null;
        Integer port = portAsString == null ? -1 : Integer.parseInt(portAsString);
        String address = portAsString == null ? url : url.replace(m.group(1), "");
        return new AbstractMap.SimpleEntry<String, Integer>(address, port);
    }

    public static String getValue(Map<String, String> map, String key, String defaultValue) {
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    static class DirectoryFileFilter
    implements FileFilter {
        DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }
    }

    static final class FileNameComparator
    implements Serializable,
    Comparator<File> {
        private static final long serialVersionUID = -4671366958457961589L;

        FileNameComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

