/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.io.Closeable;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.jasypt.encryption.StringEncryptor;
import org.ops4j.pax.jdbc.config.impl.DataSourceRegistration;
import org.ops4j.pax.jdbc.config.impl.Decryptor;
import org.ops4j.pax.jdbc.config.impl.ExternalConfigLoader;
import org.ops4j.pax.jdbc.config.impl.PoolingWrapper;
import org.ops4j.pax.jdbc.config.impl.tracker.MultiServiceTracker;
import org.ops4j.pax.jdbc.config.impl.tracker.TrackerCallback;
import org.ops4j.pax.jdbc.hook.PreHook;
import org.ops4j.pax.jdbc.pool.common.PooledDataSourceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceConfigManager
implements ManagedServiceFactory {
    private Logger LOG = LoggerFactory.getLogger(DataSourceConfigManager.class);
    BundleContext context;
    private Map<String, MultiServiceTracker> trackers;

    public DataSourceConfigManager(BundleContext context) {
        this.context = context;
        this.trackers = new HashMap<String, MultiServiceTracker>();
    }

    public String getName() {
        return "datasource";
    }

    public void updated(String pid, Dictionary config) throws ConfigurationException {
        this.deleted(pid);
        if (config == null) {
            return;
        }
        try {
            Dictionary<String, Object> loadedConfig = new ExternalConfigLoader().resolve(config);
            MultiServiceTracker tracker = this.createTracker(new TrackerCallbackImpl(loadedConfig));
            Filter dsfFilter = this.getDSFFilter(loadedConfig);
            Filter pdsfFilter = this.getPooledDSFFilter(loadedConfig);
            if (Decryptor.isEncrypted(loadedConfig)) {
                tracker.track(StringEncryptor.class, this.getAliasFilter(loadedConfig));
            }
            if (pdsfFilter != null) {
                tracker.track(PooledDataSourceFactory.class, pdsfFilter);
            }
            tracker.track(DataSourceFactory.class, dsfFilter);
            String preHookName = (String)loadedConfig.get("ops4j.preHook");
            if (preHookName != null) {
                tracker.track(PreHook.class, FrameworkUtil.createFilter((String)this.eqFilter("name", preHookName)));
            }
            tracker.open();
            this.trackers.put(pid, tracker);
        }
        catch (InvalidSyntaxException e) {
            this.LOG.warn("Invalid filter for DataSource config from pid " + pid, (Throwable)e);
        }
    }

    private Filter getAliasFilter(Dictionary<String, Object> loadedConfig) throws InvalidSyntaxException {
        String alias = Decryptor.getAlias(loadedConfig);
        return this.andFilter(this.eqFilter("objectClassName", StringEncryptor.class.getName()), this.eqFilter("alias", alias));
    }

    MultiServiceTracker createTracker(TrackerCallback callback) {
        return new MultiServiceTracker(this.context, callback);
    }

    private Filter getPooledDSFFilter(Dictionary config) throws ConfigurationException, InvalidSyntaxException {
        String pool = (String)config.remove("pool");
        boolean isXa = this.isXa(config);
        if (pool == null) {
            if (isXa) {
                throw new ConfigurationException(null, "Can not create XA DataSource without pooling.");
            }
            return null;
        }
        return this.andFilter(this.eqFilter("objectClass", PooledDataSourceFactory.class.getName()), this.eqFilter("pool", pool), this.eqFilter("xa", Boolean.toString(isXa)));
    }

    private boolean isXa(Dictionary config) throws ConfigurationException {
        String xa = (String)config.remove("xa");
        if (xa == null) {
            return false;
        }
        if (!"true".equals(xa)) {
            throw new ConfigurationException(null, "XA can only be set to true");
        }
        return true;
    }

    private Filter getDSFFilter(Dictionary config) throws ConfigurationException, InvalidSyntaxException {
        String driverClass = (String)config.get("osgi.jdbc.driver.class");
        String driverName = (String)config.get("osgi.jdbc.driver.name");
        if (driverClass == null && driverName == null) {
            throw new ConfigurationException(null, "Could not determine driver to use. Specify either osgi.jdbc.driver.class or osgi.jdbc.driver.name");
        }
        return this.andFilter(this.eqFilter("objectClass", DataSourceFactory.class.getName()), this.eqFilter("osgi.jdbc.driver.class", driverClass), this.eqFilter("osgi.jdbc.driver.name", driverName));
    }

    private String eqFilter(String key, String value) {
        return value != null ? "(" + key + "=" + value + ")" : null;
    }

    private Filter andFilter(String ... filterList) throws InvalidSyntaxException {
        StringBuilder filter = new StringBuilder();
        int count = 0;
        for (String filterPart : filterList) {
            if (filterPart == null) continue;
            filter.append(filterPart);
            ++count;
        }
        if (count > 1) {
            filter.append(")");
        }
        return FrameworkUtil.createFilter((String)((count > 1 ? "(&" : "") + filter.toString()));
    }

    public void deleted(String pid) {
        MultiServiceTracker tracker = this.trackers.get(pid);
        if (tracker != null) {
            tracker.close();
            this.trackers.remove(pid);
        }
    }

    private final class TrackerCallbackImpl
    implements TrackerCallback {
        private final Dictionary<String, Object> config;

        private TrackerCallbackImpl(Dictionary<String, Object> config) {
            this.config = config;
        }

        @Override
        public Closeable activate(MultiServiceTracker tracker) {
            StringEncryptor decryptor = tracker.getService(StringEncryptor.class);
            Dictionary<String, Object> decryptedConfig = new Decryptor(decryptor).decrypt(this.config);
            PooledDataSourceFactory pdsf = tracker.getService(PooledDataSourceFactory.class);
            DataSourceFactory dsf = tracker.getService(DataSourceFactory.class);
            DataSourceFactory actualDsf = pdsf != null ? new PoolingWrapper(pdsf, dsf) : dsf;
            PreHook preHook = tracker.getService(PreHook.class);
            return new DataSourceRegistration(DataSourceConfigManager.this.context, actualDsf, this.config, decryptedConfig, preHook);
        }
    }
}

