/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.http.internal;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.utils.SerializationUtils;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;

public final class HttpUtils {
    private HttpUtils() {
    }

    public static Map<String, String> httpMessagingConfiguration(String ip, int port) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("net.roboconf.messaging.type", "http");
        result.put("net.roboconf.messaging.http.server.ip", ip == null ? "127.0.0.1" : ip);
        result.put("net.roboconf.messaging.http.server.port", "" + (port <= 0 ? 8181 : port));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendAsynchronously(Message message, RemoteEndpoint remoteEndpoint) throws IOException {
        block8: {
            Future fut = null;
            Exception exception = null;
            try {
                byte[] rawData = SerializationUtils.serializeObject((Serializable)message);
                ByteBuffer data = ByteBuffer.wrap(rawData);
                fut = remoteEndpoint.sendBytesByFuture(data);
                fut.get(8L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                exception = e;
            }
            catch (TimeoutException e) {
                exception = e;
                Logger logger = Logger.getLogger(HttpUtils.class.getName());
                logger.warning("A message could not be sent to a remote end-point (HTTP messaging). Sending timed out.");
                if (fut != null) {
                    fut.cancel(true);
                }
            }
            finally {
                if (exception == null) break block8;
                throw new IOException(exception);
            }
        }
    }
}

