/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.http.internal.clients;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.messaging.api.extensions.AbstractRoutingClient;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.jmx.RoboconfMessageQueue;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.reconfigurables.ReconfigurableClient;
import net.roboconf.messaging.http.internal.HttpUtils;
import net.roboconf.messaging.http.internal.messages.HttpMessage;
import net.roboconf.messaging.http.internal.messages.SubscriptionMessage;
import net.roboconf.messaging.http.internal.sockets.AgentWebSocket;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class HttpAgentClient
implements IMessagingClient {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final WeakReference<ReconfigurableClient<?>> reconfigurable;
    private final String dmIp;
    private final int dmPort;
    private RoboconfMessageQueue messageQueue;
    private String applicationName;
    private String scopedInstancePath;
    private AgentWebSocket socket;
    private Session clientSession;
    private WebSocketClient client;

    public HttpAgentClient(ReconfigurableClient<?> reconfigurable, String dmIp, int dmPort) {
        this.reconfigurable = new WeakReference(reconfigurable);
        this.dmIp = dmIp;
        this.dmPort = dmPort;
    }

    public final ReconfigurableClient<?> getReconfigurableClient() {
        return (ReconfigurableClient)this.reconfigurable.get();
    }

    public void setMessageQueue(RoboconfMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    public boolean isConnected() {
        return this.client != null && this.clientSession != null;
    }

    public void setOwnerProperties(MessagingContext.RecipientKind ownerKind, String domain, String applicationName, String scopedInstancePath) {
        this.applicationName = applicationName;
        this.scopedInstancePath = scopedInstancePath;
        this.logger.fine("Owner properties changed to " + this.getId());
    }

    public void openConnection() throws IOException {
        this.logger.info(this.getId() + " is opening a connection to the DM.");
        try {
            this.client = new WebSocketClient();
            this.socket = new AgentWebSocket(this.messageQueue);
            this.client.start();
            URI dmUri = new URI("ws://" + this.dmIp + ":" + this.dmPort + "/roboconf-messaging-http");
            this.logger.fine("Connecting to " + dmUri);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            Future fut = this.client.connect((Object)this.socket, dmUri, request);
            this.clientSession = (Session)fut.get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void closeConnection() throws IOException {
        this.logger.info(this.getId() + " is closing its connection to the DM.");
        try {
            if (this.client != null) {
                this.client.stop();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getMessagingType() {
        return "http";
    }

    public Map<String, String> getConfiguration() {
        return HttpUtils.httpMessagingConfiguration(this.dmIp, this.dmPort);
    }

    public void subscribe(MessagingContext ctx) throws IOException {
        String ownerId = AbstractRoutingClient.buildOwnerId((MessagingContext.RecipientKind)MessagingContext.RecipientKind.AGENTS, (String)this.applicationName, (String)this.scopedInstancePath);
        this.logger.fine(this.getId() + " is about to subscribe to " + ownerId);
        HttpUtils.sendAsynchronously(new SubscriptionMessage(ownerId, ctx, true), this.clientSession.getRemote());
    }

    public void unsubscribe(MessagingContext ctx) throws IOException {
        String ownerId = AbstractRoutingClient.buildOwnerId((MessagingContext.RecipientKind)MessagingContext.RecipientKind.AGENTS, (String)this.applicationName, (String)this.scopedInstancePath);
        this.logger.fine(this.getId() + " is about to unsubscribe to " + ownerId);
        HttpUtils.sendAsynchronously(new SubscriptionMessage(ownerId, ctx, false), this.clientSession.getRemote());
    }

    public void publish(MessagingContext ctx, Message msg) throws IOException {
        String ownerId = AbstractRoutingClient.buildOwnerId((MessagingContext.RecipientKind)MessagingContext.RecipientKind.AGENTS, (String)this.applicationName, (String)this.scopedInstancePath);
        this.logger.fine(this.getId() + " is about to publish a message (" + msg + ") to " + ownerId);
        HttpUtils.sendAsynchronously(new HttpMessage(ownerId, msg, ctx), this.clientSession.getRemote());
    }

    public void deleteMessagingServerArtifacts(Application application) throws IOException {
    }

    String getId() {
        return this.scopedInstancePath + " @ " + this.applicationName;
    }
}

