/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.http.internal.sockets;

import java.io.IOException;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.http.internal.HttpClientFactory;
import net.roboconf.messaging.http.internal.messages.HttpSerializationUtils;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;

public class DmWebSocket
implements WebSocketListener {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Session session;
    private final HttpClientFactory httpClientFactory;

    public DmWebSocket(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        this.logger.finest("A binary message was received.");
        try {
            Message msg = HttpSerializationUtils.deserializeObject(payload);
            this.logger.finest("The received message was deserialized as an instance of " + msg.getClass().getSimpleName());
            this.httpClientFactory.getDmClient().processReceivedMessage(msg, this.session);
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.severe("A message could not be deserialized. => " + e.getClass().getSimpleName());
            Utils.logException((Logger)this.logger, (Throwable)e);
            this.httpClientFactory.getDmClient().errorWhileReceivingMessage();
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.logger.finest("Websocket closed: " + reason);
        this.session = null;
    }

    public void onWebSocketConnect(Session session) {
        this.logger.finest("Socket Connected: " + session);
        this.session = session;
    }

    public void onWebSocketError(Throwable cause) {
        this.logger.finest("Websocket error: " + cause);
        this.session = null;
    }

    public void onWebSocketText(String message) {
        this.logger.finest("A text message was received but will be ignored: " + message);
    }
}

