/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.internal.client.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.ReturnListener;
import java.io.IOException;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.internal.utils.SerializationUtils;
import net.roboconf.messaging.messages.Message;

public class DmReturnListener
implements ReturnListener {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public void handleReturn(int replyCode, String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) throws IOException {
        String messageType = "undetermined";
        try {
            Message msg = SerializationUtils.deserializeObject(body);
            messageType = msg.getClass().getName();
        }
        catch (Exception e) {
            this.logger.severe("Failed to deserialize a message object.");
            Utils.logException((Logger)this.logger, (Exception)e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("A message sent by the DM was not received by any agent queue.");
        sb.append("\nMessage type: " + messageType);
        sb.append("\nRouting key: " + routingKey);
        sb.append("\nReason: " + replyText);
        this.logger.warning(sb.toString());
    }
}

