/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.internal.client.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.client.IAgentClient;
import net.roboconf.messaging.client.IClient;
import net.roboconf.messaging.internal.client.rabbitmq.ListeningThread;
import net.roboconf.messaging.internal.utils.RabbitMqUtils;
import net.roboconf.messaging.internal.utils.SerializationUtils;
import net.roboconf.messaging.messages.Message;
import net.roboconf.messaging.messages.from_agent_to_agent.MsgCmdAddImport;
import net.roboconf.messaging.messages.from_agent_to_agent.MsgCmdRemoveImport;
import net.roboconf.messaging.messages.from_agent_to_agent.MsgCmdRequestImport;

public class RabbitMqClientAgent
implements IAgentClient {
    private static final String THOSE_THAT_EXPORT = "those.that.export.";
    public static final String THOSE_THAT_IMPORT = "those.that.import.";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private String applicationName;
    private String rootInstanceName;
    private String messageServerIp;
    private String messageServerUsername;
    private String messageServerPassword;
    private LinkedBlockingQueue<Message> messageQueue;
    String consumerTag;
    Channel channel;

    @Override
    public void setParameters(String messageServerIp, String messageServerUsername, String messageServerPassword) {
        this.messageServerIp = messageServerIp;
        this.messageServerUsername = messageServerUsername;
        this.messageServerPassword = messageServerPassword;
    }

    @Override
    public void setMessageQueue(LinkedBlockingQueue<Message> messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Override
    public boolean isConnected() {
        return this.channel != null;
    }

    @Override
    public void setRootInstanceName(String rootInstanceName) {
        this.rootInstanceName = rootInstanceName;
    }

    @Override
    public void openConnection() throws IOException {
        this.logger.info("Agent '" + this.getAgentId() + "' is opening a connection to RabbitMQ.");
        if (this.channel != null) {
            this.logger.info("Agent '" + this.getAgentId() + "' has already a connection to RabbitMQ.");
            return;
        }
        ConnectionFactory factory = new ConnectionFactory();
        RabbitMqUtils.configureFactory(factory, this.messageServerIp, this.messageServerUsername, this.messageServerPassword);
        this.channel = factory.newConnection().createChannel();
        this.logger.info("Agent '" + this.getAgentId() + "' established a new connection with RabbitMQ. Channel # " + this.channel.getChannelNumber());
        RabbitMqUtils.declareApplicationExchanges(this.applicationName, this.channel);
        String queueName = this.getQueueName();
        this.channel.queueDeclare(queueName, true, false, true, null);
        QueueingConsumer consumer = new QueueingConsumer(this.channel);
        this.consumerTag = this.channel.basicConsume(queueName, true, consumer);
        String threadName = "Roboconf - Queue listener for Agent " + this.rootInstanceName;
        String id = "Agent '" + this.getAgentId() + "'";
        new ListeningThread(threadName, this.logger, consumer, this.messageQueue, id).start();
    }

    @Override
    public void closeConnection() throws IOException {
        StringBuilder sb = new StringBuilder("Agent '" + this.getAgentId());
        sb.append("' is closing its connection to RabbitMQ.");
        if (this.channel != null) {
            sb.append(" Channel # " + this.channel.getChannelNumber());
        }
        this.logger.info(sb.toString());
        if (this.channel != null && this.channel.isOpen() && this.consumerTag != null) {
            this.channel.basicCancel(this.consumerTag);
        }
        this.consumerTag = null;
        if (this.isConnected()) {
            RabbitMqUtils.closeConnection(this.channel);
        }
        this.channel = null;
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public void publishExports(Instance instance) throws IOException {
        this.logger.fine("Agent '" + this.getAgentId() + "' is publishing its exports.");
        for (String facetOrComponentName : VariableHelpers.findPrefixesForExportedVariables((Instance)instance)) {
            this.publishExports(instance, facetOrComponentName);
        }
    }

    @Override
    public void publishExports(Instance instance, String facetOrComponentName) throws IOException {
        this.logger.fine("Agent '" + this.getAgentId() + "' is publishing its exports prefixed by " + facetOrComponentName + ".");
        HashMap<String, String> toPublish = new HashMap<String, String>();
        Map exports = InstanceHelpers.findAllExportedVariables((Instance)instance);
        for (Map.Entry entry : exports.entrySet()) {
            if (!((String)entry.getKey()).startsWith(facetOrComponentName + ".")) continue;
            toPublish.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (!toPublish.isEmpty()) {
            MsgCmdAddImport message = new MsgCmdAddImport(facetOrComponentName, InstanceHelpers.computeInstancePath((Instance)instance), toPublish);
            this.channel.basicPublish(RabbitMqUtils.buildExchangeName(this.applicationName, false), THOSE_THAT_IMPORT + facetOrComponentName, null, SerializationUtils.serializeObject(message));
        }
    }

    @Override
    public void unpublishExports(Instance instance) throws IOException {
        this.logger.fine("Agent '" + this.getAgentId() + "' is un-publishing its exports.");
        for (String facetOrComponentName : VariableHelpers.findPrefixesForExportedVariables((Instance)instance)) {
            MsgCmdRemoveImport message = new MsgCmdRemoveImport(facetOrComponentName, InstanceHelpers.computeInstancePath((Instance)instance));
            this.channel.basicPublish(RabbitMqUtils.buildExchangeName(this.applicationName, false), THOSE_THAT_IMPORT + facetOrComponentName, null, SerializationUtils.serializeObject(message));
        }
    }

    @Override
    public void listenToRequestsFromOtherAgents(IClient.ListenerCommand command, Instance instance) throws IOException {
        for (String facetOrComponentName : VariableHelpers.findPrefixesForExportedVariables((Instance)instance)) {
            String routingKey = THOSE_THAT_EXPORT + facetOrComponentName;
            String queueName = this.getQueueName();
            String exchangeName = RabbitMqUtils.buildExchangeName(this.applicationName, false);
            if (command == IClient.ListenerCommand.START) {
                this.logger.fine("Agent '" + this.getAgentId() + "' starts listening requests from other agents.");
                this.channel.queueBind(queueName, exchangeName, routingKey);
                continue;
            }
            this.logger.fine("Agent '" + this.getAgentId() + "' stops listening requests from other agents.");
            this.channel.queueUnbind(queueName, exchangeName, routingKey);
        }
    }

    @Override
    public void requestExportsFromOtherAgents(Instance instance) throws IOException {
        this.logger.fine("Agent '" + this.getAgentId() + "' is requesting exports from other agents.");
        for (String facetOrComponentName : VariableHelpers.findPrefixesForImportedVariables((Instance)instance)) {
            MsgCmdRequestImport message = new MsgCmdRequestImport(facetOrComponentName);
            this.channel.basicPublish(RabbitMqUtils.buildExchangeName(this.applicationName, false), THOSE_THAT_EXPORT + facetOrComponentName, null, SerializationUtils.serializeObject(message));
        }
    }

    @Override
    public void listenToExportsFromOtherAgents(IClient.ListenerCommand command, Instance instance) throws IOException {
        for (String facetOrComponentName : VariableHelpers.findPrefixesForImportedVariables((Instance)instance)) {
            String routingKey = THOSE_THAT_IMPORT + facetOrComponentName;
            String queueName = this.getQueueName();
            String exchangeName = RabbitMqUtils.buildExchangeName(this.applicationName, false);
            if (command == IClient.ListenerCommand.START) {
                this.logger.fine("Agent '" + this.getAgentId() + "' starts listening exports from other agents.");
                this.channel.queueBind(queueName, exchangeName, routingKey);
                continue;
            }
            this.logger.fine("Agent '" + this.getAgentId() + "' stops listening exports from other agents.");
            this.channel.queueUnbind(queueName, exchangeName, routingKey);
        }
    }

    @Override
    public void sendMessageToTheDm(Message message) throws IOException {
        this.logger.fine("Agent '" + this.getAgentId() + "' is sending a " + message.getClass().getSimpleName() + " message to the DM.");
        this.channel.basicPublish(RabbitMqUtils.buildExchangeName(this.applicationName, true), "", null, SerializationUtils.serializeObject(message));
    }

    @Override
    public void listenToTheDm(IClient.ListenerCommand command) throws IOException {
        String queueName = this.getQueueName();
        String exchangeName = RabbitMqUtils.buildExchangeName(this.applicationName, false);
        String routingKey = RabbitMqUtils.buildRoutingKeyForAgent(this.rootInstanceName);
        if (command == IClient.ListenerCommand.START) {
            this.logger.fine("Agent '" + this.getAgentId() + "' starts listening to the DM.");
            this.channel.queueBind(queueName, exchangeName, routingKey);
        } else {
            this.logger.fine("Agent '" + this.getAgentId() + "' stops listening to the DM.");
            this.channel.queueUnbind(queueName, exchangeName, routingKey);
        }
    }

    private String getQueueName() {
        return this.applicationName + "." + this.rootInstanceName;
    }

    private String getAgentId() {
        return Utils.isEmptyOrWhitespaces((String)this.rootInstanceName) ? "?" : this.rootInstanceName;
    }
}

