/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.internal.client.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.messaging.client.IClient;
import net.roboconf.messaging.client.IDmClient;
import net.roboconf.messaging.internal.client.rabbitmq.DmReturnListener;
import net.roboconf.messaging.internal.client.rabbitmq.ListeningThread;
import net.roboconf.messaging.internal.utils.RabbitMqUtils;
import net.roboconf.messaging.internal.utils.SerializationUtils;
import net.roboconf.messaging.messages.Message;
import net.roboconf.messaging.messages.from_agent_to_agent.MsgCmdRemoveImport;

public class RabbitMqClientDm
implements IDmClient {
    private static final String DM_NEUTRAL_QUEUE_NAME = "roboconf.dm.neutral";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private String messageServerIp;
    private String messageServerUsername;
    private String messageServerPassword;
    private LinkedBlockingQueue<Message> messageQueue;
    String neutralConsumerTag;
    final Map<String, String> applicationNameToConsumerTag = new HashMap<String, String>();
    Channel channel;
    QueueingConsumer consumer;

    @Override
    public void setParameters(String messageServerIp, String messageServerUsername, String messageServerPassword) {
        this.messageServerIp = messageServerIp;
        this.messageServerUsername = messageServerUsername;
        this.messageServerPassword = messageServerPassword;
    }

    @Override
    public void setMessageQueue(LinkedBlockingQueue<Message> messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Override
    public boolean isConnected() {
        return this.channel != null;
    }

    @Override
    public void openConnection() throws IOException {
        this.logger.info("The DM is opening a connection to RabbitMQ.");
        if (this.isConnected()) {
            this.logger.info("The DM has already a connection to RabbitMQ.");
            return;
        }
        ConnectionFactory factory = new ConnectionFactory();
        RabbitMqUtils.configureFactory(factory, this.messageServerIp, this.messageServerUsername, this.messageServerPassword);
        this.channel = factory.newConnection().createChannel();
        this.logger.info("The DM established a new connection with RabbitMQ. Channel # " + this.channel.getChannelNumber());
        this.channel.addReturnListener(new DmReturnListener());
        this.channel.queueDeclare(DM_NEUTRAL_QUEUE_NAME, true, false, true, null);
        this.consumer = new QueueingConsumer(this.channel);
        String threadName = "Roboconf - Queue listener for the DM";
        String id = "The DM";
        new ListeningThread(threadName, this.logger, this.consumer, this.messageQueue, id).start();
    }

    @Override
    public void closeConnection() throws IOException {
        StringBuilder sb = new StringBuilder("The DM is closing its connection to RabbitMQ.");
        if (this.channel != null) {
            sb.append(" Channel # " + this.channel.getChannelNumber());
        }
        this.logger.info(sb.toString());
        if (this.isConnected()) {
            RabbitMqUtils.closeConnection(this.channel);
        }
        this.channel = null;
    }

    @Override
    public void sendMessageToAgent(Application application, Instance instance, Message message) throws IOException {
        String exchangeName = RabbitMqUtils.buildExchangeName(application, false);
        String routingKey = RabbitMqUtils.buildRoutingKeyForAgent(instance);
        this.logger.fine("The DM sends a message to " + routingKey + ". Message type: " + message.getClass().getSimpleName());
        this.channel.basicPublish(exchangeName, routingKey, true, false, null, SerializationUtils.serializeObject(message));
        this.logger.fine("The DM sent a message to " + routingKey + ". Message type: " + message.getClass().getSimpleName());
    }

    @Override
    public void listenToAgentMessages(Application application, IClient.ListenerCommand command) throws IOException {
        if (command == IClient.ListenerCommand.STOP) {
            this.logger.fine("The DM stops listening agents messages for the '" + application.getName() + "' application.");
            String consumerTag = this.applicationNameToConsumerTag.remove(application.getName());
            if (consumerTag != null && this.channel != null && this.channel.isOpen()) {
                this.channel.basicCancel(consumerTag);
            }
        } else {
            if (this.applicationNameToConsumerTag.containsKey(application.getName())) {
                this.logger.finer("Application " + application + " is already listened to by a messaging client.");
                return;
            }
            this.logger.fine("The DM starts listening agents messages for the '" + application.getName() + "' application.");
            RabbitMqUtils.declareApplicationExchanges(application.getName(), this.channel);
            String queueName = application.getName() + ".dm";
            this.channel.queueDeclare(queueName, true, false, true, null);
            String exchangeName = RabbitMqUtils.buildExchangeName(application, true);
            this.channel.queueBind(queueName, exchangeName, "");
            String consumerTag = this.channel.basicConsume(queueName, true, this.consumer);
            this.applicationNameToConsumerTag.put(application.getName(), consumerTag);
        }
    }

    @Override
    public void sendMessageToTheDm(Message msg) throws IOException {
        this.logger.fine("The DM sends a message to the DM's neutral queue.");
        this.channel.queueDeclare(DM_NEUTRAL_QUEUE_NAME, true, false, true, null);
        this.channel.basicPublish("", DM_NEUTRAL_QUEUE_NAME, new AMQP.BasicProperties.Builder().expiration("500").build(), SerializationUtils.serializeObject(msg));
        this.logger.fine("The DM sent a message to the DM's neutral queue.");
    }

    @Override
    public void listenToTheDm(IClient.ListenerCommand command) throws IOException {
        if (command == IClient.ListenerCommand.START) {
            if (this.neutralConsumerTag != null) {
                this.logger.finer("The DM is already listening to the neutral queue.");
                return;
            }
            this.channel.queueDeclare(DM_NEUTRAL_QUEUE_NAME, true, false, true, null);
            this.neutralConsumerTag = this.channel.basicConsume(DM_NEUTRAL_QUEUE_NAME, true, DM_NEUTRAL_QUEUE_NAME, false, false, null, this.consumer);
        } else {
            this.logger.fine("The DM stops listening to the neutral queue.");
            if (this.neutralConsumerTag != null && this.channel != null && this.channel.isOpen()) {
                this.channel.basicCancel(this.neutralConsumerTag);
            }
            this.neutralConsumerTag = null;
        }
    }

    @Override
    public void deleteMessagingServerArtifacts(Application application) throws IOException {
        this.channel.exchangeDelete(RabbitMqUtils.buildExchangeName(application, true));
        this.channel.exchangeDelete(RabbitMqUtils.buildExchangeName(application, false));
    }

    @Override
    public void propagateAgentTermination(Application application, Instance rootInstance) throws IOException {
        this.logger.fine("The DM is propagating the termination of agent '" + rootInstance + "'.");
        String exchangeName = RabbitMqUtils.buildExchangeName(application, false);
        List instances = InstanceHelpers.buildHierarchicalList((Instance)rootInstance);
        Collections.reverse(instances);
        for (Instance instance : instances) {
            for (String facetOrComponentName : VariableHelpers.findPrefixesForExportedVariables((Instance)instance)) {
                MsgCmdRemoveImport message = new MsgCmdRemoveImport(facetOrComponentName, InstanceHelpers.computeInstancePath((Instance)instance));
                this.channel.basicPublish(exchangeName, "those.that.import." + facetOrComponentName, null, SerializationUtils.serializeObject(message));
            }
        }
    }
}

