/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.internal.client.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.messaging.client.IAgentClient;
import net.roboconf.messaging.client.IClient;
import net.roboconf.messaging.messages.Message;

public class TestClientAgent
implements IAgentClient {
    public final List<Message> messagesForTheDm = new ArrayList<Message>();
    public AtomicInteger messagesForAgentsCount = new AtomicInteger();
    public AtomicBoolean connected = new AtomicBoolean(false);
    public AtomicBoolean failMessageSending = new AtomicBoolean(false);
    private String messageServerIp;
    private String messageServerUsername;
    private String messageServerPassword;
    private String applicationName;
    private String rootInstanceName;

    @Override
    public void setParameters(String messageServerIp, String messageServerUsername, String messageServerPassword) {
        this.messageServerIp = messageServerIp;
        this.messageServerPassword = messageServerPassword;
        this.messageServerUsername = messageServerUsername;
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public void openConnection() throws IOException {
        this.connected.set(true);
    }

    @Override
    public void closeConnection() throws IOException {
        this.connected.set(false);
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public void setRootInstanceName(String rootInstanceName) {
        this.rootInstanceName = rootInstanceName;
    }

    @Override
    public void publishExports(Instance instance) throws IOException {
        if (this.failMessageSending.get()) {
            throw new IOException("Message sending was configured to fail.");
        }
        this.messagesForAgentsCount.incrementAndGet();
    }

    @Override
    public void publishExports(Instance instance, String facetOrComponentName) throws IOException {
        if (this.failMessageSending.get()) {
            throw new IOException("Message sending was configured to fail.");
        }
        this.messagesForAgentsCount.incrementAndGet();
    }

    @Override
    public void unpublishExports(Instance instance) throws IOException {
        if (this.failMessageSending.get()) {
            throw new IOException("Message sending was configured to fail.");
        }
        this.messagesForAgentsCount.incrementAndGet();
    }

    @Override
    public void listenToRequestsFromOtherAgents(IClient.ListenerCommand command, Instance instance) throws IOException {
    }

    @Override
    public void requestExportsFromOtherAgents(Instance instance) throws IOException {
        if (this.failMessageSending.get()) {
            throw new IOException("Message sending was configured to fail.");
        }
        this.messagesForAgentsCount.incrementAndGet();
    }

    @Override
    public void listenToExportsFromOtherAgents(IClient.ListenerCommand command, Instance instance) throws IOException {
    }

    @Override
    public void sendMessageToTheDm(Message message) throws IOException {
        if (this.failMessageSending.get()) {
            throw new IOException("Message sending was configured to fail.");
        }
        this.messagesForTheDm.add(message);
    }

    @Override
    public void listenToTheDm(IClient.ListenerCommand command) throws IOException {
    }

    @Override
    public void setMessageQueue(LinkedBlockingQueue<Message> messageQueue) {
    }

    public String getMessageServerIp() {
        return this.messageServerIp;
    }

    public String getMessageServerUsername() {
        return this.messageServerUsername;
    }

    public String getMessageServerPassword() {
        return this.messageServerPassword;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getRootInstanceName() {
        return this.rootInstanceName;
    }
}

