/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.internal.client.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.messaging.client.IClient;
import net.roboconf.messaging.client.IDmClient;
import net.roboconf.messaging.messages.Message;

public class TestClientDm
implements IDmClient {
    public final List<Message> sentMessages = new ArrayList<Message>();
    public AtomicBoolean connected = new AtomicBoolean(false);
    public AtomicBoolean failMessageSending = new AtomicBoolean(false);
    private String messageServerIp;
    private String messageServerUsername;
    private String messageServerPassword;

    @Override
    public void setParameters(String messageServerIp, String messageServerUsername, String messageServerPassword) {
        this.messageServerIp = messageServerIp;
        this.messageServerPassword = messageServerPassword;
        this.messageServerUsername = messageServerUsername;
    }

    @Override
    public void closeConnection() throws IOException {
        this.connected.set(false);
    }

    @Override
    public void openConnection() throws IOException {
        this.connected.set(true);
    }

    @Override
    public void sendMessageToAgent(Application application, Instance instance, Message message) throws IOException {
        if (this.failMessageSending.get()) {
            throw new IOException("Message sending was configured to fail.");
        }
        this.sentMessages.add(message);
    }

    @Override
    public void listenToAgentMessages(Application application, IClient.ListenerCommand command) throws IOException {
    }

    @Override
    public void sendMessageToTheDm(Message msg) throws IOException {
        if (this.failMessageSending.get()) {
            throw new IOException("Message sending was configured to fail.");
        }
        this.sentMessages.add(msg);
    }

    @Override
    public void listenToTheDm(IClient.ListenerCommand command) throws IOException {
    }

    @Override
    public void deleteMessagingServerArtifacts(Application application) throws IOException {
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public void setMessageQueue(LinkedBlockingQueue<Message> messageQueue) {
    }

    @Override
    public void propagateAgentTermination(Application application, Instance rootInstance) throws IOException {
    }

    public String getMessageServerIp() {
        return this.messageServerIp;
    }

    public String getMessageServerUsername() {
        return this.messageServerUsername;
    }

    public String getMessageServerPassword() {
        return this.messageServerPassword;
    }
}

