/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.internal.utils;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ConsumerCancelledException;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.internal.utils.SerializationUtils;
import net.roboconf.messaging.messages.Message;

public final class RabbitMqUtils {
    private RabbitMqUtils() {
    }

    public static String buildExchangeName(String applicationName, boolean dm) {
        return applicationName + (dm ? ".admin" : ".agents");
    }

    public static String buildExchangeName(Application application, boolean dm) {
        return RabbitMqUtils.buildExchangeName(application.getName(), dm);
    }

    public static String buildRoutingKeyForAgent(Instance instance) {
        Instance rootInstance = InstanceHelpers.findRootInstance((Instance)instance);
        return RabbitMqUtils.buildRoutingKeyForAgent(rootInstance.getName());
    }

    public static String buildRoutingKeyForAgent(String rootInstanceName) {
        return "machine." + rootInstanceName;
    }

    public static void configureFactory(ConnectionFactory factory, String messageServerIp, String messageServerUsername, String messageServerPassword) throws IOException {
        if (messageServerIp != null) {
            Map.Entry entry = Utils.findUrlAndPort((String)messageServerIp);
            factory.setHost((String)entry.getKey());
            if ((Integer)entry.getValue() > 0) {
                factory.setPort((Integer)entry.getValue());
            }
        }
        factory.setUsername(messageServerUsername);
        factory.setPassword(messageServerPassword);
    }

    public static void closeConnection(Channel channel) throws IOException {
        if (channel != null) {
            if (channel.isOpen()) {
                channel.close();
            }
            if (channel.getConnection().isOpen()) {
                channel.getConnection().close();
            }
        }
    }

    public static void declareApplicationExchanges(String applicationName, Channel channel) throws IOException {
        String dmExchangeName = RabbitMqUtils.buildExchangeName(applicationName, true);
        channel.exchangeDeclare(dmExchangeName, "fanout");
        String agentExchangeName = RabbitMqUtils.buildExchangeName(applicationName, false);
        channel.exchangeDeclare(agentExchangeName, "topic");
    }

    public static void listenToRabbitMq(String sourceName, Logger logger, QueueingConsumer consumer, LinkedBlockingQueue<Message> messages) {
        logger.fine(sourceName + " starts listening to new messages.");
        while (true) {
            try {
                while (true) {
                    QueueingConsumer.Delivery delivery = consumer.nextDelivery();
                    Message message = SerializationUtils.deserializeObject(delivery.getBody());
                    StringBuilder sb = new StringBuilder();
                    sb.append(sourceName);
                    sb.append(" received a message ");
                    sb.append(message.getClass().getSimpleName());
                    sb.append(" on routing key '");
                    sb.append(delivery.getEnvelope().getRoutingKey());
                    sb.append("'.");
                    logger.finer(sb.toString());
                    messages.add(message);
                }
            }
            catch (ShutdownSignalException e) {
                logger.fine(sourceName + ": the message server is shutting down.");
            }
            catch (ConsumerCancelledException e) {
                logger.fine(sourceName + " stops listening to new messages.");
            }
            catch (InterruptedException e) {
                Utils.logException((Logger)logger, (Exception)e);
            }
            catch (ClassNotFoundException e) {
                logger.severe(sourceName + ": a message could not be deserialized. Class cast exception.");
                Utils.logException((Logger)logger, (Exception)e);
                continue;
            }
            catch (IOException e) {
                logger.severe(sourceName + ": a message could not be deserialized. I/O exception.");
                Utils.logException((Logger)logger, (Exception)e);
                continue;
            }
            break;
        }
        logger.fine("A message listening thread is now stopped.");
    }
}

