/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.processors;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import net.roboconf.messaging.client.IClient;
import net.roboconf.messaging.messages.Message;

public abstract class AbstractMessageProcessor<T extends IClient>
extends Thread {
    private final LinkedBlockingQueue<Message> messageQueue = new LinkedBlockingQueue();
    private final AtomicBoolean running = new AtomicBoolean(false);
    protected T messagingClient;

    public AbstractMessageProcessor(String threadName) {
        super(threadName);
    }

    public final void storeMessage(Message message) {
        this.messageQueue.add(message);
    }

    public LinkedBlockingQueue<Message> getMessageQueue() {
        return this.messageQueue;
    }

    public void setMessagingClient(T messagingClient) {
        this.messagingClient = messagingClient;
    }

    @Override
    public final void run() {
        this.running.set(true);
        while (this.running.get()) {
            try {
                Message message = this.messageQueue.take();
                if (!this.running.get()) continue;
                this.processMessage(message);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        Logger.getLogger(this.getClass().getName()).fine("Roboconf's message processing thread is stopping.");
        this.running.set(false);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void stopProcessor() {
        this.running.set(false);
    }

    protected abstract void processMessage(Message var1);
}

