/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.reconfigurables;

import java.io.IOException;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.client.IClient;
import net.roboconf.messaging.processors.AbstractMessageProcessor;

public abstract class ReconfigurableClient<T extends IClient>
implements IClient {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private AbstractMessageProcessor<T> messageProcessor;
    private T messagingClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchMessagingClient(String messageServerIp, String messageServerUser, String messageServerPwd, String factoryName) {
        T oldClient;
        IClient newMessagingClient = null;
        try {
            newMessagingClient = (IClient)this.createNewMessagingClient(messageServerIp, messageServerUser, messageServerPwd, factoryName);
            if (newMessagingClient != null) {
                newMessagingClient.setMessageQueue(this.messageProcessor.getMessageQueue());
                this.openConnection(newMessagingClient);
            }
        }
        catch (IOException e) {
            this.logger.warning("An error occured while creating a new messaging client. " + e.getMessage());
            Utils.logException((Logger)this.logger, (Exception)e);
        }
        ReconfigurableClient reconfigurableClient = this;
        synchronized (reconfigurableClient) {
            oldClient = this.messagingClient;
            this.messagingClient = newMessagingClient;
        }
        ReconfigurableClient.closeConnection(oldClient, "The previous client could not be terminated correctly.");
    }

    protected abstract T createNewMessagingClient(String var1, String var2, String var3, String var4) throws IOException;

    protected abstract void openConnection(T var1) throws IOException;

    protected abstract T getDismissedClient();

    protected abstract void configureMessageProcessor(AbstractMessageProcessor<T> var1);

    public void associateMessageProcessor(AbstractMessageProcessor<T> messageProcessor) {
        if (this.messageProcessor != null) {
            throw new IllegalArgumentException("The message processor was already defined.");
        }
        this.messageProcessor = messageProcessor;
        this.configureMessageProcessor(messageProcessor);
        this.messageProcessor.start();
    }

    public AbstractMessageProcessor<T> getMessageProcessor() {
        return this.messageProcessor;
    }

    public synchronized boolean hasValidClient() {
        return this.messagingClient != null && this.messagingClient.isConnected();
    }

    protected synchronized T getMessagingClient() {
        return this.messagingClient != null ? this.messagingClient : this.getDismissedClient();
    }

    protected synchronized void resetInternalClient() {
        this.messagingClient = null;
    }

    static void closeConnection(IClient client, String errorMessage) {
        if (client != null) {
            try {
                client.closeConnection();
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(ReconfigurableClient.class.getName());
                logger.warning(errorMessage + " " + e.getMessage());
                Utils.logException((Logger)logger, (Exception)e);
            }
        }
    }
}

