/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.reconfigurables;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.messaging.client.IAgentClient;
import net.roboconf.messaging.client.IClient;
import net.roboconf.messaging.internal.client.MessageServerClientFactory;
import net.roboconf.messaging.internal.client.dismiss.DismissClientAgent;
import net.roboconf.messaging.messages.Message;
import net.roboconf.messaging.messages.from_agent_to_dm.MsgNotifHeartbeat;
import net.roboconf.messaging.processors.AbstractMessageProcessor;
import net.roboconf.messaging.reconfigurables.ReconfigurableClient;

public class ReconfigurableClientAgent
extends ReconfigurableClient<IAgentClient>
implements IAgentClient {
    private String applicationName;
    private String rootInstanceName;
    private String ipAddress;
    private boolean needsModel = false;

    @Override
    protected IAgentClient createNewMessagingClient(String messageServerIp, String messageServerUser, String messageServerPwd, String factoryName) throws IOException {
        MessageServerClientFactory factory = new MessageServerClientFactory();
        IAgentClient client = factory.createAgentClient(factoryName);
        if (client != null) {
            client.setParameters(messageServerIp, messageServerUser, messageServerPwd);
        }
        return client;
    }

    @Override
    protected void openConnection(IAgentClient newMessagingClient) throws IOException {
        newMessagingClient.setApplicationName(this.applicationName);
        newMessagingClient.setRootInstanceName(this.rootInstanceName);
        newMessagingClient.openConnection();
        newMessagingClient.listenToTheDm(IClient.ListenerCommand.START);
        MsgNotifHeartbeat msg = new MsgNotifHeartbeat(this.applicationName, this.rootInstanceName, this.ipAddress);
        msg.setModelRequired(this.needsModel);
        newMessagingClient.sendMessageToTheDm(msg);
    }

    @Override
    protected IAgentClient getDismissedClient() {
        return new DismissClientAgent();
    }

    @Override
    protected void configureMessageProcessor(AbstractMessageProcessor<IAgentClient> messageProcessor) {
        messageProcessor.setMessagingClient(this);
    }

    @Override
    public void setParameters(String messageServerIp, String messageServerUsername, String messageServerPassword) {
        ((IAgentClient)this.getMessagingClient()).setParameters(messageServerIp, messageServerUsername, messageServerPassword);
    }

    @Override
    public void setMessageQueue(LinkedBlockingQueue<Message> messageQueue) {
        ((IAgentClient)this.getMessagingClient()).setMessageQueue(messageQueue);
    }

    @Override
    public boolean isConnected() {
        return ((IAgentClient)this.getMessagingClient()).isConnected();
    }

    @Override
    public void openConnection() throws IOException {
        ((IAgentClient)this.getMessagingClient()).openConnection();
    }

    @Override
    public void closeConnection() throws IOException {
        ((IAgentClient)this.getMessagingClient()).closeConnection();
        this.resetInternalClient();
    }

    @Override
    public void publishExports(Instance instance) throws IOException {
        ((IAgentClient)this.getMessagingClient()).publishExports(instance);
    }

    @Override
    public void publishExports(Instance instance, String facetOrComponentName) throws IOException {
        ((IAgentClient)this.getMessagingClient()).publishExports(instance, facetOrComponentName);
    }

    @Override
    public void unpublishExports(Instance instance) throws IOException {
        ((IAgentClient)this.getMessagingClient()).unpublishExports(instance);
    }

    @Override
    public void listenToRequestsFromOtherAgents(IClient.ListenerCommand command, Instance instance) throws IOException {
        ((IAgentClient)this.getMessagingClient()).listenToRequestsFromOtherAgents(command, instance);
    }

    @Override
    public void requestExportsFromOtherAgents(Instance instance) throws IOException {
        ((IAgentClient)this.getMessagingClient()).requestExportsFromOtherAgents(instance);
    }

    @Override
    public void listenToExportsFromOtherAgents(IClient.ListenerCommand command, Instance instance) throws IOException {
        ((IAgentClient)this.getMessagingClient()).listenToExportsFromOtherAgents(command, instance);
    }

    @Override
    public void sendMessageToTheDm(Message message) throws IOException {
        ((IAgentClient)this.getMessagingClient()).sendMessageToTheDm(message);
    }

    @Override
    public void listenToTheDm(IClient.ListenerCommand command) throws IOException {
        ((IAgentClient)this.getMessagingClient()).listenToTheDm(command);
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public void setRootInstanceName(String rootInstanceName) {
        this.rootInstanceName = rootInstanceName;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setNeedsModel(boolean needsModel) {
        this.needsModel = needsModel;
    }
}

