/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.reconfigurables;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.messaging.client.IClient;
import net.roboconf.messaging.client.IDmClient;
import net.roboconf.messaging.internal.client.MessageServerClientFactory;
import net.roboconf.messaging.internal.client.dismiss.DismissClientDm;
import net.roboconf.messaging.messages.Message;
import net.roboconf.messaging.processors.AbstractMessageProcessor;
import net.roboconf.messaging.reconfigurables.ReconfigurableClient;

public class ReconfigurableClientDm
extends ReconfigurableClient<IDmClient>
implements IDmClient {
    @Override
    protected IDmClient createNewMessagingClient(String messageServerIp, String messageServerUser, String messageServerPwd, String factoryName) throws IOException {
        MessageServerClientFactory factory = new MessageServerClientFactory();
        IDmClient client = factory.createDmClient(factoryName);
        if (client != null) {
            client.setParameters(messageServerIp, messageServerUser, messageServerPwd);
        }
        return client;
    }

    @Override
    protected void openConnection(IDmClient newMessagingClient) throws IOException {
        newMessagingClient.openConnection();
    }

    @Override
    protected IDmClient getDismissedClient() {
        return new DismissClientDm();
    }

    @Override
    protected void configureMessageProcessor(AbstractMessageProcessor<IDmClient> messageProcessor) {
        messageProcessor.setMessagingClient(this);
    }

    @Override
    public void setParameters(String messageServerIp, String messageServerUsername, String messageServerPassword) {
        ((IDmClient)this.getMessagingClient()).setParameters(messageServerIp, messageServerUsername, messageServerPassword);
    }

    @Override
    public void setMessageQueue(LinkedBlockingQueue<Message> messageQueue) {
        ((IDmClient)this.getMessagingClient()).setMessageQueue(messageQueue);
    }

    @Override
    public boolean isConnected() {
        return ((IDmClient)this.getMessagingClient()).isConnected();
    }

    @Override
    public void openConnection() throws IOException {
        ((IDmClient)this.getMessagingClient()).openConnection();
    }

    @Override
    public void closeConnection() throws IOException {
        ((IDmClient)this.getMessagingClient()).closeConnection();
        this.resetInternalClient();
    }

    @Override
    public void sendMessageToAgent(Application application, Instance instance, Message message) throws IOException {
        ((IDmClient)this.getMessagingClient()).sendMessageToAgent(application, instance, message);
    }

    @Override
    public void listenToAgentMessages(Application application, IClient.ListenerCommand command) throws IOException {
        ((IDmClient)this.getMessagingClient()).listenToAgentMessages(application, command);
    }

    @Override
    public void sendMessageToTheDm(Message msg) throws IOException {
        ((IDmClient)this.getMessagingClient()).sendMessageToTheDm(msg);
    }

    @Override
    public void listenToTheDm(IClient.ListenerCommand command) throws IOException {
        ((IDmClient)this.getMessagingClient()).listenToTheDm(command);
    }

    @Override
    public void deleteMessagingServerArtifacts(Application application) throws IOException {
        ((IDmClient)this.getMessagingClient()).deleteMessagingServerArtifacts(application);
    }

    @Override
    public void propagateAgentTermination(Application application, Instance rootInstance) throws IOException {
        ((IDmClient)this.getMessagingClient()).propagateAgentTermination(application, rootInstance);
    }
}

