/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.plugin.puppet.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.ProgramUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.plugin.api.PluginException;
import net.roboconf.plugin.api.PluginInterface;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class PluginPuppet
implements PluginInterface,
Pojo {
    InstanceManager __IM;
    public static final String PLUGIN_NAME = "puppet";
    private static final String MANIFESTS_FOLDER = "manifests";
    private boolean __Flogger;
    private final Logger logger;
    private boolean __FagentId;
    String agentId;
    private boolean __FapplicationName;
    String applicationName;
    private boolean __FscopedInstancePath;
    String scopedInstancePath;
    boolean __MgetPluginName;
    boolean __MsetNames$java_lang_String$java_lang_String;
    boolean __Minitialize$net_roboconf_core_model_beans_Instance;
    boolean __Mdeploy$net_roboconf_core_model_beans_Instance;
    boolean __Mstart$net_roboconf_core_model_beans_Instance;
    boolean __Mupdate$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus;
    boolean __Mstop$net_roboconf_core_model_beans_Instance;
    boolean __Mundeploy$net_roboconf_core_model_beans_Instance;
    boolean __MinstallPuppetModules$net_roboconf_core_model_beans_Instance;
    boolean __McallPuppetScript$net_roboconf_core_model_beans_Instance$java_lang_String$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean$java_io_File;
    boolean __MgenerateCodeToExecute$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean;
    boolean __MformatExportedVariables$java_util_Map;
    boolean __MformatInstanceImports$net_roboconf_core_model_beans_Instance;
    boolean __MformatImport$net_roboconf_core_model_beans_Import;

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    String __getagentId() {
        if (!this.__FagentId) {
            return this.agentId;
        }
        return (String)this.__IM.onGet((Object)this, "agentId");
    }

    void __setagentId(String string) {
        if (!this.__FagentId) {
            this.agentId = string;
            return;
        }
        this.__IM.onSet((Object)this, "agentId", (Object)string);
    }

    String __getapplicationName() {
        if (!this.__FapplicationName) {
            return this.applicationName;
        }
        return (String)this.__IM.onGet((Object)this, "applicationName");
    }

    void __setapplicationName(String string) {
        if (!this.__FapplicationName) {
            this.applicationName = string;
            return;
        }
        this.__IM.onSet((Object)this, "applicationName", (Object)string);
    }

    String __getscopedInstancePath() {
        if (!this.__FscopedInstancePath) {
            return this.scopedInstancePath;
        }
        return (String)this.__IM.onGet((Object)this, "scopedInstancePath");
    }

    void __setscopedInstancePath(String string) {
        if (!this.__FscopedInstancePath) {
            this.scopedInstancePath = string;
            return;
        }
        this.__IM.onSet((Object)this, "scopedInstancePath", (Object)string);
    }

    public PluginPuppet() {
        this(null);
    }

    private PluginPuppet(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
    }

    public String getPluginName() {
        String string;
        if (!this.__MgetPluginName) {
            return this.__M_getPluginName();
        }
        try {
            this.__IM.onEntry((Object)this, "getPluginName", new Object[0]);
            string = this.__M_getPluginName();
            this.__IM.onExit((Object)this, "getPluginName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPluginName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getPluginName() {
        return PLUGIN_NAME;
    }

    public void setNames(String applicationName, String scopedInstancePath) {
        if (!this.__MsetNames$java_lang_String$java_lang_String) {
            this.__M_setNames(applicationName, scopedInstancePath);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setNames$java_lang_String$java_lang_String", new Object[]{applicationName, scopedInstancePath});
            this.__M_setNames(applicationName, scopedInstancePath);
            this.__IM.onExit((Object)this, "setNames$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setNames$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setNames(String applicationName, String scopedInstancePath) {
        this.__setapplicationName(applicationName);
        this.__setscopedInstancePath(scopedInstancePath);
        this.__setagentId("'" + scopedInstancePath + "' agent");
    }

    public void initialize(Instance instance) throws PluginException {
        if (!this.__Minitialize$net_roboconf_core_model_beans_Instance) {
            this.__M_initialize(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initialize$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_initialize(instance);
            this.__IM.onExit((Object)this, "initialize$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initialize$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_initialize(Instance instance) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " is initializing the plug-in for " + instance.getName());
        try {
            this.installPuppetModules(instance);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void deploy(Instance instance) throws PluginException {
        if (!this.__Mdeploy$net_roboconf_core_model_beans_Instance) {
            this.__M_deploy(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deploy$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_deploy(instance);
            this.__IM.onExit((Object)this, "deploy$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deploy$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_deploy(Instance instance) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " is deploying instance " + instance.getName());
        File instanceDirectory = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)instance);
        try {
            this.callPuppetScript(instance, "deploy", PuppetState.STOPPED, null, false, instanceDirectory);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void start(Instance instance) throws PluginException {
        if (!this.__Mstart$net_roboconf_core_model_beans_Instance) {
            this.__M_start(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_start(instance);
            this.__IM.onExit((Object)this, "start$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_start(Instance instance) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " is starting instance " + instance.getName());
        File instanceDirectory = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)instance);
        try {
            this.callPuppetScript(instance, "start", PuppetState.RUNNING, null, false, instanceDirectory);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void update(Instance instance, Import importChanged, Instance.InstanceStatus statusChanged) throws PluginException {
        if (!this.__Mupdate$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus) {
            this.__M_update(instance, importChanged, statusChanged);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", new Object[]{instance, importChanged, statusChanged});
            this.__M_update(instance, importChanged, statusChanged);
            this.__IM.onExit((Object)this, "update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", throwable);
            throw throwable;
        }
    }

    private void __M_update(Instance instance, Import importChanged, Instance.InstanceStatus statusChanged) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " is updating instance " + instance.getName());
        File instanceDirectory = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)instance);
        try {
            this.callPuppetScript(instance, "update", PuppetState.UNDEF, importChanged, statusChanged == Instance.InstanceStatus.DEPLOYED_STARTED, instanceDirectory);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void stop(Instance instance) throws PluginException {
        if (!this.__Mstop$net_roboconf_core_model_beans_Instance) {
            this.__M_stop(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_stop(instance);
            this.__IM.onExit((Object)this, "stop$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_stop(Instance instance) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " is stopping instance " + instance.getName());
        File instanceDirectory = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)instance);
        try {
            this.callPuppetScript(instance, "stop", PuppetState.STOPPED, null, false, instanceDirectory);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void undeploy(Instance instance) throws PluginException {
        if (!this.__Mundeploy$net_roboconf_core_model_beans_Instance) {
            this.__M_undeploy(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "undeploy$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_undeploy(instance);
            this.__IM.onExit((Object)this, "undeploy$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "undeploy$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_undeploy(Instance instance) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " is undeploying instance " + instance.getName());
        File instanceDirectory = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)instance);
        try {
            this.callPuppetScript(instance, "undeploy", PuppetState.UNDEF, null, false, instanceDirectory);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    void installPuppetModules(Instance instance) throws IOException, InterruptedException {
        if (!this.__MinstallPuppetModules$net_roboconf_core_model_beans_Instance) {
            this.__M_installPuppetModules(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "installPuppetModules$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_installPuppetModules(instance);
            this.__IM.onExit((Object)this, "installPuppetModules$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "installPuppetModules$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_installPuppetModules(Instance instance) throws IOException, InterruptedException {
        File instanceDirectory = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)instance);
        File modulesFile = new File(instanceDirectory, "modules.properties");
        if (!modulesFile.exists()) {
            return;
        }
        Properties props = Utils.readPropertiesFile((File)modulesFile);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(PLUGIN_NAME);
            commands.add("module");
            commands.add("install");
            String value = entry.getValue().toString();
            if (!Utils.isEmptyOrWhitespaces((String)value)) {
                commands.add("--version");
                commands.add(value);
            }
            commands.add((String)entry.getKey());
            commands.add("--target-dir");
            commands.add(instanceDirectory.getAbsolutePath());
            Object[] params = commands.toArray(new String[0]);
            this.__getlogger().fine("Module installation: " + Arrays.toString(params));
            int exitCode = ProgramUtils.executeCommand((Logger)this.__getlogger(), commands, null, null, (String)this.__getapplicationName(), (String)this.__getscopedInstancePath());
            if (exitCode == 0) continue;
            throw new IOException("Puppet modules could not be installed for " + instance + ".");
        }
    }

    void callPuppetScript(Instance instance, String action, PuppetState puppetState, Import importChanged, boolean importAdded, File instanceDirectory) throws IOException, InterruptedException {
        if (!this.__McallPuppetScript$net_roboconf_core_model_beans_Instance$java_lang_String$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean$java_io_File) {
            this.__M_callPuppetScript(instance, action, puppetState, importChanged, importAdded, instanceDirectory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "callPuppetScript$net_roboconf_core_model_beans_Instance$java_lang_String$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean$java_io_File", new Object[]{instance, action, puppetState, importChanged, new Boolean(importAdded), instanceDirectory});
            this.__M_callPuppetScript(instance, action, puppetState, importChanged, importAdded, instanceDirectory);
            this.__IM.onExit((Object)this, "callPuppetScript$net_roboconf_core_model_beans_Instance$java_lang_String$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "callPuppetScript$net_roboconf_core_model_beans_Instance$java_lang_String$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_callPuppetScript(Instance instance, String action, PuppetState puppetState, Import importChanged, boolean importAdded, File instanceDirectory) throws IOException, InterruptedException {
        if (instance == null || instanceDirectory == null || !instanceDirectory.isDirectory()) {
            this.__getlogger().fine("Ignoring null or invalid instance directory");
            return;
        }
        this.__getlogger().info("Preparing the invocation of the script for " + action + " and instance " + instance.getName() + ".");
        File[] subFiles = instanceDirectory.listFiles();
        if (subFiles == null) {
            subFiles = new File[]{};
        }
        File moduleDirectory = null;
        for (File f : subFiles) {
            if (!f.isDirectory() || !f.getName().toLowerCase().startsWith("roboconf_")) continue;
            moduleDirectory = f;
            break;
        }
        if (moduleDirectory == null) {
            throw new IOException("The module directory could not be found. The module to execute must begin with 'roboconf_'.");
        }
        String clazz = moduleDirectory.getName() + "::" + action;
        File scriptFile = new File(moduleDirectory, "manifests/" + action + ".pp");
        if (!scriptFile.exists()) {
            clazz = moduleDirectory.getName();
            scriptFile = new File(moduleDirectory, "manifests/init.pp");
        }
        if (scriptFile.exists()) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(PLUGIN_NAME);
            commands.add("apply");
            commands.add("--verbose");
            commands.add("--detailed-exitcodes");
            String modpath = System.getenv("MODULEPATH");
            modpath = modpath != null ? modpath + (modpath.endsWith(File.pathSeparator) ? "" : File.pathSeparator) : "";
            modpath = modpath + instanceDirectory.getAbsolutePath();
            commands.add("--modulepath");
            commands.add(modpath);
            commands.add("--execute");
            commands.add(this.generateCodeToExecute(clazz, instance, puppetState, importChanged, importAdded));
            Object[] params = commands.toArray(new String[0]);
            this.__getlogger().fine("Module installation: " + Arrays.toString(params));
            int exitCode = ProgramUtils.executeCommand((Logger)this.__getlogger(), commands, null, null, (String)this.__getapplicationName(), (String)this.__getscopedInstancePath());
            switch (exitCode) {
                case 0: 
                case 2: {
                    this.__getlogger().fine("Puppet script properly completed with exit code " + exitCode + " (success codes are 2 and 0).");
                    break;
                }
                case 6: {
                    this.__getlogger().warning("Puppet script completed with changes and errors (exit code 6).");
                    break;
                }
                default: {
                    throw new IOException("Puppet script execution failed (exit code " + exitCode + ").");
                }
            }
        } else {
            this.__getlogger().warning("Ignoring action " + action + ": no manifest provided, neither specific nor default init.pp.");
        }
    }

    String generateCodeToExecute(String className, Instance instance, PuppetState puppetState, Import importChanged, boolean importAdded) {
        String string;
        if (!this.__MgenerateCodeToExecute$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean) {
            return this.__M_generateCodeToExecute(className, instance, puppetState, importChanged, importAdded);
        }
        try {
            this.__IM.onEntry((Object)this, "generateCodeToExecute$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean", new Object[]{className, instance, puppetState, importChanged, new Boolean(importAdded)});
            string = this.__M_generateCodeToExecute(className, instance, puppetState, importChanged, importAdded);
            this.__IM.onExit((Object)this, "generateCodeToExecute$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateCodeToExecute$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_generateCodeToExecute(String className, Instance instance, PuppetState puppetState, Import importChanged, boolean importAdded) {
        StringBuilder sb = new StringBuilder();
        sb.append("class{'");
        sb.append(className);
        sb.append("': runningState => ");
        sb.append(puppetState.toString().toLowerCase());
        Map exports = InstanceHelpers.findAllExportedVariables((Instance)instance);
        String args = this.formatExportedVariables(exports);
        String importedTypes = this.formatInstanceImports(instance);
        if (!Utils.isEmptyOrWhitespaces((String)args)) {
            sb.append(", " + args);
        }
        if (!Utils.isEmptyOrWhitespaces((String)importedTypes)) {
            sb.append(", " + importedTypes);
        }
        if (importChanged != null) {
            String componentName = importChanged.getComponentName();
            sb.append(", importDiff => {" + (importAdded ? "added => {" : "removed => {") + this.formatImport(importChanged) + "}, " + (importAdded ? "removed => undef" : "added => undef") + ", component => " + (componentName != null ? componentName : "undef") + "}");
        }
        sb.append("}");
        return sb.toString();
    }

    String formatExportedVariables(Map<String, String> instanceExports) {
        String string;
        if (!this.__MformatExportedVariables$java_util_Map) {
            return this.__M_formatExportedVariables(instanceExports);
        }
        try {
            this.__IM.onEntry((Object)this, "formatExportedVariables$java_util_Map", new Object[]{instanceExports});
            string = this.__M_formatExportedVariables(instanceExports);
            this.__IM.onExit((Object)this, "formatExportedVariables$java_util_Map", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "formatExportedVariables$java_util_Map", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_formatExportedVariables(Map<String, String> instanceExports) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : instanceExports.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String vname = (String)VariableHelpers.parseVariableName((String)entry.getKey()).getValue();
            sb.append(vname.toLowerCase());
            sb.append(" => ");
            if (Utils.isEmptyOrWhitespaces((String)entry.getValue())) {
                sb.append("undef");
                continue;
            }
            sb.append("'" + entry.getValue() + "'");
        }
        return sb.toString();
    }

    String formatInstanceImports(Instance instance) {
        String string;
        if (!this.__MformatInstanceImports$net_roboconf_core_model_beans_Instance) {
            return this.__M_formatInstanceImports(instance);
        }
        try {
            this.__IM.onEntry((Object)this, "formatInstanceImports$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            string = this.__M_formatInstanceImports(instance);
            this.__IM.onExit((Object)this, "formatInstanceImports$net_roboconf_core_model_beans_Instance", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "formatInstanceImports$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_formatInstanceImports(Instance instance) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String facetOrComponentName : VariableHelpers.findPrefixesForImportedVariables((Instance)instance)) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(facetOrComponentName.toLowerCase());
            sb.append(" => ");
            Collection imports = (Collection)instance.getImports().get(facetOrComponentName);
            if (imports == null || imports.isEmpty()) {
                sb.append("undef");
                continue;
            }
            sb.append("{ ");
            Iterator it = imports.iterator();
            while (it.hasNext()) {
                sb.append(this.formatImport((Import)it.next()));
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}");
        }
        return sb.toString();
    }

    private String formatImport(Import imp) {
        String string;
        if (!this.__MformatImport$net_roboconf_core_model_beans_Import) {
            return this.__M_formatImport(imp);
        }
        try {
            this.__IM.onEntry((Object)this, "formatImport$net_roboconf_core_model_beans_Import", new Object[]{imp});
            string = this.__M_formatImport(imp);
            this.__IM.onExit((Object)this, "formatImport$net_roboconf_core_model_beans_Import", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "formatImport$net_roboconf_core_model_beans_Import", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_formatImport(Import imp) {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(imp.getInstancePath());
        sb.append("' => { ");
        sb.append(this.formatExportedVariables(imp.getExportedVars()));
        sb.append(" }");
        return sb.toString();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("agentId")) {
                this.__FagentId = true;
            }
            if (set.contains("applicationName")) {
                this.__FapplicationName = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("scopedInstancePath")) {
                this.__FscopedInstancePath = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getPluginName")) {
                this.__MgetPluginName = true;
            }
            if (set.contains("setNames$java_lang_String$java_lang_String")) {
                this.__MsetNames$java_lang_String$java_lang_String = true;
            }
            if (set.contains("initialize$net_roboconf_core_model_beans_Instance")) {
                this.__Minitialize$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("deploy$net_roboconf_core_model_beans_Instance")) {
                this.__Mdeploy$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("start$net_roboconf_core_model_beans_Instance")) {
                this.__Mstart$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus")) {
                this.__Mupdate$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus = true;
            }
            if (set.contains("stop$net_roboconf_core_model_beans_Instance")) {
                this.__Mstop$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("undeploy$net_roboconf_core_model_beans_Instance")) {
                this.__Mundeploy$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("installPuppetModules$net_roboconf_core_model_beans_Instance")) {
                this.__MinstallPuppetModules$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("callPuppetScript$net_roboconf_core_model_beans_Instance$java_lang_String$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean$java_io_File")) {
                this.__McallPuppetScript$net_roboconf_core_model_beans_Instance$java_lang_String$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean$java_io_File = true;
            }
            if (set.contains("generateCodeToExecute$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean")) {
                this.__MgenerateCodeToExecute$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_plugin_puppet_internal_PluginPuppet$PuppetState$net_roboconf_core_model_beans_Import$boolean = true;
            }
            if (set.contains("formatExportedVariables$java_util_Map")) {
                this.__MformatExportedVariables$java_util_Map = true;
            }
            if (set.contains("formatInstanceImports$net_roboconf_core_model_beans_Instance")) {
                this.__MformatInstanceImports$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("formatImport$net_roboconf_core_model_beans_Import")) {
                this.__MformatImport$net_roboconf_core_model_beans_Import = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    public static enum PuppetState {
        RUNNING,
        STOPPED,
        UNDEF;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

