/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.target.azure.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.userdata.UserDataHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.target.api.TargetException;
import net.roboconf.target.api.TargetHandler;
import net.roboconf.target.api.TargetHandlerParameters;
import net.roboconf.target.azure.internal.AzureProperties;
import org.apache.commons.codec.binary.Base64;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AzureIaasHandler
implements TargetHandler,
Pojo {
    InstanceManager __IM;
    public static final String TARGET_ID = "iaas-azure";
    private boolean __Flogger;
    private final Logger logger;
    boolean __MgetTargetId;
    boolean __McreateMachine$net_roboconf_target_api_TargetHandlerParameters;
    boolean __MconfigureMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MgetKeyStore$java_lang_String$java_lang_String;
    boolean __MgetSSLSocketFactory$java_lang_String$java_lang_String;
    boolean __MprocessGetRequest$java_net_URL$java_lang_String$java_lang_String;
    boolean __MprocessPostRequest$java_net_URL$byte__$java_lang_String$java_lang_String$java_lang_String;
    boolean __MprocessDeleteRequest$java_net_URL$java_lang_String$java_lang_String;
    boolean __MconvertFileToByte$java_lang_String;
    boolean __MreplaceValueOfTagInXMLFile$java_lang_String$java_lang_String$java_lang_String;

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    public AzureIaasHandler() {
        this(null);
    }

    private AzureIaasHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
    }

    public String getTargetId() {
        String string;
        if (!this.__MgetTargetId) {
            return this.__M_getTargetId();
        }
        try {
            this.__IM.onEntry((Object)this, "getTargetId", new Object[0]);
            string = this.__M_getTargetId();
            this.__IM.onExit((Object)this, "getTargetId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTargetId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getTargetId() {
        return TARGET_ID;
    }

    public String createMachine(TargetHandlerParameters parameters) throws TargetException {
        String string;
        if (!this.__McreateMachine$net_roboconf_target_api_TargetHandlerParameters) {
            return this.__M_createMachine(parameters);
        }
        try {
            this.__IM.onEntry((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", new Object[]{parameters});
            string = this.__M_createMachine(parameters);
            this.__IM.onExit((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_createMachine(TargetHandlerParameters parameters) throws TargetException {
        String instanceId;
        try {
            if (InstanceHelpers.countInstances((String)parameters.getScopedInstancePath()) > 1) {
                throw new TargetException("Only root instances can be passed in arguments.");
            }
            String rootInstanceName = InstanceHelpers.findRootInstancePath((String)parameters.getScopedInstancePath());
            AzureProperties azureProperties = AzureIaasHandler.buildProperties(parameters.getTargetProperties());
            String userData = UserDataHelpers.writeUserDataAsString((Map)parameters.getMessagingProperties(), (String)parameters.getDomain(), (String)parameters.getApplicationName(), (String)rootInstanceName);
            String encodedUserData = new String(Base64.encodeBase64(userData.getBytes(StandardCharsets.UTF_8)), "UTF-8");
            this.replaceValueOfTagInXMLFile(azureProperties.getCreateCloudServiceTemplate(), "ServiceName", rootInstanceName);
            this.replaceValueOfTagInXMLFile(azureProperties.getCreateCloudServiceTemplate(), "Location", azureProperties.getLocation());
            this.replaceValueOfTagInXMLFile(azureProperties.getCreateDeploymentTemplate(), "CustomData", encodedUserData);
            this.replaceValueOfTagInXMLFile(azureProperties.getCreateDeploymentTemplate(), "Name", rootInstanceName);
            this.replaceValueOfTagInXMLFile(azureProperties.getCreateDeploymentTemplate(), "HostName", rootInstanceName);
            this.replaceValueOfTagInXMLFile(azureProperties.getCreateDeploymentTemplate(), "RoleName", rootInstanceName);
            this.replaceValueOfTagInXMLFile(azureProperties.getCreateDeploymentTemplate(), "RoleSize", azureProperties.getVMSize());
            this.replaceValueOfTagInXMLFile(azureProperties.getCreateDeploymentTemplate(), "SourceImageName", azureProperties.getVMTemplate());
            String baseURL = String.format("https://management.core.windows.net/%s/services", azureProperties.getSubscriptionId());
            String requestHeaderContentType = "application/xml";
            byte[] requestBodyCreateCloudService = this.convertFileToByte(azureProperties.getCreateCloudServiceTemplate());
            byte[] requestBodyCreateDeployment = this.convertFileToByte(azureProperties.getCreateDeploymentTemplate());
            String checkCloudServiceURL = baseURL + "/hostedservices/operations/isavailable/" + rootInstanceName;
            String createCloudServiceURL = baseURL + "/hostedservices";
            String createDeploymentURL = baseURL + "/hostedservices/" + rootInstanceName + "/deployments";
            String responseCheckCloudService = this.processGetRequest(new URL(checkCloudServiceURL), azureProperties.getKeyStoreFile(), azureProperties.getKeyStorePassword());
            boolean checkResult = AzureIaasHandler.getExistResutlFromXML(responseCheckCloudService, "Result");
            this.__getlogger().info("Response Result: Cloud Service Name is still available: " + checkResult);
            int rescodeCreateCloudService = -1;
            if (checkResult) {
                rescodeCreateCloudService = this.processPostRequest(new URL(createCloudServiceURL), requestBodyCreateCloudService, requestHeaderContentType, azureProperties.getKeyStoreFile(), azureProperties.getKeyStorePassword());
            }
            this.__getlogger().info("Create Cloud Service: Response Code: " + rescodeCreateCloudService);
            this.__getlogger().info("Creating Azure VM in progress: " + rootInstanceName);
            if (rescodeCreateCloudService == 201) {
                int rescodeCreateDeployment = this.processPostRequest(new URL(createDeploymentURL), requestBodyCreateDeployment, requestHeaderContentType, azureProperties.getKeyStoreFile(), azureProperties.getKeyStorePassword());
                this.__getlogger().info("Create VM: Response Code: " + rescodeCreateDeployment);
            }
            instanceId = rootInstanceName;
        }
        catch (Exception e) {
            throw new TargetException((Throwable)e);
        }
        return instanceId;
    }

    public void configureMachine(TargetHandlerParameters parameters, String machineId) throws TargetException {
        if (!this.__MconfigureMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            this.__M_configureMachine(parameters, machineId);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configureMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            this.__M_configureMachine(parameters, machineId);
            this.__IM.onExit((Object)this, "configureMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configureMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_configureMachine(TargetHandlerParameters parameters, String machineId) throws TargetException {
        this.__getlogger().fine("Configuring machine '" + machineId + "': nothing to configure.");
    }

    public boolean isMachineRunning(TargetHandlerParameters parameters, String machineId) throws TargetException {
        boolean bl;
        if (!this.__MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            return this.__M_isMachineRunning(parameters, machineId);
        }
        try {
            this.__IM.onEntry((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            bl = this.__M_isMachineRunning(parameters, machineId);
            this.__IM.onExit((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isMachineRunning(TargetHandlerParameters parameters, String machineId) throws TargetException {
        return false;
    }

    public void terminateMachine(TargetHandlerParameters parameters, String instanceId) throws TargetException {
        if (!this.__MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            this.__M_terminateMachine(parameters, instanceId);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, instanceId});
            this.__M_terminateMachine(parameters, instanceId);
            this.__IM.onExit((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_terminateMachine(TargetHandlerParameters parameters, String instanceId) throws TargetException {
        try {
            AzureProperties azureProperties = AzureIaasHandler.buildProperties(parameters.getTargetProperties());
            String baseURL = String.format("https://management.core.windows.net/%s/services", azureProperties.getSubscriptionId());
            String deleteCloudServiceURL = baseURL + "/hostedservices/" + instanceId + "?comp=media";
            int rescodeDeleteCloudService = this.processDeleteRequest(new URL(deleteCloudServiceURL), azureProperties.getKeyStoreFile(), azureProperties.getKeyStorePassword());
            this.__getlogger().info("Response Code: Delete VM: " + rescodeDeleteCloudService);
        }
        catch (Exception e) {
            throw new TargetException((Throwable)e);
        }
    }

    public String retrievePublicIpAddress(TargetHandlerParameters parameters, String machineId) throws TargetException {
        String string;
        if (!this.__MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            return this.__M_retrievePublicIpAddress(parameters, machineId);
        }
        try {
            this.__IM.onEntry((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            string = this.__M_retrievePublicIpAddress(parameters, machineId);
            this.__IM.onExit((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_retrievePublicIpAddress(TargetHandlerParameters parameters, String machineId) throws TargetException {
        return null;
    }

    static AzureProperties buildProperties(Map<String, String> targetProperties) throws TargetException {
        String[] properties;
        for (String property : properties = new String[]{"azure.subscription.id", "azure.key.store.file", "azure.key.store.password", "azure.create.cloud.service.template", "azure.create.deployment.template", "azure.location", "azure.vm.size", "azure.vm.template"}) {
            if (!Utils.isEmptyOrWhitespaces((String)targetProperties.get(property))) continue;
            throw new TargetException("The value for " + property + " cannot be null or empty.");
        }
        AzureProperties azureProperties = new AzureProperties();
        String s = targetProperties.get("azure.subscription.id");
        azureProperties.setSubscriptionId(s.trim());
        s = targetProperties.get("azure.key.store.file");
        azureProperties.setKeyStoreFile(s.trim());
        s = targetProperties.get("azure.key.store.password");
        azureProperties.setKeyStoreFile(s.trim());
        s = targetProperties.get("azure.create.cloud.service.template");
        azureProperties.setKeyStoreFile(s.trim());
        s = targetProperties.get("azure.create.deployment.template");
        azureProperties.setKeyStoreFile(s.trim());
        s = targetProperties.get("azure.location");
        azureProperties.setKeyStoreFile(s.trim());
        s = targetProperties.get("azure.vm.size");
        azureProperties.setKeyStoreFile(s.trim());
        s = targetProperties.get("azure.vm.template");
        azureProperties.setKeyStoreFile(s.trim());
        return azureProperties;
    }

    private KeyStore getKeyStore(String keyStoreName, String password) throws IOException {
        KeyStore keyStore;
        if (!this.__MgetKeyStore$java_lang_String$java_lang_String) {
            return this.__M_getKeyStore(keyStoreName, password);
        }
        try {
            this.__IM.onEntry((Object)this, "getKeyStore$java_lang_String$java_lang_String", new Object[]{keyStoreName, password});
            keyStore = this.__M_getKeyStore(keyStoreName, password);
            this.__IM.onExit((Object)this, "getKeyStore$java_lang_String$java_lang_String", (Object)keyStore);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getKeyStore$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore __M_getKeyStore(String keyStoreName, String password) throws IOException {
        KeyStore ks = null;
        FileInputStream fis = null;
        try {
            ks = KeyStore.getInstance("JKS");
            char[] passwordArray = password.toCharArray();
            fis = new FileInputStream(keyStoreName);
            ks.load(fis, passwordArray);
        }
        catch (Exception e) {
            try {
                this.__getlogger().severe(e.getMessage());
                Utils.logException((Logger)this.__getlogger(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(fis);
                throw throwable;
            }
            Utils.closeQuietly((InputStream)fis);
        }
        Utils.closeQuietly((InputStream)fis);
        return ks;
    }

    private SSLSocketFactory getSSLSocketFactory(String keyStoreName, String password) throws GeneralSecurityException, IOException {
        SSLSocketFactory sSLSocketFactory;
        if (!this.__MgetSSLSocketFactory$java_lang_String$java_lang_String) {
            return this.__M_getSSLSocketFactory(keyStoreName, password);
        }
        try {
            this.__IM.onEntry((Object)this, "getSSLSocketFactory$java_lang_String$java_lang_String", new Object[]{keyStoreName, password});
            sSLSocketFactory = this.__M_getSSLSocketFactory(keyStoreName, password);
            this.__IM.onExit((Object)this, "getSSLSocketFactory$java_lang_String$java_lang_String", (Object)sSLSocketFactory);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSSLSocketFactory$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return sSLSocketFactory;
    }

    private SSLSocketFactory __M_getSSLSocketFactory(String keyStoreName, String password) throws GeneralSecurityException, IOException {
        KeyStore ks = this.getKeyStore(keyStoreName, password);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(ks, password.toCharArray());
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        return context.getSocketFactory();
    }

    private static boolean getExistResutlFromXML(String xmlStr, String nameOfNode) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        DocumentBuilder b = f.newDocumentBuilder();
        Document doc = b.parse(new ByteArrayInputStream(xmlStr.getBytes(StandardCharsets.UTF_8)));
        NodeList nodes = doc.getElementsByTagName(nameOfNode);
        String result = "false";
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            result = node.getTextContent();
        }
        return Boolean.parseBoolean(result);
    }

    private String processGetRequest(URL url, String keyStore, String keyStorePassword) throws GeneralSecurityException, IOException {
        String string;
        if (!this.__MprocessGetRequest$java_net_URL$java_lang_String$java_lang_String) {
            return this.__M_processGetRequest(url, keyStore, keyStorePassword);
        }
        try {
            this.__IM.onEntry((Object)this, "processGetRequest$java_net_URL$java_lang_String$java_lang_String", new Object[]{url, keyStore, keyStorePassword});
            string = this.__M_processGetRequest(url, keyStore, keyStorePassword);
            this.__IM.onExit((Object)this, "processGetRequest$java_net_URL$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "processGetRequest$java_net_URL$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_processGetRequest(URL url, String keyStore, String keyStorePassword) throws GeneralSecurityException, IOException {
        SSLSocketFactory sslFactory = this.getSSLSocketFactory(keyStore, keyStorePassword);
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        con.setSSLSocketFactory(sslFactory);
        con.setRequestMethod("GET");
        con.addRequestProperty("x-ms-version", "2014-04-01");
        InputStream responseStream = (InputStream)con.getContent();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Utils.copyStreamSafely((InputStream)responseStream, (ByteArrayOutputStream)os);
        return os.toString("UTF-8");
    }

    private int processPostRequest(URL url, byte[] data, String contentType, String keyStore, String keyStorePassword) throws GeneralSecurityException, IOException {
        int n;
        if (!this.__MprocessPostRequest$java_net_URL$byte__$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_processPostRequest(url, data, contentType, keyStore, keyStorePassword);
        }
        try {
            this.__IM.onEntry((Object)this, "processPostRequest$java_net_URL$byte__$java_lang_String$java_lang_String$java_lang_String", new Object[]{url, data, contentType, keyStore, keyStorePassword});
            n = this.__M_processPostRequest(url, data, contentType, keyStore, keyStorePassword);
            this.__IM.onExit((Object)this, "processPostRequest$java_net_URL$byte__$java_lang_String$java_lang_String$java_lang_String", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "processPostRequest$java_net_URL$byte__$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_processPostRequest(URL url, byte[] data, String contentType, String keyStore, String keyStorePassword) throws GeneralSecurityException, IOException {
        SSLSocketFactory sslFactory = this.getSSLSocketFactory(keyStore, keyStorePassword);
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        con.setSSLSocketFactory(sslFactory);
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.addRequestProperty("x-ms-version", "2014-04-01");
        con.setRequestProperty("Content-Length", String.valueOf(data.length));
        con.setRequestProperty("Content-Type", contentType);
        DataOutputStream requestStream = new DataOutputStream(con.getOutputStream());
        requestStream.write(data);
        requestStream.flush();
        requestStream.close();
        return con.getResponseCode();
    }

    private int processDeleteRequest(URL url, String keyStore, String keyStorePassword) throws GeneralSecurityException, IOException {
        int n;
        if (!this.__MprocessDeleteRequest$java_net_URL$java_lang_String$java_lang_String) {
            return this.__M_processDeleteRequest(url, keyStore, keyStorePassword);
        }
        try {
            this.__IM.onEntry((Object)this, "processDeleteRequest$java_net_URL$java_lang_String$java_lang_String", new Object[]{url, keyStore, keyStorePassword});
            n = this.__M_processDeleteRequest(url, keyStore, keyStorePassword);
            this.__IM.onExit((Object)this, "processDeleteRequest$java_net_URL$java_lang_String$java_lang_String", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "processDeleteRequest$java_net_URL$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_processDeleteRequest(URL url, String keyStore, String keyStorePassword) throws GeneralSecurityException, IOException {
        SSLSocketFactory sslFactory = this.getSSLSocketFactory(keyStore, keyStorePassword);
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        con.setSSLSocketFactory(sslFactory);
        con.setRequestMethod("DELETE");
        con.addRequestProperty("x-ms-version", "2014-04-01");
        return con.getResponseCode();
    }

    private byte[] convertFileToByte(String xmlFilePath) {
        byte[] byArray;
        if (!this.__MconvertFileToByte$java_lang_String) {
            return this.__M_convertFileToByte(xmlFilePath);
        }
        try {
            this.__IM.onEntry((Object)this, "convertFileToByte$java_lang_String", new Object[]{xmlFilePath});
            byArray = this.__M_convertFileToByte(xmlFilePath);
            this.__IM.onExit((Object)this, "convertFileToByte$java_lang_String", (Object)byArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convertFileToByte$java_lang_String", throwable);
            throw throwable;
        }
        return byArray;
    }

    private byte[] __M_convertFileToByte(String xmlFilePath) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Utils.copyStream((File)new File(xmlFilePath), (OutputStream)os);
        }
        catch (IOException e) {
            this.__getlogger().severe(e.getMessage());
        }
        return os.toByteArray();
    }

    private void replaceValueOfTagInXMLFile(String filePath, String tagName, String replacingValue) throws ParserConfigurationException, SAXException, IOException {
        if (!this.__MreplaceValueOfTagInXMLFile$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_replaceValueOfTagInXMLFile(filePath, tagName, replacingValue);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "replaceValueOfTagInXMLFile$java_lang_String$java_lang_String$java_lang_String", new Object[]{filePath, tagName, replacingValue});
            this.__M_replaceValueOfTagInXMLFile(filePath, tagName, replacingValue);
            this.__IM.onExit((Object)this, "replaceValueOfTagInXMLFile$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "replaceValueOfTagInXMLFile$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_replaceValueOfTagInXMLFile(String filePath, String tagName, String replacingValue) throws ParserConfigurationException, SAXException, IOException {
        File fXmlFile = new File(filePath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName(tagName);
        Node nNode = nList.item(0);
        nNode.setTextContent(replacingValue);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(filePath));
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            this.__getlogger().severe(e.getMessage());
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("logger")) {
            this.__Flogger = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getTargetId")) {
                this.__MgetTargetId = true;
            }
            if (set.contains("createMachine$net_roboconf_target_api_TargetHandlerParameters")) {
                this.__McreateMachine$net_roboconf_target_api_TargetHandlerParameters = true;
            }
            if (set.contains("configureMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MconfigureMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("getKeyStore$java_lang_String$java_lang_String")) {
                this.__MgetKeyStore$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getSSLSocketFactory$java_lang_String$java_lang_String")) {
                this.__MgetSSLSocketFactory$java_lang_String$java_lang_String = true;
            }
            if (set.contains("processGetRequest$java_net_URL$java_lang_String$java_lang_String")) {
                this.__MprocessGetRequest$java_net_URL$java_lang_String$java_lang_String = true;
            }
            if (set.contains("processPostRequest$java_net_URL$byte__$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MprocessPostRequest$java_net_URL$byte__$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("processDeleteRequest$java_net_URL$java_lang_String$java_lang_String")) {
                this.__MprocessDeleteRequest$java_net_URL$java_lang_String$java_lang_String = true;
            }
            if (set.contains("convertFileToByte$java_lang_String")) {
                this.__MconvertFileToByte$java_lang_String = true;
            }
            if (set.contains("replaceValueOfTagInXMLFile$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MreplaceValueOfTagInXMLFile$java_lang_String$java_lang_String$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

