/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.target.vmware.internal;

import com.vmware.vim25.GuestProgramSpec;
import com.vmware.vim25.NamePasswordAuthentication;
import com.vmware.vim25.mo.GuestOperationsManager;
import com.vmware.vim25.mo.GuestProcessManager;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.target.api.AbstractThreadedTargetHandler;
import net.roboconf.target.api.TargetException;
import net.roboconf.target.vmware.internal.VmwareIaasHandler;

public class VmWareMachineConfigurator
implements AbstractThreadedTargetHandler.MachineConfigurator {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Map<String, String> targetProperties;
    private final String userData;
    private final String rootInstanceName;
    private final Instance scopedInstance;
    private int vmwareToolsCheckCount = 0;
    private ServiceInstance vmwareServiceInstance;

    public VmWareMachineConfigurator(Map<String, String> targetProperties, String userData, String rootInstanceName, Instance scopedInstance) {
        this.targetProperties = targetProperties;
        this.userData = userData;
        this.rootInstanceName = rootInstanceName;
        this.scopedInstance = scopedInstance;
    }

    public Instance getScopedInstance() {
        return this.scopedInstance;
    }

    public void close() throws IOException {
    }

    public boolean configure() throws TargetException {
        try {
            VirtualMachine vm;
            if (this.vmwareServiceInstance == null) {
                this.vmwareServiceInstance = VmwareIaasHandler.getServiceInstance(this.targetProperties);
            }
            if ((vm = VmwareIaasHandler.getVirtualMachine(this.vmwareServiceInstance, this.rootInstanceName)) == null) {
                this.logger.warning("No VM named '" + this.rootInstanceName + "' could be found. The VM might not yet be ready.");
                return false;
            }
            GuestOperationsManager gom = this.vmwareServiceInstance.getGuestOperationsManager();
            NamePasswordAuthentication npa = new NamePasswordAuthentication();
            npa.username = this.targetProperties.get("vmware.vmuser");
            npa.password = this.targetProperties.get("vmware.vmpassword");
            GuestProgramSpec spec = new GuestProgramSpec();
            spec.programPath = "/bin/echo";
            spec.arguments = "$'" + this.userData + "' > /tmp/roboconf.properties";
            this.logger.fine(spec.programPath + " " + spec.arguments);
            GuestProcessManager gpm = gom.getProcessManager(vm);
            gpm.startProgramInGuest(npa, spec);
            return true;
        }
        catch (Exception e) {
            if (++this.vmwareToolsCheckCount < 20) {
                this.logger.fine("VMWare tools not yet started... check #" + this.vmwareToolsCheckCount + " failed");
                return false;
            }
            throw new TargetException((Throwable)e);
        }
    }
}

