/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.target.vmware.internal;

import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.VirtualMachineCloneSpec;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.userdata.UserDataHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.target.api.AbstractThreadedTargetHandler;
import net.roboconf.target.api.TargetException;
import net.roboconf.target.api.TargetHandlerParameters;
import net.roboconf.target.vmware.internal.VmWareMachineConfigurator;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class VmwareIaasHandler
extends AbstractThreadedTargetHandler
implements Pojo {
    InstanceManager __IM;
    public static final String TARGET_ID = "iaas-vmware";
    static final String URL = "vmware.url";
    static final String USER = "vmware.user";
    static final String PASSWORD = "vmware.password";
    static final String IGNORE_CERTIFICATE = "vmware.ignorecert";
    static final String TEMPLATE = "vmware.template";
    static final String CLUSTER = "vmware.cluster";
    static final String DATA_CENTER = "vmware.datacenter";
    static final String VM_USER = "vmware.vmuser";
    static final String VM_PASSWORD = "vmware.vmpassword";
    private boolean __Flogger;
    private final Logger logger;
    boolean __MgetTargetId;
    boolean __McreateMachine$net_roboconf_target_api_TargetHandlerParameters;
    boolean __MmachineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    public VmwareIaasHandler() {
        this(null);
    }

    private VmwareIaasHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(Logger.getLogger(((Object)((Object)this)).getClass().getName()));
    }

    public String getTargetId() {
        String string;
        if (!this.__MgetTargetId) {
            return this.__M_getTargetId();
        }
        try {
            this.__IM.onEntry((Object)this, "getTargetId", new Object[0]);
            string = this.__M_getTargetId();
            this.__IM.onExit((Object)this, "getTargetId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTargetId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getTargetId() {
        return TARGET_ID;
    }

    public String createMachine(TargetHandlerParameters parameters) throws TargetException {
        String string;
        if (!this.__McreateMachine$net_roboconf_target_api_TargetHandlerParameters) {
            return this.__M_createMachine(parameters);
        }
        try {
            this.__IM.onEntry((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", new Object[]{parameters});
            string = this.__M_createMachine(parameters);
            this.__IM.onExit((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_createMachine(TargetHandlerParameters parameters) throws TargetException {
        this.__getlogger().fine("Creating a new VM @ VMware.");
        if (InstanceHelpers.countInstances((String)parameters.getScopedInstancePath()) > 1) {
            throw new TargetException("Only root instances can be passed in arguments.");
        }
        String rootInstanceName = InstanceHelpers.findRootInstancePath((String)parameters.getScopedInstancePath());
        try {
            System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            Map targetProperties = parameters.getTargetProperties();
            String machineImageId = (String)targetProperties.get(TEMPLATE);
            ServiceInstance vmwareServiceInstance = VmwareIaasHandler.getServiceInstance(targetProperties);
            ComputeResource vmwareComputeResource = (ComputeResource)new InventoryNavigator(vmwareServiceInstance.getRootFolder()).searchManagedEntity("ComputeResource", (String)targetProperties.get(CLUSTER));
            String userData = UserDataHelpers.writeUserDataAsString((Map)parameters.getMessagingProperties(), (String)parameters.getDomain(), (String)parameters.getApplicationName(), (String)rootInstanceName);
            VirtualMachine vm = VmwareIaasHandler.getVirtualMachine(vmwareServiceInstance, machineImageId);
            String vmwareDataCenter = (String)targetProperties.get(DATA_CENTER);
            Folder vmFolder = ((Datacenter)new InventoryNavigator(vmwareServiceInstance.getRootFolder()).searchManagedEntity("Datacenter", vmwareDataCenter)).getVmFolder();
            this.__getlogger().fine("machineImageId=" + machineImageId);
            if (vm == null || vmFolder == null) {
                throw new TargetException("VirtualMachine (= " + vm + " ) or Datacenter path (= " + vmFolder + " ) is NOT correct. Please, double check.");
            }
            VirtualMachineCloneSpec cloneSpec = new VirtualMachineCloneSpec();
            cloneSpec.setLocation(new VirtualMachineRelocateSpec());
            cloneSpec.setPowerOn(false);
            cloneSpec.setTemplate(true);
            VirtualMachineConfigSpec vmSpec = new VirtualMachineConfigSpec();
            vmSpec.setAnnotation(userData);
            cloneSpec.setConfig(vmSpec);
            Task task = vm.cloneVM_Task(vmFolder, rootInstanceName, cloneSpec);
            this.__getlogger().fine("Cloning the template: " + machineImageId + " ...");
            String status = task.waitForTask();
            if (!status.equals("success")) {
                throw new TargetException("Failure: Virtual Machine cannot be cloned.");
            }
            VirtualMachine vm2 = VmwareIaasHandler.getVirtualMachine(vmwareServiceInstance, rootInstanceName);
            this.__getlogger().fine("Transforming the clone template to Virtual machine ...");
            vm2.markAsVirtualMachine(vmwareComputeResource.getResourcePool(), null);
            DynamicProperty dprop = new DynamicProperty();
            dprop.setName("guestinfo.userdata");
            dprop.setVal(userData);
            vm2.getGuest().setDynamicProperty(new DynamicProperty[]{dprop});
            task = vm2.powerOnVM_Task(null);
            this.__getlogger().fine("Starting the virtual machine: " + rootInstanceName + " ...");
            status = task.waitForTask();
            if (!status.equals("success")) {
                throw new TargetException("Failure: Virtual Machine cannot be started.");
            }
            return vm2.getName();
        }
        catch (Exception e) {
            throw new TargetException((Throwable)e);
        }
    }

    public AbstractThreadedTargetHandler.MachineConfigurator machineConfigurator(TargetHandlerParameters parameters, String machineId) {
        AbstractThreadedTargetHandler.MachineConfigurator machineConfigurator;
        if (!this.__MmachineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            return this.__M_machineConfigurator(parameters, machineId);
        }
        try {
            this.__IM.onEntry((Object)this, "machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            machineConfigurator = this.__M_machineConfigurator(parameters, machineId);
            this.__IM.onExit((Object)this, "machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", (Object)machineConfigurator);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
        return machineConfigurator;
    }

    private AbstractThreadedTargetHandler.MachineConfigurator __M_machineConfigurator(TargetHandlerParameters parameters, String machineId) {
        String userData = "";
        try {
            userData = UserDataHelpers.writeUserDataAsString((Map)parameters.getMessagingProperties(), (String)parameters.getDomain(), (String)parameters.getApplicationName(), (String)parameters.getScopedInstancePath());
        }
        catch (IOException e) {
            this.__getlogger().severe("User data could not be generated.");
            Utils.logException((Logger)this.__getlogger(), (Throwable)e);
        }
        String rootInstanceName = InstanceHelpers.findRootInstancePath((String)parameters.getScopedInstancePath());
        return new VmWareMachineConfigurator(parameters.getTargetProperties(), userData, rootInstanceName, parameters.getScopedInstance());
    }

    public boolean isMachineRunning(TargetHandlerParameters parameters, String machineId) throws TargetException {
        boolean bl;
        if (!this.__MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            return this.__M_isMachineRunning(parameters, machineId);
        }
        try {
            this.__IM.onEntry((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            bl = this.__M_isMachineRunning(parameters, machineId);
            this.__IM.onExit((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isMachineRunning(TargetHandlerParameters parameters, String machineId) throws TargetException {
        boolean result;
        try {
            ServiceInstance vmwareServiceInstance = VmwareIaasHandler.getServiceInstance(parameters.getTargetProperties());
            VirtualMachine vm = VmwareIaasHandler.getVirtualMachine(vmwareServiceInstance, machineId);
            result = vm != null;
        }
        catch (Exception e) {
            throw new TargetException((Throwable)e);
        }
        return result;
    }

    public void terminateMachine(TargetHandlerParameters parameters, String machineId) throws TargetException {
        if (!this.__MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            this.__M_terminateMachine(parameters, machineId);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            this.__M_terminateMachine(parameters, machineId);
            this.__IM.onExit((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_terminateMachine(TargetHandlerParameters parameters, String machineId) throws TargetException {
        try {
            this.cancelMachineConfigurator(machineId);
            ServiceInstance vmwareServiceInstance = VmwareIaasHandler.getServiceInstance(parameters.getTargetProperties());
            VirtualMachine vm = VmwareIaasHandler.getVirtualMachine(vmwareServiceInstance, machineId);
            if (vm == null) {
                throw new TargetException("Error vm: " + machineId + " was not found");
            }
            Task task = vm.powerOffVM_Task();
            try {
                if (!task.waitForTask().equals("success")) {
                    throw new TargetException("Error while trying to stop vm: " + machineId);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            task = vm.destroy_Task();
            try {
                if (!task.waitForTask().equals("success")) {
                    throw new TargetException("Error while trying to remove vm: " + machineId);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception e) {
            throw new TargetException((Throwable)e);
        }
    }

    public String retrievePublicIpAddress(TargetHandlerParameters parameters, String machineId) throws TargetException {
        String string;
        if (!this.__MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            return this.__M_retrievePublicIpAddress(parameters, machineId);
        }
        try {
            this.__IM.onEntry((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            string = this.__M_retrievePublicIpAddress(parameters, machineId);
            this.__IM.onExit((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_retrievePublicIpAddress(TargetHandlerParameters parameters, String machineId) throws TargetException {
        String result = null;
        try {
            ServiceInstance vmwareServiceInstance = VmwareIaasHandler.getServiceInstance(parameters.getTargetProperties());
            String rootInstanceName = InstanceHelpers.findRootInstancePath((String)parameters.getScopedInstancePath());
            VirtualMachine vm = VmwareIaasHandler.getVirtualMachine(vmwareServiceInstance, rootInstanceName);
            if (vm != null) {
                result = vm.getGuest().getIpAddress();
            }
        }
        catch (Exception e) {
            throw new TargetException((Throwable)e);
        }
        return result;
    }

    static VirtualMachine getVirtualMachine(ServiceInstance vmwareServiceInstance, String virtualmachineName) throws RemoteException {
        VirtualMachine result = null;
        if (!Utils.isEmptyOrWhitespaces((String)virtualmachineName)) {
            Folder rootFolder = vmwareServiceInstance.getRootFolder();
            result = (VirtualMachine)new InventoryNavigator(rootFolder).searchManagedEntity("VirtualMachine", virtualmachineName);
        }
        return result;
    }

    static ServiceInstance getServiceInstance(Map<String, String> targetProperties) throws RemoteException, MalformedURLException {
        return new ServiceInstance(new URL(targetProperties.get(URL)), targetProperties.get(USER), targetProperties.get(PASSWORD), Boolean.parseBoolean(targetProperties.get(IGNORE_CERTIFICATE)));
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("logger")) {
            this.__Flogger = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getTargetId")) {
                this.__MgetTargetId = true;
            }
            if (set.contains("createMachine$net_roboconf_target_api_TargetHandlerParameters")) {
                this.__McreateMachine$net_roboconf_target_api_TargetHandlerParameters = true;
            }
            if (set.contains("machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MmachineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

