/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import net.rootdev.javardfa.Constants;
import net.rootdev.javardfa.EvalContext;
import net.rootdev.javardfa.Setting;
import net.rootdev.javardfa.StatementSink;
import net.rootdev.javardfa.literal.LiteralCollector;
import net.rootdev.javardfa.uri.IRIResolver;
import net.rootdev.javardfa.uri.URIExtractor;
import net.rootdev.javardfa.uri.URIExtractor10;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Parser
implements ContentHandler,
ErrorHandler {
    private final XMLEventFactory eventFactory;
    private final StatementSink sink;
    private final Set<Setting> settings;
    private final LiteralCollector literalCollector;
    private final URIExtractor extractor;
    int bnodeId = 0;
    private Locator locator;
    private EvalContext context;

    public Parser(StatementSink sink) {
        this(sink, XMLOutputFactory.newInstance(), XMLEventFactory.newInstance(), new URIExtractor10(new IRIResolver()));
    }

    public Parser(StatementSink sink, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, URIExtractor extractor) {
        this.sink = sink;
        this.eventFactory = eventFactory;
        this.settings = EnumSet.noneOf(Setting.class);
        this.extractor = extractor;
        this.literalCollector = new LiteralCollector(this, eventFactory, outputFactory);
        extractor.setSettings(this.settings);
        outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }

    public boolean isEnabled(Setting setting) {
        return this.settings.contains((Object)setting);
    }

    public void enable(Setting setting) {
        this.settings.add(setting);
    }

    public void disable(Setting setting) {
        this.settings.remove((Object)setting);
    }

    public void setBase(String base) {
        this.context = new EvalContext(base);
        if (this.isEnabled(Setting.OnePointOne)) {
            this.context.setPrefixes(Constants.CORE_DEFAULT_PREFIXES);
        }
        this.sink.setBase(this.context.getBase());
    }

    EvalContext parse(EvalContext context, StartElement element) throws XMLStreamException {
        String currentLanguage = context.language;
        boolean inXHTML = "http://www.w3.org/1999/xhtml".equals(element.getName().getNamespaceURI());
        if (element.getAttributeByName(Constants.xmlbaseNS) != null && !inXHTML) {
            context.setBase(element.getAttributeByName(Constants.xmlbaseNS).getValue());
            this.sink.setBase(context.getBase());
        }
        if (Constants.base.equals(element.getName()) && element.getAttributeByName(Constants.href) != null) {
            context.setBase(element.getAttributeByName(Constants.href).getValue());
            this.sink.setBase(context.getBase());
        }
        if (this.settings.contains((Object)Setting.ManualNamespaces)) {
            if (element.getAttributeByName(Constants.xmllang) != null) {
                currentLanguage = element.getAttributeByName(Constants.xmllang).getValue();
                if (currentLanguage.length() == 0) {
                    currentLanguage = null;
                }
            } else if (element.getAttributeByName(Constants.lang) != null && (currentLanguage = element.getAttributeByName(Constants.lang).getValue()).length() == 0) {
                currentLanguage = null;
            }
        } else if (element.getAttributeByName(Constants.xmllangNS) != null && (currentLanguage = element.getAttributeByName(Constants.xmllangNS).getValue()).length() == 0) {
            currentLanguage = null;
        }
        if (this.settings.contains((Object)Setting.OnePointOne)) {
            if (element.getAttributeByName(Constants.vocab) != null) {
                String vocab = element.getAttributeByName(Constants.vocab).getValue().trim();
                if (vocab.length() == 0) {
                    context.vocab = null;
                } else {
                    context.vocab = vocab;
                    this.emitTriples(context.base, Constants.rdfaUses, vocab);
                }
            }
            if (element.getAttributeByName(Constants.prefix) != null) {
                this.parsePrefixes(element.getAttributeByName(Constants.prefix).getValue(), context);
            }
        }
        String about = this.extractor.getURI(element, Constants.about, context);
        String src = this.extractor.getURI(element, Constants.src, context);
        String href = this.extractor.getURI(element, Constants.href, context);
        String resource = this.extractor.getURI(element, Constants.resource, context);
        String datatype = this.extractor.getURI(element, Constants.datatype, context);
        Attribute contentAttr = element.getAttributeByName(Constants.content);
        String content = contentAttr == null ? null : contentAttr.getValue();
        List<String> typeof = this.extractor.getURIs(element, Constants.typeof, context);
        List<String> rel = this.extractor.getURIs(element, Constants.rel, context);
        List<String> rev = this.extractor.getURIs(element, Constants.rev, context);
        List<String> property = this.extractor.getURIs(element, Constants.property, context);
        if (this.settings.contains((Object)Setting.OnePointOne)) {
            return this.parse11(rev, rel, about, src, resource, href, context, inXHTML, element, typeof, property, content, datatype, currentLanguage);
        }
        return this.parse10(rev, rel, about, src, resource, href, context, inXHTML, element, typeof, property, content, datatype, currentLanguage);
    }

    private EvalContext parse10(List<String> rev, List<String> rel, String about, String src, String resource, String href, EvalContext context, boolean inXHTML, StartElement element, List<String> typeof, List<String> property, String content, String datatype, String currentLanguage) {
        boolean skipElement = false;
        String newSubject = null;
        String currentObject = null;
        LinkedList<String> forwardProperties = new LinkedList<String>();
        LinkedList<String> backwardProperties = new LinkedList<String>();
        if (rev == null && rel == null) {
            newSubject = Parser.coalesce(about, src, resource, href);
            if (newSubject == null) {
                if (context.parent == null && !inXHTML) {
                    newSubject = context.base;
                } else if (Constants.body.equals(element.getName()) || Constants.head.equals(element.getName())) {
                    newSubject = context.base;
                } else if (typeof != null) {
                    newSubject = this.createBNode();
                } else {
                    if (context.parentObject != null) {
                        newSubject = context.parentObject;
                    }
                    if (property == null) {
                        skipElement = true;
                    }
                }
            }
        } else {
            newSubject = Parser.coalesce(about, src);
            if (newSubject == null) {
                if (context.parent == null && !inXHTML) {
                    newSubject = context.base;
                } else if (Constants.head.equals(element.getName()) || Constants.body.equals(element.getName())) {
                    newSubject = context.base;
                } else if (typeof != null) {
                    newSubject = this.createBNode();
                } else if (context.parentObject != null) {
                    newSubject = context.parentObject;
                }
            }
            currentObject = Parser.coalesce(resource, href);
        }
        if (newSubject != null && typeof != null) {
            for (String type : typeof) {
                this.emitTriples(newSubject, Constants.rdfType, type);
            }
        }
        if (this.settings.contains((Object)Setting.FormMode)) {
            if (Constants.form.equals(element.getName())) {
                this.emitTriples(newSubject, Constants.rdfType, "http://www.w3.org/1999/xhtml/vocab/#form");
            }
            if (Constants.input.equals(element.getName()) && element.getAttributeByName(Constants.name) != null) {
                currentObject = "?" + element.getAttributeByName(Constants.name).getValue();
            }
        }
        if (property != null) {
            if (content != null) {
                if (datatype == null || datatype.length() == 0) {
                    this.emitTriplesPlainLiteral(newSubject, property, content, currentLanguage);
                } else {
                    this.emitTriplesDatatypeLiteral(newSubject, property, content, datatype);
                }
            } else {
                this.literalCollector.collect(newSubject, property, datatype, currentLanguage);
            }
        }
        if (currentObject != null) {
            if (element.getAttributeByName(Constants.rel) != null) {
                this.emitTriples(newSubject, rel, currentObject);
            }
            if (element.getAttributeByName(Constants.rev) != null) {
                this.emitTriples(currentObject, rev, newSubject);
            }
        } else {
            if (element.getAttributeByName(Constants.rel) != null) {
                forwardProperties.addAll(rel);
            }
            if (element.getAttributeByName(Constants.rev) != null) {
                backwardProperties.addAll(rev);
            }
            if (!forwardProperties.isEmpty() || !backwardProperties.isEmpty()) {
                currentObject = this.createBNode();
            }
        }
        if (!skipElement && newSubject != null) {
            this.emitTriples(context.parentSubject, context.forwardProperties, newSubject);
            this.emitTriples(newSubject, context.backwardProperties, context.parentSubject);
        }
        EvalContext ec = new EvalContext(context);
        if (skipElement) {
            ec.language = currentLanguage;
        } else {
            ec.parentSubject = newSubject != null ? newSubject : context.parentSubject;
            ec.parentObject = currentObject != null ? currentObject : (newSubject != null ? newSubject : context.parentSubject);
            ec.language = currentLanguage;
            ec.forwardProperties = forwardProperties;
            ec.backwardProperties = backwardProperties;
        }
        return ec;
    }

    private EvalContext parse11(List<String> rev, List<String> rel, String about, String src, String resource, String href, EvalContext context, boolean inXHTML, StartElement element, List<String> typeof, List<String> property, String content, String datatype, String currentLanguage) {
        boolean skipElement = false;
        String newSubject = null;
        String currentObject = null;
        String typedResource = null;
        LinkedList<String> forwardProperties = new LinkedList<String>();
        LinkedList<String> backwardProperties = new LinkedList<String>();
        if (rev == null && rel == null) {
            if (property != null && content == null && datatype == null) {
                if (about != null && about != "__NONE__") {
                    newSubject = about;
                } else if (context.parent == null) {
                    newSubject = context.base;
                } else if (context.parentObject != null) {
                    newSubject = context.parentObject;
                }
                if (typeof != null) {
                    typedResource = about != null && about != "__NONE__" ? about : (context.parent == null ? context.base : Parser.coalesce(resource, href, src));
                    if (typedResource == null) {
                        typedResource = this.createBNode();
                    }
                    currentObject = typedResource;
                }
            } else {
                newSubject = Parser.coalesce(about, resource, href, src);
                if (newSubject == null) {
                    if (context.parent == null) {
                        newSubject = context.base;
                    } else if (typeof != null) {
                        newSubject = this.createBNode();
                    } else if (context.parentObject != null) {
                        newSubject = context.parentObject;
                        if (property == null) {
                            skipElement = true;
                        }
                    }
                }
                if (typeof != null) {
                    typedResource = newSubject;
                }
            }
        } else {
            if (about != null && about != "__NONE__") {
                newSubject = about;
            }
            if (typeof != null) {
                typedResource = newSubject;
            }
            if (newSubject == null) {
                if (context.parent == null) {
                    newSubject = context.base;
                } else if (context.parentObject != null) {
                    newSubject = context.parentObject;
                }
            }
            if ((currentObject = Parser.coalesce(resource, href, src)) == null && typeof != null && about == null) {
                currentObject = this.createBNode();
            }
            if (typeof != null && about == null) {
                typedResource = currentObject;
            }
        }
        if (typedResource != null) {
            for (String type : typeof) {
                this.emitTriples(typedResource, Constants.rdfType, type);
            }
        }
        if (currentObject != null) {
            if (rel != null) {
                this.emitTriples(newSubject, rel, currentObject);
            }
            if (rev != null) {
                this.emitTriples(currentObject, rev, newSubject);
            }
        } else {
            if (rel != null) {
                forwardProperties.addAll(rel);
            }
            if (rev != null) {
                backwardProperties.addAll(rev);
            }
            if (rev != null || rel != null) {
                currentObject = this.createBNode();
            }
        }
        if (property != null) {
            String propertyValue = null;
            if (content != null) {
                if (datatype == null || datatype.length() == 0) {
                    this.emitTriplesPlainLiteral(newSubject, property, content, currentLanguage);
                } else {
                    this.emitTriplesDatatypeLiteral(newSubject, property, content, datatype);
                }
                propertyValue = "__NONE__";
            } else if (datatype != null) {
                this.literalCollector.collect(newSubject, property, datatype, currentLanguage);
                propertyValue = "__NONE__";
            } else if (rev == null && rev == null && content == null) {
                propertyValue = Parser.coalesce(resource, href, src);
            }
            if (propertyValue == null && typeof != null && about == null) {
                propertyValue = typedResource;
            }
            if (propertyValue == null && content == null && datatype == null) {
                this.literalCollector.collect(newSubject, property, datatype, currentLanguage);
            }
            if (propertyValue != null && propertyValue != "__NONE__") {
                this.emitTriples(newSubject, property, propertyValue);
            }
        }
        if (!skipElement && newSubject != null) {
            this.emitTriples(context.parentSubject, context.forwardProperties, newSubject);
            this.emitTriples(newSubject, context.backwardProperties, context.parentSubject);
        }
        EvalContext ec = new EvalContext(context);
        if (skipElement) {
            ec.language = currentLanguage;
        } else {
            ec.parentSubject = newSubject != null ? newSubject : context.parentSubject;
            ec.parentObject = currentObject != null ? currentObject : (newSubject != null ? newSubject : context.parentSubject);
            ec.language = currentLanguage;
            ec.forwardProperties = forwardProperties;
            ec.backwardProperties = backwardProperties;
        }
        return ec;
    }

    public void emitTriples(String subj, Collection<String> props, String obj) {
        for (String prop : props) {
            if (prop.startsWith("_")) continue;
            this.sink.addObject(subj, prop, obj);
        }
    }

    public void emitTriplesPlainLiteral(String subj, Collection<String> props, String lex, String language) {
        for (String prop : props) {
            if (prop.startsWith("_")) continue;
            this.sink.addLiteral(subj, prop, lex, language, null);
        }
    }

    public void emitTriplesDatatypeLiteral(String subj, Collection<String> props, String lex, String datatype) {
        for (String prop : props) {
            if (prop.startsWith("_")) continue;
            this.sink.addLiteral(subj, prop, lex, null, datatype);
        }
    }

    private String createBNode() {
        return "_:node" + this.bnodeId++;
    }

    private void getNamespaces(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String qname = attrs.getQName(i);
            String prefix = this.getPrefix(qname);
            if (!"xmlns".equals(prefix)) continue;
            String pre = this.getLocal(prefix, qname);
            String uri = attrs.getValue(i);
            if (!this.settings.contains((Object)Setting.ManualNamespaces) && pre.contains("_")) continue;
            this.context.setNamespaceURI(pre, uri);
            this.sink.addPrefix(pre, uri);
        }
    }

    private String getPrefix(String qname) {
        if (!qname.contains(":")) {
            return "";
        }
        return qname.substring(0, qname.indexOf(":"));
    }

    private String getLocal(String prefix, String qname) {
        if (prefix.length() == 0) {
            return qname;
        }
        return qname.substring(prefix.length() + 1);
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
        this.locator = arg0;
        if (this.locator.getSystemId() != null) {
            this.setBase(arg0.getSystemId());
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.sink.start();
    }

    @Override
    public void endDocument() throws SAXException {
        this.sink.end();
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.context.setNamespaceURI(arg0, arg1);
        this.sink.addPrefix(arg0, arg1);
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void startElement(String arg0, String localname, String qname, Attributes arg3) throws SAXException {
        try {
            String prefix;
            if (this.context == null) {
                this.setBase(this.locator.getSystemId());
            }
            String string = prefix = qname.indexOf(58) == -1 ? "" : qname.substring(0, qname.indexOf(58));
            if (this.settings.contains((Object)Setting.ManualNamespaces)) {
                this.getNamespaces(arg3);
                if (prefix.length() != 0) {
                    arg0 = this.context.getNamespaceURI(prefix);
                    localname = localname.substring(prefix.length() + 1);
                }
            }
            StartElement e = this.eventFactory.createStartElement(prefix, arg0, localname, this.fromAttributes(arg3), null, this.context);
            if (this.literalCollector.isCollecting()) {
                this.literalCollector.handleEvent(e);
            }
            if (!this.literalCollector.isCollectingXML()) {
                this.context = this.parse(this.context, e);
            }
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Streaming issue", ex);
        }
    }

    @Override
    public void endElement(String arg0, String localname, String qname) throws SAXException {
        if (this.literalCollector.isCollecting()) {
            String prefix = localname.equals(qname) ? "" : qname.substring(0, qname.indexOf(58));
            EndElement e = this.eventFactory.createEndElement(prefix, arg0, localname);
            this.literalCollector.handleEvent(e);
        }
        if (!this.literalCollector.isCollectingXML()) {
            this.context = this.context.parent;
        }
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.literalCollector.isCollecting()) {
            Characters e = this.eventFactory.createCharacters(String.valueOf(arg0, arg1, arg2));
            this.literalCollector.handleEvent(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.literalCollector.isCollecting()) {
            Characters e = this.eventFactory.createIgnorableSpace(String.valueOf(arg0, arg1, arg2));
            this.literalCollector.handleEvent(e);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    private Iterator fromAttributes(Attributes attributes) {
        LinkedList<Attribute> toReturn = new LinkedList<Attribute>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qname = attributes.getQName(i);
            String prefix = qname.contains(":") ? qname.substring(0, qname.indexOf(":")) : "";
            Attribute attr = this.eventFactory.createAttribute(prefix, attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
            if (qname.equals("xmlns") || qname.startsWith("xmlns:")) continue;
            toReturn.add(attr);
        }
        return toReturn.iterator();
    }

    private void parsePrefixes(String value, EvalContext context) {
        String[] parts = value.split("\\s+");
        for (int i = 0; i < parts.length; i += 2) {
            String prefix = parts[i];
            if (i + 1 >= parts.length || !prefix.endsWith(":")) continue;
            String prefixFix = prefix.substring(0, prefix.length() - 1);
            context.setPrefix(prefixFix, parts[i + 1]);
            this.sink.addPrefix(prefixFix, parts[i + 1]);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        System.err.printf("Warning: %s\n", exception.getLocalizedMessage());
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        System.err.printf("Error: %s\n", exception.getLocalizedMessage());
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        System.err.printf("Fatal error: %s\n", exception.getLocalizedMessage());
    }

    private static <T> T coalesce(T a, T b) {
        if (a != null && a != "__NONE__") {
            return a;
        }
        return b;
    }

    private static <T> T coalesce(T a, T b, T c) {
        if (a != null && a != "__NONE__") {
            return a;
        }
        if (b != null && b != "__NONE__") {
            return b;
        }
        return c;
    }

    private static <T> T coalesce(T a, T b, T c, T d) {
        if (a != null && a != "__NONE__") {
            return a;
        }
        if (b != null && b != "__NONE__") {
            return b;
        }
        if (c != null && c != "__NONE__") {
            return c;
        }
        return d;
    }
}

