/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.jena;

import java.util.HashMap;
import java.util.Map;
import net.rootdev.javardfa.StatementSink;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaStatementSink
implements StatementSink {
    private static Logger log = LoggerFactory.getLogger(JenaStatementSink.class);
    private final Model model;
    private Map<String, Resource> bnodeLookup;

    public JenaStatementSink(Model model) {
        this.model = model;
    }

    @Override
    public void start() {
        this.bnodeLookup = new HashMap<String, Resource>();
    }

    @Override
    public void end() {
        this.bnodeLookup = null;
    }

    @Override
    public void addObject(String subject, String predicate, String object) {
        Resource s = this.getResource(subject);
        Property p = this.model.createProperty(predicate);
        Resource o = this.getResource(object);
        this.model.add(s, p, (RDFNode)o);
    }

    @Override
    public void addLiteral(String subject, String predicate, String lex, String lang, String datatype) {
        Resource s = this.getResource(subject);
        Property p = this.model.createProperty(predicate);
        Literal o = lang == null && datatype == null ? this.model.createLiteral(lex) : (lang != null ? this.model.createLiteral(lex, lang) : this.model.createTypedLiteral(lex, datatype));
        this.model.add(s, p, (RDFNode)o);
    }

    private Resource getResource(String res) {
        if (res.startsWith("_:")) {
            if (this.bnodeLookup.containsKey(res)) {
                return this.bnodeLookup.get(res);
            }
            Resource bnode = this.model.createResource();
            this.bnodeLookup.put(res, bnode);
            return bnode;
        }
        return this.model.createResource(res);
    }

    @Override
    public void addPrefix(String prefix, String uri) {
        try {
            this.model.setNsPrefix(prefix, uri);
        }
        catch (PrefixMapping.IllegalPrefixException e) {
            log.warn("Bad prefix, continuing.", (Throwable)e);
        }
    }

    @Override
    public void setBase(String base) {
    }
}

