/*
 * Decompiled with CFR 0.152.
 */
package net.rossonet.pmos.client3;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import net.rossonet.pmos.client3.PmosClient3;
import net.rossonet.pmos.client3.ProcessMakerClient3Exception;
import net.rossonet.pmos.client3.generated.ProcessMakerServiceStub;
import net.rossonet.pmos.client3.rest.ProcessMakerRestClient;
import org.apache.axis2.AxisFault;
import org.apache.http.ParseException;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.json.JSONArray;
import org.json.JSONObject;
import org.rossonet.utils.LogHelper;

public class ProcessMakerClient3
implements PmosClient3 {
    private static final Logger logger = Logger.getLogger(ProcessMakerClient3.class.getName());
    private ProcessMakerServiceStub client = null;
    private final String password;
    private ProcessMakerRestClient processMakerRestClient = null;
    private final String serverBaseUrl;
    private String sessionId = null;
    private final String soapEndpoint;
    private final String username;
    private final String workspace;

    ProcessMakerClient3(String serverBaseUrl, String workspace, String username, String password) {
        this.username = username;
        this.password = password;
        this.workspace = workspace;
        this.serverBaseUrl = serverBaseUrl;
        this.soapEndpoint = serverBaseUrl + "/sys" + workspace + "/en/neoclassic/services/soap2";
    }

    @Override
    public ProcessMakerServiceStub.AddCaseNoteResponse addCaseNote(ProcessMakerServiceStub.AddCaseNoteRequest addCaseNoteRequest) throws RemoteException {
        this.checkClient();
        addCaseNoteRequest.setSessionId(this.sessionId);
        return this.client.addCaseNote(addCaseNoteRequest);
    }

    @Override
    public ProcessMakerServiceStub.PmResponse assignUserToDepartment(ProcessMakerServiceStub.AssignUserToDepartmentRequest assignUserToDepartmentRequest) throws RemoteException {
        this.checkClient();
        assignUserToDepartmentRequest.setSessionId(this.sessionId);
        return this.client.assignUserToDepartment(assignUserToDepartmentRequest);
    }

    @Override
    public ProcessMakerServiceStub.PmResponse assignUserToGroup(ProcessMakerServiceStub.AssignUserToGroupRequest assignUserToGroupRequest) throws RemoteException {
        this.checkClient();
        assignUserToGroupRequest.setSessionId(this.sessionId);
        return this.client.assignUserToGroup(assignUserToGroupRequest);
    }

    @Override
    public ProcessMakerServiceStub.CancelCaseResponse cancelCase(ProcessMakerServiceStub.CancelCaseRequest cancelCaseRequest) throws RemoteException {
        this.checkClient();
        cancelCaseRequest.setSessionId(this.sessionId);
        return this.client.cancelCase(cancelCaseRequest);
    }

    @Override
    public ProcessMakerServiceStub.CaseListResponse caseList(ProcessMakerServiceStub.CaseListRequest caseListRequest) throws RemoteException {
        this.checkClient();
        caseListRequest.setSessionId(this.sessionId);
        return this.client.caseList(caseListRequest);
    }

    private void checkClient() throws RemoteException {
        if (this.client == null || this.sessionId == null) {
            throw new RemoteException("client disconnected");
        }
    }

    private void checkRestClient() throws RemoteException {
        if (this.processMakerRestClient == null || !this.processMakerRestClient.isValid()) {
            throw new RemoteException("rest client disconnected");
        }
    }

    @Override
    public ProcessMakerServiceStub.ClaimCaseResponse claimCase(ProcessMakerServiceStub.ClaimCaseRequest claimCaseRequest) throws RemoteException {
        this.checkClient();
        claimCaseRequest.setSessionId(this.sessionId);
        return this.client.claimCase(claimCaseRequest);
    }

    @Override
    public void close() throws Exception {
        this.disconnectRestApi();
        if (this.client != null) {
            this.disconnect();
        }
    }

    @Override
    public void connect() throws ProcessMakerClient3Exception {
        if (this.client == null) {
            try {
                this.client = new ProcessMakerServiceStub(this.soapEndpoint);
                ProcessMakerServiceStub.Login loginRequest = new ProcessMakerServiceStub.Login();
                loginRequest.setUserid(this.username);
                loginRequest.setPassword(this.password);
                ProcessMakerServiceStub.LoginResponse loginResponse = this.login(loginRequest);
                this.sessionId = loginResponse.getMessage();
            }
            catch (RemoteException e) {
                logger.severe(LogHelper.stackTraceToString((Throwable)e));
                new ProcessMakerClient3Exception(e);
            }
        } else {
            throw new ProcessMakerClient3Exception("client already connected, please disconnect before");
        }
    }

    @Override
    public void connectRestApi(String applicationId, String applicationSecret, ProcessMakerRestClient.AccessScope scope) {
        try {
            this.processMakerRestClient = new ProcessMakerRestClient(this.serverBaseUrl, this.workspace, applicationId, applicationSecret, scope, this.username, this.password);
        }
        catch (IOException e) {
            logger.severe(LogHelper.stackTraceToString((Throwable)e));
        }
    }

    @Override
    public ProcessMakerServiceStub.CreateDepartmentResponse createDepartment(ProcessMakerServiceStub.CreateDepartmentRequest createDepartmentRequest) throws RemoteException {
        this.checkClient();
        createDepartmentRequest.setSessionId(this.sessionId);
        return this.client.createDepartment(createDepartmentRequest);
    }

    @Override
    public ProcessMakerServiceStub.CreateGroupResponse createGroup(ProcessMakerServiceStub.CreateGroupRequest createGroupRequest) throws RemoteException {
        this.checkClient();
        createGroupRequest.setSessionId(this.sessionId);
        return this.client.createGroup(createGroupRequest);
    }

    @Override
    public ProcessMakerServiceStub.CreateUserResponse createUser(ProcessMakerServiceStub.CreateUserRequest createUserRequest) throws RemoteException {
        this.checkClient();
        createUserRequest.setSessionId(this.sessionId);
        return this.client.createUser(createUserRequest);
    }

    @Override
    public ProcessMakerServiceStub.DeleteCaseResponse deleteCase(ProcessMakerServiceStub.DeleteCaseRequest deleteCaseRequest) throws RemoteException {
        this.checkClient();
        deleteCaseRequest.setSessionId(this.sessionId);
        return this.client.deleteCase(deleteCaseRequest);
    }

    @Override
    public ProcessMakerServiceStub.DepartmentListResponse departmentList(ProcessMakerServiceStub.DepartmentListRequest departmentListRequest) throws RemoteException {
        this.checkClient();
        departmentListRequest.setSessionId(this.sessionId);
        return this.client.departmentList(departmentListRequest);
    }

    @Override
    public void disconnect() throws ProcessMakerClient3Exception {
        if (this.client != null) {
            try {
                this.client.cleanup();
                this.sessionId = null;
                this.client = null;
            }
            catch (AxisFault e) {
                new ProcessMakerClient3Exception((Exception)((Object)e));
            }
        } else {
            throw new ProcessMakerClient3Exception("client not connected");
        }
    }

    public void disconnectRestApi() {
        this.processMakerRestClient = null;
    }

    @Override
    public ProcessMakerServiceStub.PmResponse executeTrigger(ProcessMakerServiceStub.ExecuteTriggerRequest executeTriggerRequest) throws RemoteException {
        this.checkClient();
        executeTriggerRequest.setSessionId(this.sessionId);
        return this.client.executeTrigger(executeTriggerRequest);
    }

    @Override
    public ProcessMakerServiceStub.GetCaseInfoResponse getCaseInfo(ProcessMakerServiceStub.GetCaseInfoRequest getCaseInfoRequest) throws RemoteException {
        this.checkClient();
        getCaseInfoRequest.setSessionId(this.sessionId);
        return this.client.getCaseInfo(getCaseInfoRequest);
    }

    @Override
    public ProcessMakerServiceStub.GetCaseNotesResponse getCaseNotes(ProcessMakerServiceStub.GetCaseNotesRequest getCaseNotesRequest) throws RemoteException {
        this.checkClient();
        getCaseNotesRequest.setSessionId(this.sessionId);
        return this.client.getCaseNotes(getCaseNotesRequest);
    }

    @Override
    public JSONObject getDynaform(String projectUid, String dynaformUid) throws ProcessMakerClient3Exception {
        try {
            this.checkRestClient();
            return this.processMakerRestClient.getDynaform(projectUid, dynaformUid);
        }
        catch (IOException | ParseException e) {
            logger.severe(LogHelper.stackTraceToString((Throwable)e));
            throw new ProcessMakerClient3Exception((Exception)e);
        }
    }

    @Override
    public JSONArray getDynaforms(String projectUid) throws ProcessMakerClient3Exception {
        try {
            this.checkRestClient();
            return this.processMakerRestClient.getDynaforms(projectUid);
        }
        catch (IOException | ParseException e) {
            logger.severe(LogHelper.stackTraceToString((Throwable)e));
            throw new ProcessMakerClient3Exception((Exception)e);
        }
    }

    @Override
    public String getProcessAsXml(String projectUid) throws ProcessMakerClient3Exception {
        try {
            this.checkRestClient();
            return this.processMakerRestClient.getProcessAsXml(projectUid);
        }
        catch (IOException | ParseException e) {
            logger.severe(LogHelper.stackTraceToString((Throwable)e));
            throw new ProcessMakerClient3Exception((Exception)e);
        }
    }

    @Override
    public Document getProcessAsXmlDocument(String projectUid) throws ProcessMakerClient3Exception {
        try {
            SAXBuilder sax = new SAXBuilder();
            return sax.build((InputStream)new ByteArrayInputStream(this.getProcessAsXml(projectUid).getBytes()));
        }
        catch (IOException | ParseException | JDOMException e) {
            logger.severe(LogHelper.stackTraceToString((Throwable)e));
            throw new ProcessMakerClient3Exception((Exception)e);
        }
    }

    @Override
    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public String getSoapEndpoint() {
        return this.soapEndpoint;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public ProcessMakerServiceStub.GetVariablesResponse getVariables(ProcessMakerServiceStub.GetVariablesRequest getVariablesRequest) throws RemoteException {
        this.checkClient();
        getVariablesRequest.setSessionId(this.sessionId);
        return this.client.getVariables(getVariablesRequest);
    }

    @Override
    public ProcessMakerServiceStub.GetVariablesNamesResponse getVariablesNames(ProcessMakerServiceStub.GetVariablesNamesRequest getVariablesNamesRequest) throws RemoteException {
        this.checkClient();
        getVariablesNamesRequest.setSessionId(this.sessionId);
        return this.client.getVariablesNames(getVariablesNamesRequest);
    }

    @Override
    public String getWorkspace() {
        return this.workspace;
    }

    @Override
    public ProcessMakerServiceStub.GroupListResponse groupList(ProcessMakerServiceStub.GroupListRequest groupListRequest) throws RemoteException {
        this.checkClient();
        groupListRequest.setSessionId(this.sessionId);
        return this.client.groupList(groupListRequest);
    }

    @Override
    public ProcessMakerServiceStub.InformationUserResponse informationUser(ProcessMakerServiceStub.InformationUserRequest informationUserRequest) throws RemoteException {
        this.checkClient();
        informationUserRequest.setSessionId(this.sessionId);
        return this.client.informationUser(informationUserRequest);
    }

    @Override
    public ProcessMakerServiceStub.InputDocumentListResponse inputDocumentList(ProcessMakerServiceStub.InputDocumentListRequest inputDocumentListRequest) throws RemoteException {
        this.checkClient();
        inputDocumentListRequest.setSessionId(this.sessionId);
        return this.client.inputDocumentList(inputDocumentListRequest);
    }

    @Override
    public ProcessMakerServiceStub.InputDocumentProcessListResponse inputDocumentProcessList(ProcessMakerServiceStub.InputDocumentProcessListRequest inputDocumentProcessListRequest) throws RemoteException {
        this.checkClient();
        inputDocumentProcessListRequest.setSessionId(this.sessionId);
        return this.client.inputDocumentProcessList(inputDocumentProcessListRequest);
    }

    private ProcessMakerServiceStub.LoginResponse login(ProcessMakerServiceStub.Login login) throws RemoteException {
        return this.client.login(login);
    }

    @Override
    public ProcessMakerServiceStub.NewCaseResponse newCase(ProcessMakerServiceStub.NewCaseRequest newCaseRequest) throws RemoteException {
        this.checkClient();
        newCaseRequest.setSessionId(this.sessionId);
        return this.client.newCase(newCaseRequest);
    }

    @Override
    public ProcessMakerServiceStub.NewCaseImpersonateResponse newCaseImpersonate(ProcessMakerServiceStub.NewCaseImpersonateRequest newCaseImpersonateRequest) throws RemoteException {
        this.checkClient();
        newCaseImpersonateRequest.setSessionId(this.sessionId);
        return this.client.newCaseImpersonate(newCaseImpersonateRequest);
    }

    @Override
    public ProcessMakerServiceStub.OutputDocumentListResponse outputDocumentList(ProcessMakerServiceStub.OutputDocumentListRequest outputDocumentListRequest) throws RemoteException {
        this.checkClient();
        outputDocumentListRequest.setSessionId(this.sessionId);
        return this.client.outputDocumentList(outputDocumentListRequest);
    }

    @Override
    public ProcessMakerServiceStub.PauseCaseResponse pauseCase(ProcessMakerServiceStub.PauseCaseRequest pauseCaseRequest) throws RemoteException {
        this.checkClient();
        pauseCaseRequest.setSessionId(this.sessionId);
        return this.client.pauseCase(pauseCaseRequest);
    }

    @Override
    public ProcessMakerServiceStub.ProcessListResponse processList(ProcessMakerServiceStub.ProcessListRequest processListRequest) throws RemoteException {
        this.checkClient();
        processListRequest.setSessionId(this.sessionId);
        return this.client.processList(processListRequest);
    }

    @Override
    public ProcessMakerServiceStub.PmResponse reassignCase(ProcessMakerServiceStub.ReassignCaseRequest reassignCaseRequest) throws RemoteException {
        this.checkClient();
        reassignCaseRequest.setSessionId(this.sessionId);
        return this.client.reassignCase(reassignCaseRequest);
    }

    @Override
    public ProcessMakerServiceStub.RemoveDocumentResponse removeDocument(ProcessMakerServiceStub.RemoveDocumentRequest removeDocumentRequest) throws RemoteException {
        this.checkClient();
        removeDocumentRequest.setSessionId(this.sessionId);
        return this.client.removeDocument(removeDocumentRequest);
    }

    @Override
    public ProcessMakerServiceStub.PmResponse removeUserFromGroup(ProcessMakerServiceStub.RemoveUserFromGroupRequest removeUserFromGroupRequest) throws RemoteException {
        this.checkClient();
        removeUserFromGroupRequest.setSessionId(this.sessionId);
        return this.client.removeUserFromGroup(removeUserFromGroupRequest);
    }

    @Override
    public ProcessMakerServiceStub.RoleListResponse roleList(ProcessMakerServiceStub.RoleListRequest roleListRequest) throws RemoteException {
        this.checkClient();
        roleListRequest.setSessionId(this.sessionId);
        return this.client.roleList(roleListRequest);
    }

    @Override
    public ProcessMakerServiceStub.RouteCaseResponse routeCase(ProcessMakerServiceStub.RouteCaseRequest routeCaseRequest) throws RemoteException {
        this.checkClient();
        routeCaseRequest.setSessionId(this.sessionId);
        return this.client.routeCase(routeCaseRequest);
    }

    @Override
    public ProcessMakerServiceStub.PmResponse sendMessage(ProcessMakerServiceStub.SendMessageRequest sendMessageRequest) throws RemoteException {
        this.checkClient();
        sendMessageRequest.setSessionId(this.sessionId);
        return this.client.sendMessage(sendMessageRequest);
    }

    @Override
    public ProcessMakerServiceStub.PmResponse sendVariables(ProcessMakerServiceStub.SendVariablesRequest sendVariablesRequest) throws RemoteException {
        this.checkClient();
        sendVariablesRequest.setSessionId(this.sessionId);
        return this.client.sendVariables(sendVariablesRequest);
    }

    @Override
    public ProcessMakerServiceStub.TaskCaseResponse taskCase(ProcessMakerServiceStub.TaskCaseRequest taskCaseRequest) throws RemoteException {
        this.checkClient();
        taskCaseRequest.setSessionId(this.sessionId);
        return this.client.taskCase(taskCaseRequest);
    }

    @Override
    public ProcessMakerServiceStub.TaskListResponse taskList(ProcessMakerServiceStub.TaskListRequest taskListRequest) throws RemoteException {
        this.checkClient();
        taskListRequest.setSessionId(this.sessionId);
        return this.client.taskList(taskListRequest);
    }

    @Override
    public ProcessMakerServiceStub.TriggerListResponse triggerList(ProcessMakerServiceStub.TriggerListRequest triggerListRequest) throws RemoteException {
        this.checkClient();
        triggerListRequest.setSessionId(this.sessionId);
        return this.client.triggerList(triggerListRequest);
    }

    @Override
    public ProcessMakerServiceStub.UnassignedCaseListResponse unassignedCaseList(ProcessMakerServiceStub.UnassignedCaseListRequest unassignedCaseListRequest) throws RemoteException {
        this.checkClient();
        unassignedCaseListRequest.setSessionId(this.sessionId);
        return this.client.unassignedCaseList(unassignedCaseListRequest);
    }

    @Override
    public ProcessMakerServiceStub.UnpauseCaseResponse unpauseCase(ProcessMakerServiceStub.UnpauseCaseRequest unpauseCaseRequest) throws RemoteException {
        this.checkClient();
        unpauseCaseRequest.setSessionId(this.sessionId);
        return this.client.unpauseCase(unpauseCaseRequest);
    }

    @Override
    public ProcessMakerServiceStub.UpdateUserResponse updateUser(ProcessMakerServiceStub.UpdateUserRequest updateUserRequest) throws RemoteException {
        this.checkClient();
        updateUserRequest.setSessionId(this.sessionId);
        return this.client.updateUser(updateUserRequest);
    }

    @Override
    public ProcessMakerServiceStub.UserListResponse userList(ProcessMakerServiceStub.UserListRequest userListRequest) throws RemoteException {
        this.checkClient();
        userListRequest.setSessionId(this.sessionId);
        return this.client.userList(userListRequest);
    }
}

