/*
 * Decompiled with CFR 0.152.
 */
package net.rossonet.pmos.client3.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.rossonet.utils.LogHelper;

public class ProcessMakerRestClient {
    private static final Logger logger = Logger.getLogger(ProcessMakerRestClient.class.getName());
    private final String applicationId;
    private final String applicationSecret;
    private final String baseUrl;
    private long expire;
    private final String password;
    private String refreshToken;
    private final AccessScope scope;
    private String token;
    private final String username;
    private final String workspace;

    public ProcessMakerRestClient(String baseUrl, String workspace, String applicationId, String applicationSecret, AccessScope scope, String username, String password) throws IOException {
        this.baseUrl = baseUrl;
        this.workspace = workspace;
        this.applicationId = applicationId;
        this.applicationSecret = applicationSecret;
        this.scope = scope;
        this.username = username;
        this.password = password;
        this.findTokens(false);
    }

    /*
     * Exception decompiling
     */
    public JSONObject getDynaform(String projectUid, String dynaformUid) throws ParseException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public JSONArray getDynaforms(String projectUid) throws ParseException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getExpire() {
        return this.expire;
    }

    /*
     * Exception decompiling
     */
    public String getProcessAsXml(String projectUid) throws ParseException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isValid() {
        long time = new Date().getTime();
        if (this.expire - 5000L < time) {
            logger.info("refresh expired token [" + this.expire + "," + time + "]");
            this.token = null;
            try {
                this.findTokens(true);
            }
            catch (IOException e) {
                logger.severe(LogHelper.stackTraceToString((Throwable)e));
                return false;
            }
        }
        return this.token != null && this.refreshToken != null && !this.token.isEmpty() && !this.refreshToken.isEmpty();
    }

    private void findTokens(boolean refresh) throws IOException {
        HttpPost httpPost = new HttpPost(this.baseUrl + "/" + this.workspace + "/oauth2/token");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("grant_type", refresh ? "refresh_token" : "password"));
        params.add(new BasicNameValuePair("client_id", this.applicationId));
        params.add(new BasicNameValuePair("client_secret", this.applicationSecret));
        if (refresh) {
            params.add(new BasicNameValuePair("refresh_token", this.refreshToken));
        } else {
            params.add(new BasicNameValuePair("scope", this.scope.getScope()));
            params.add(new BasicNameValuePair("username", this.username));
            params.add(new BasicNameValuePair("password", this.password));
        }
        UrlEncodedFormEntity requestEntity = new UrlEncodedFormEntity(params);
        httpPost.setEntity((HttpEntity)requestEntity);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            JSONObject jsonReply = new JSONObject(EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
            this.token = jsonReply.getString("access_token");
            this.refreshToken = jsonReply.getString("refresh_token");
            this.expire = new Date().getTime() + (long)(jsonReply.getInt("expires_in") * 1000);
        }
    }

    public static enum AccessScope {
        ALL("*"),
        EDIT_PROCESS("edit_process"),
        VIEW_PROCESS("view_process");

        private String scope;

        private AccessScope(String scope) {
            this.scope = scope;
        }

        public String getScope() {
            return this.scope;
        }
    }
}

