/*
 * Decompiled with CFR 0.152.
 */
package net.saliman.spring.request.correlation.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import net.saliman.spring.request.correlation.support.RequestCorrelationProperties;
import net.saliman.spring.request.correlation.support.RequestCorrelationUtils;
import org.springframework.util.Assert;

public class FeignCorrelationInterceptor
implements RequestInterceptor {
    private final RequestCorrelationProperties properties;

    public FeignCorrelationInterceptor(RequestCorrelationProperties properties) {
        Assert.notNull((Object)properties, (String)"Parameter 'properties' can not be null");
        this.properties = properties;
    }

    public void apply(RequestTemplate template) {
        String requestId;
        String sessionId = RequestCorrelationUtils.getCurrentSessionId();
        if (sessionId != null) {
            template.header(this.properties.getSessionHeaderName(), new String[]{sessionId});
        }
        if ((requestId = RequestCorrelationUtils.getCurrentRequestId()) != null) {
            template.header(this.properties.getRequestHeaderName(), new String[]{requestId});
        }
    }
}

