/*
 * Decompiled with CFR 0.152.
 */
package net.saliman.spring.request.correlation.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.saliman.spring.request.correlation.api.CorrelationIdGenerator;
import net.saliman.spring.request.correlation.api.RequestCorrelation;
import net.saliman.spring.request.correlation.api.RequestCorrelationInterceptor;
import net.saliman.spring.request.correlation.filter.DefaultRequestCorrelation;
import net.saliman.spring.request.correlation.support.RequestCorrelationProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RequestCorrelationFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(RequestCorrelationFilter.class);
    private final CorrelationIdGenerator correlationIdGenerator;
    private final List<RequestCorrelationInterceptor> interceptors;
    private final RequestCorrelationProperties properties;

    public RequestCorrelationFilter(CorrelationIdGenerator correlationIdGenerator, List<RequestCorrelationInterceptor> interceptors, RequestCorrelationProperties properties) {
        Assert.notNull((Object)correlationIdGenerator, (String)"Parameter 'correlationIdGenerator' can not be null.");
        Assert.notNull(interceptors, (String)"Parameter 'interceptors' can not be null.");
        Assert.notNull((Object)properties, (String)"Parameter 'properties' can not be null.");
        this.correlationIdGenerator = correlationIdGenerator;
        this.interceptors = interceptors;
        this.properties = properties;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doHttpFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHttpFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestId;
        String sessionId = this.getSessionId(request);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = this.generateSessionId(request);
            logger.debug("Session correlation id was not present, generating new one: {}", (Object)sessionId);
        }
        if (StringUtils.isBlank((CharSequence)(requestId = this.getRequestId(request)))) {
            requestId = this.generateRequestId(request);
            logger.debug("Request correlation id was not present, generating new one: {}", (Object)requestId);
        }
        this.triggerInterceptors(sessionId, requestId);
        DefaultRequestCorrelation requestCorrelation = new DefaultRequestCorrelation(sessionId, requestId);
        ServletRequest req = this.enrichRequest(request, requestCorrelation);
        try {
            chain.doFilter(req, (ServletResponse)response);
        }
        finally {
            this.triggerInterceptorsCleanup(sessionId, requestId);
        }
    }

    private String getSessionId(HttpServletRequest request) {
        return request.getHeader(this.properties.getSessionHeaderName());
    }

    private String getRequestId(HttpServletRequest request) {
        return request.getHeader(this.properties.getRequestHeaderName());
    }

    private String generateSessionId(HttpServletRequest request) {
        return this.correlationIdGenerator.generateSessionId(request);
    }

    private String generateRequestId(HttpServletRequest request) {
        return this.correlationIdGenerator.generateRequestId(request);
    }

    private void triggerInterceptors(String sessionId, String requestId) {
        for (RequestCorrelationInterceptor interceptor : this.interceptors) {
            interceptor.afterCorrelationIdSet(sessionId, requestId);
        }
    }

    private void triggerInterceptorsCleanup(String sessionId, String requestId) {
        for (RequestCorrelationInterceptor interceptor : this.interceptors) {
            interceptor.cleanUp(sessionId, requestId);
        }
    }

    private ServletRequest enrichRequest(HttpServletRequest request, RequestCorrelation correlationId) {
        CorrelatedServletRequest req = new CorrelatedServletRequest(request);
        req.setAttribute("RequestCorrelation.ATTRIBUTE", correlationId);
        req.setHeader(this.properties.getSessionHeaderName(), correlationId.getSessionId());
        req.setHeader(this.properties.getRequestHeaderName(), correlationId.getRequestId());
        return req;
    }

    private static class CorrelatedServletRequest
    extends HttpServletRequestWrapper {
        private final Map<String, String> additionalHeaders = new ConcurrentHashMap<String, String>();

        public CorrelatedServletRequest(HttpServletRequest request) {
            super(request);
        }

        public void setHeader(String key, String value) {
            this.additionalHeaders.put(key, value);
        }

        public String getHeader(String name) {
            if (this.additionalHeaders.containsKey(name)) {
                return this.additionalHeaders.get(name);
            }
            return super.getHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            ArrayList<String> values = new ArrayList<String>();
            if (this.additionalHeaders.containsKey(name)) {
                values.add(this.additionalHeaders.get(name));
            } else {
                values.addAll(Collections.list(super.getHeaders(name)));
            }
            return Collections.enumeration(values);
        }

        public Enumeration<String> getHeaderNames() {
            HashSet<String> names = new HashSet<String>();
            names.addAll(this.additionalHeaders.keySet());
            names.addAll(Collections.list(super.getHeaderNames()));
            return Collections.enumeration(names);
        }
    }
}

