/*
 * Decompiled with CFR 0.152.
 */
package net.saliman.spring.request.correlation.http;

import java.util.ArrayList;
import java.util.List;
import net.saliman.spring.request.correlation.http.ClientHttpRequestCorrelationInterceptor;
import net.saliman.spring.request.correlation.support.RequestCorrelationProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.support.InterceptingHttpAccessor;

@Configuration
@ConditionalOnClass(value={InterceptingHttpAccessor.class})
@ConditionalOnProperty(value={"request.correlation.client.http.enabled"}, matchIfMissing=true)
public class ClientHttpCorrelationConfiguration {
    @Autowired(required=false)
    private List<InterceptingHttpAccessor> clients = new ArrayList<InterceptingHttpAccessor>();

    @Bean
    public InitializingBean clientsCorrelationInitializer(final RequestCorrelationProperties properties) {
        return new InitializingBean(){

            public void afterPropertiesSet() throws Exception {
                if (ClientHttpCorrelationConfiguration.this.clients != null) {
                    for (InterceptingHttpAccessor client : ClientHttpCorrelationConfiguration.this.clients) {
                        ArrayList<ClientHttpRequestCorrelationInterceptor> interceptors = new ArrayList<ClientHttpRequestCorrelationInterceptor>(client.getInterceptors());
                        interceptors.add(new ClientHttpRequestCorrelationInterceptor(properties));
                        client.setInterceptors(interceptors);
                    }
                }
            }
        };
    }
}

