/*
 * Decompiled with CFR 0.152.
 */
package net.saliman.spring.request.correlation.http;

import java.io.IOException;
import net.saliman.spring.request.correlation.support.RequestCorrelationProperties;
import net.saliman.spring.request.correlation.support.RequestCorrelationUtils;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public class ClientHttpRequestCorrelationInterceptor
implements ClientHttpRequestInterceptor {
    private final RequestCorrelationProperties properties;

    public ClientHttpRequestCorrelationInterceptor(RequestCorrelationProperties properties) {
        Assert.notNull((Object)properties, (String)"Parameter 'properties' can not be null");
        this.properties = properties;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String requestId;
        String sessionId = RequestCorrelationUtils.getCurrentSessionId();
        if (sessionId != null) {
            request.getHeaders().add(this.properties.getSessionHeaderName(), sessionId);
        }
        if ((requestId = RequestCorrelationUtils.getCurrentRequestId()) != null) {
            request.getHeaders().add(this.properties.getRequestHeaderName(), requestId);
        }
        return execution.execute(request, body);
    }
}

