/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.detectors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import net.samuelcampos.usbdrivedetector.USBStorageDevice;
import net.samuelcampos.usbdrivedetector.detectors.AbstractStorageDeviceDetector;
import net.samuelcampos.usbdrivedetector.process.CommandExecutor;
import net.samuelcampos.usbdrivedetector.process.OutputProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsStorageDeviceDetector
extends AbstractStorageDeviceDetector {
    private static final Logger log = LoggerFactory.getLogger(WindowsStorageDeviceDetector.class);
    private static final String WMIC_PATH = "\\System32\\wbem\\wmic.exe";
    private static final String CMD_WMI_ARGS = "logicaldisk where drivetype=2 get DeviceID,VolumeSerialNumber,VolumeName";
    private final String winDir;

    protected WindowsStorageDeviceDetector(String winDir, CommandExecutor commandExecutor) {
        super(commandExecutor);
        this.winDir = winDir;
    }

    private String getWmicCommand() {
        return this.winDir + WMIC_PATH + " " + CMD_WMI_ARGS;
    }

    @Override
    public List<USBStorageDevice> getStorageDevices() {
        ArrayList<USBStorageDevice> listDevices = new ArrayList<USBStorageDevice>();
        try (OutputProcessor commandOutputProcessor = this.commandExecutor.executeCommand(this.getWmicCommand());){
            commandOutputProcessor.processOutput(outputLine -> {
                String[] parts = outputLine.split(" ");
                if (!(parts.length <= 1 || parts[0].isEmpty() || parts[0].equals("DeviceID") || parts[0].equals(parts[parts.length - 1]))) {
                    String rootPath = parts[0] + File.separatorChar;
                    String uuid = parts[parts.length - 1];
                    String volumeName = this.parseVolumeName(parts);
                    if (volumeName.isEmpty()) {
                        volumeName = this.getDeviceName(rootPath);
                    }
                    WindowsStorageDeviceDetector.getUSBDevice(rootPath, volumeName, rootPath, uuid).ifPresent(listDevices::add);
                }
            });
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return listDevices;
    }

    private String parseVolumeName(String[] parts) {
        StringBuilder volumeLabel = new StringBuilder();
        for (int i = 1; i < parts.length - 1; ++i) {
            if (parts[i].isEmpty()) continue;
            if (volumeLabel.length() > 0) {
                volumeLabel.append(" ");
            }
            volumeLabel.append(parts[i]);
        }
        return volumeLabel.toString();
    }

    private String getDeviceName(String rootPath) {
        File f = new File(rootPath);
        FileSystemView v = FileSystemView.getFileSystemView();
        String name = v.getSystemDisplayName(f);
        if (name != null) {
            int idx = name.lastIndexOf(40);
            if (idx != -1) {
                name = name.substring(0, idx);
            }
            if ((name = name.trim()).isEmpty()) {
                name = null;
            }
        }
        return name;
    }
}

