/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.function.Function;
import net.sandrohc.jikan.cache.DisabledJikanCache;
import net.sandrohc.jikan.cache.JikanCache;
import net.sandrohc.jikan.exception.JikanQueryException;
import net.sandrohc.jikan.exception.JikanResponseException;
import net.sandrohc.jikan.factory.QueryFactory;
import net.sandrohc.jikan.query.Query;
import net.sandrohc.jikan.serializer.JikanModule;
import net.sandrohc.jikan.utils.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import reactor.netty.http.client.HttpClient;

public class Jikan {
    private static final Logger log = LoggerFactory.getLogger(Jikan.class);
    public static final Marker JIKAN_MARKER = MarkerFactory.getMarker((String)"JIKAN");
    public final boolean debug;
    public final String baseUrl;
    public final String userAgent;
    public final int maxRetries;
    public final JikanCache cache;
    public final HttpClient httpClient;
    public final ObjectMapper objectMapper;

    public Jikan() {
        this(new JikanBuilder());
    }

    public Jikan(JikanBuilder builder) {
        this.debug = builder.debug;
        this.baseUrl = builder.baseUrl;
        this.userAgent = builder.userAgent;
        this.maxRetries = builder.maxRetries;
        this.cache = builder.cache;
        log.trace(JIKAN_MARKER, "Preparing Jikan instance with parameters: debug=" + this.debug + ", baseUrl='" + this.baseUrl + "', userAgent='" + this.userAgent + "', maxRetries=" + this.maxRetries);
        HttpClient httpClient = HttpClient.create().baseUrl(this.baseUrl).headers(h -> h.add((CharSequence)HttpHeaderNames.ACCEPT, (Object)HttpHeaderValues.APPLICATION_JSON).add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.userAgent));
        ObjectMapper objectMapper = new ObjectMapper().registerModules(new Module[]{new JavaTimeModule(), new JikanModule()}).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.httpClient = (HttpClient)builder.httpClientCustomizer.apply(httpClient);
        this.objectMapper = (ObjectMapper)builder.objectMapperCustomizer.apply(objectMapper);
    }

    public QueryFactory query() {
        return new QueryFactory(this);
    }

    public <T, P extends Publisher<T>> P query(Query<T, P> query) throws JikanQueryException {
        return query.execute();
    }

    public Exception dumpStacktrace(Query<?, ?> query, byte[] response, Exception e) {
        if (!this.debug) {
            return new JikanResponseException("Error parsing JSON for query: " + query.getClass().getName(), e);
        }
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
        String timestamp = LocalDateTime.now().format(formatter);
        Path reportPath = Paths.get("error-jikan-" + timestamp + ".log", new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(reportPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
            writer.write("# Query");
            writer.newLine();
            writer.write("Query: " + query.getClass().getName());
            writer.newLine();
            writer.write("Response Class: " + query.responseType);
            writer.newLine();
            writer.write("URL: " + query.getUrl());
            writer.newLine();
            writer.newLine();
            writer.flush();
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            writer.write("# Exception");
            writer.newLine();
            writer.write(sw.toString());
            writer.newLine();
            writer.newLine();
            writer.flush();
            writer.write("# Response");
            writer.newLine();
            writer.write(new String(response, StandardCharsets.UTF_8));
            writer.newLine();
            writer.flush();
        }
        catch (IOException ex) {
            log.error(JIKAN_MARKER, "Error dumping contents of {} to: {}", new Object[]{query, reportPath, ex});
        }
        return new JikanResponseException("Error parsing JSON for query: " + query.getClass().getName() + ". A report file was generated at: " + reportPath, e);
    }

    public String toString() {
        return "Jikan[debug=" + this.debug + ", baseUrl='" + this.baseUrl + '\'' + ", userAgent='" + this.userAgent + '\'' + ", maxRetries=" + this.maxRetries + ", cache=" + this.cache + ']';
    }

    public static class JikanBuilder {
        private String baseUrl = "https://api.jikan.moe/v4";
        private String userAgent = this.getDefaultUserAgent();
        private boolean debug = false;
        private int maxRetries = 3;
        private JikanCache cache = new DisabledJikanCache();
        private Function<HttpClient, HttpClient> httpClientCustomizer = httpClient1 -> httpClient1;
        private Function<ObjectMapper, ObjectMapper> objectMapperCustomizer = objectMapper1 -> objectMapper1;

        public JikanBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public JikanBuilder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public JikanBuilder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public JikanBuilder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public JikanBuilder cache(JikanCache cache) {
            if (cache == null) {
                cache = new DisabledJikanCache();
            }
            this.cache = cache;
            return this;
        }

        public JikanBuilder httpClientCustomizer(Function<HttpClient, HttpClient> httpClientCustomizer) {
            if (httpClientCustomizer == null) {
                httpClientCustomizer = httpClient1 -> httpClient1;
            }
            this.httpClientCustomizer = httpClientCustomizer;
            return this;
        }

        public JikanBuilder objectMapperCustomizer(Function<ObjectMapper, ObjectMapper> objectMapperCustomizer) {
            if (objectMapperCustomizer == null) {
                objectMapperCustomizer = objectMapper1 -> objectMapper1;
            }
            this.objectMapperCustomizer = objectMapperCustomizer;
            return this;
        }

        public Jikan build() {
            return new Jikan(this);
        }

        @Generated
        public String getDefaultUserAgent() {
            Package pck = this.getClass().getPackage();
            if (pck.getImplementationTitle() == null) {
                return "reactive-jikan/development";
            }
            return pck.getImplementationTitle() + "/" + pck.getImplementationVersion();
        }

        public String toString() {
            return "JikanBuilder[baseUrl='" + this.baseUrl + '\'' + ", userAgent='" + this.userAgent + '\'' + ", debug=" + this.debug + ", maxRetries=" + this.maxRetries + ']';
        }
    }
}

