/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan.query;

import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAmount;
import java.util.Optional;
import net.sandrohc.jikan.Jikan;
import net.sandrohc.jikan.exception.JikanQueryException;
import net.sandrohc.jikan.exception.JikanResponseException;
import net.sandrohc.jikan.exception.JikanThrottleException;
import net.sandrohc.jikan.query.QueryUrlBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import reactor.util.retry.Retry;

public abstract class Query<T, R extends Publisher<?>> {
    private static final String CACHE_EXPIRE_HEADER = HttpHeaderNames.EXPIRES.toString();
    private static final TemporalAmount CACHE_EXPIRE_DEFAULT = Period.ofDays(1);
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public final Jikan jikan;
    public final TypeReference<T> responseType;

    public Query(Jikan jikan) {
        this.jikan = jikan;
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.responseType = new JikanTypeReference(type);
    }

    public abstract QueryUrlBuilder getUrl();

    public R execute() throws JikanQueryException {
        String url = null;
        try {
            Mono response;
            url = this.getUrl().build();
            this.log.debug(Jikan.JIKAN_MARKER, "Fetching request: {}", (Object)url);
            Optional<Object> cachedResults = this.jikan.cache.get(url);
            if (cachedResults.isPresent()) {
                this.log.trace(Jikan.JIKAN_MARKER, "Found in cache: {}", (Object)url);
                Mono results = (Mono)cachedResults.get();
                response = results.dematerialize();
            } else {
                this.log.trace(Jikan.JIKAN_MARKER, "Not found in cache: {}", (Object)url);
                String finalUrl = url;
                response = ((HttpClient.ResponseReceiver)this.jikan.httpClient.get().uri(url)).responseSingle(this::extractResponse).retryWhen((Retry)Retry.backoff((long)this.jikan.maxRetries, (Duration)Duration.ofMillis(500L)).filter(th -> th instanceof JikanThrottleException)).flatMap(holder -> {
                    this.jikan.cache.put(finalUrl, holder.result.materialize(), holder.expires);
                    return holder.result;
                });
            }
            return this.process(response);
        }
        catch (Exception e) {
            throw new JikanQueryException("Error when executing query '" + this.getClass().getName() + "' with URL '" + url + "'", e);
        }
    }

    public R process(Mono<T> content) {
        return (R)content;
    }

    private Mono<ResponseHolder> extractResponse(HttpClientResponse res, ByteBufMono content) {
        this.log.trace(Jikan.JIKAN_MARKER, "Received response for query '{}' and path '{}'", this.getClass(), (Object)res.path());
        if (res.status() == HttpResponseStatus.OK) {
            return content.asByteArray().map(bytes -> new ResponseHolder(res, this.deserialize((byte[])bytes)));
        }
        if (res.status() == HttpResponseStatus.NOT_FOUND) {
            return Mono.empty();
        }
        if (res.status() == HttpResponseStatus.TOO_MANY_REQUESTS) {
            return Mono.error((Throwable)new JikanThrottleException());
        }
        return content.asString().flatMap(str -> Mono.error((Throwable)new JikanResponseException("Response returned error '" + res.status() + "' while executing query '" + this.getClass() + "' with URL '" + this.getUrl() + "': " + str)));
    }

    public Mono<T> deserialize(byte[] content) {
        try {
            return Mono.just((Object)this.jikan.objectMapper.readValue(content, this.responseType));
        }
        catch (IOException e) {
            return Mono.error((Throwable)this.jikan.dumpStacktrace(this, content, e));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[url='" + this.getUrl() + "']";
    }

    private class JikanTypeReference
    extends TypeReference<T> {
        protected Type type;

        public JikanTypeReference(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }

    private class ResponseHolder {
        public final Mono<T> result;
        public final OffsetDateTime expires;

        public ResponseHolder(HttpClientResponse response, Mono<T> result) {
            this.result = result;
            long expiresEpoch = response.responseHeaders().getInt((CharSequence)CACHE_EXPIRE_HEADER, -1);
            this.expires = expiresEpoch < 0L ? OffsetDateTime.now().plus(CACHE_EXPIRE_DEFAULT) : OffsetDateTime.of(LocalDateTime.ofEpochSecond(expiresEpoch, 0, ZoneOffset.UTC), ZoneOffset.UTC);
        }
    }
}

