/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan.query;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.sandrohc.jikan.Jikan;
import net.sandrohc.jikan.exception.JikanUrlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUrlBuilder {
    private static final Logger log = LoggerFactory.getLogger(QueryUrlBuilder.class);
    protected String path;
    protected final StringBuilder params = new StringBuilder();

    private QueryUrlBuilder() {
    }

    public static QueryUrlBuilder create() {
        return new QueryUrlBuilder();
    }

    public QueryUrlBuilder path(String path) {
        this.path = path;
        return this;
    }

    public <T> QueryUrlBuilder param(String key, T value, Function<T, Object> mapper) {
        return this.param(key, value != null ? mapper.apply(value) : null);
    }

    public QueryUrlBuilder param(String key, Object value) {
        if (value == null) {
            log.trace(Jikan.JIKAN_MARKER, "Ignoring null query parameter '{}'", (Object)key);
            return this;
        }
        log.trace(Jikan.JIKAN_MARKER, "Appending query parameter '{}': {}", (Object)key, value);
        if (this.params.length() > 0) {
            this.params.append('&');
        }
        this.params.append(key);
        if (value instanceof Collection) {
            this.appendList(((Collection)value).iterator());
        } else if (value instanceof int[]) {
            this.appendList(IntStream.of((int[])value).iterator());
        } else if (value instanceof long[]) {
            this.appendList(LongStream.of((long[])value).iterator());
        } else if (value instanceof double[]) {
            this.appendList(DoubleStream.of((double[])value).iterator());
        } else if (value instanceof Object[]) {
            this.appendList(Stream.of((Object[])value).iterator());
        } else {
            this.params.append('=').append(value);
        }
        return this;
    }

    private <T> void appendList(Iterator<T> iterator) {
        this.params.append("[]=");
        boolean isFirstValue = true;
        while (iterator.hasNext()) {
            if (isFirstValue) {
                isFirstValue = false;
            } else {
                this.params.append(',');
            }
            this.params.append(iterator.next());
        }
    }

    public String build() throws JikanUrlException {
        String query = this.params.length() > 0 ? this.params.toString() : null;
        try {
            return new URI(null, null, this.path, query, null).toString();
        }
        catch (URISyntaxException e) {
            throw new JikanUrlException(this.path, query, e);
        }
    }

    public String toString() {
        return "QueryUrlBuilder[path='" + this.path + "', params='" + this.params + "']";
    }
}

