/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan.query.anime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.sandrohc.jikan.Jikan;
import net.sandrohc.jikan.model.DataListHolderWithPagination;
import net.sandrohc.jikan.model.anime.Anime;
import net.sandrohc.jikan.model.anime.AnimeOrderBy;
import net.sandrohc.jikan.model.anime.AnimeStatus;
import net.sandrohc.jikan.model.anime.AnimeType;
import net.sandrohc.jikan.model.common.Genre;
import net.sandrohc.jikan.model.enums.AgeRating;
import net.sandrohc.jikan.model.enums.SortOrder;
import net.sandrohc.jikan.query.QueryUrlBuilder;
import net.sandrohc.jikan.query.QueryableQuery;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AnimeSearchQuery
extends QueryableQuery<DataListHolderWithPagination<Anime>, Flux<Anime>, AnimeSearchQuery> {
    protected AnimeType type;
    protected Double score;
    protected Double minimumScore;
    protected Double maximumScore;
    protected AnimeStatus status;
    protected AgeRating ageRating;
    protected Boolean sfw;
    protected Genre[] genres;
    protected Genre[] genresExclude;
    protected AnimeOrderBy orderBy;
    protected SortOrder sort;
    protected String suffix;
    protected Integer[] producerIds;

    public AnimeSearchQuery(Jikan jikan) {
        super(jikan);
    }

    public AnimeSearchQuery type(AnimeType type) {
        this.type = type;
        return this;
    }

    public AnimeSearchQuery score(Double moreThan) {
        this.score = moreThan;
        return this;
    }

    public AnimeSearchQuery minimumScore(Double minScore) {
        this.minimumScore = minScore;
        return this;
    }

    public AnimeSearchQuery maximumScore(Double maxScore) {
        this.maximumScore = maxScore;
        return this;
    }

    public AnimeSearchQuery status(AnimeStatus status) {
        this.status = status;
        return this;
    }

    public AnimeSearchQuery rating(AgeRating ageRating) {
        this.ageRating = ageRating;
        return this;
    }

    public AnimeSearchQuery safeForWork(Boolean sfwOnly) {
        this.sfw = sfwOnly;
        return this;
    }

    public AnimeSearchQuery genres(Genre ... genres) {
        this.genres = genres;
        return this;
    }

    public AnimeSearchQuery excludeGenres(Genre ... excludeGenres) {
        this.genresExclude = excludeGenres;
        return this;
    }

    public AnimeSearchQuery orderBy(AnimeOrderBy orderBy, SortOrder sortOrder) {
        this.orderBy = orderBy;
        this.sort = sortOrder;
        return this;
    }

    public AnimeSearchQuery suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public AnimeSearchQuery producers(Integer ... producerIds) {
        this.producerIds = producerIds;
        return this;
    }

    @Override
    public QueryUrlBuilder getInnerUrl() {
        return QueryUrlBuilder.create().path("/anime").param("type", this.type, AnimeType::getSearch).param("score", this.score).param("min_score", this.minimumScore).param("max_score", this.maximumScore).param("status", this.status, AnimeStatus::getSearch).param("rating", this.ageRating, AgeRating::getSearch).param("sfw", this.sfw).param("genres", this.genres, AnimeSearchQuery::extractGenreIds).param("genres_exclude", this.genresExclude, AnimeSearchQuery::extractGenreIds).param("order_by", this.orderBy, AnimeOrderBy::getSearch).param("sort", this.sort, SortOrder::getSearch).param("letter", this.suffix).param("producer", this.producerIds);
    }

    @Override
    public Flux<Anime> process(Mono<DataListHolderWithPagination<Anime>> content) {
        return content.flatMapMany(holder -> Flux.fromIterable((Iterable)holder.data));
    }

    protected static Collection<Integer> extractGenreIds(Genre[] genres) {
        if (genres == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(Arrays.stream(genres).map(Genre::animeId).collect(Collectors.toCollection(TreeSet::new)));
    }
}

