/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan.query.manga;

import net.sandrohc.jikan.Jikan;
import net.sandrohc.jikan.model.DataListHolder;
import net.sandrohc.jikan.model.common.ForumTopic;
import net.sandrohc.jikan.model.enums.ForumTopicType;
import net.sandrohc.jikan.query.Query;
import net.sandrohc.jikan.query.QueryUrlBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MangaForumQuery
extends Query<DataListHolder<ForumTopic>, Flux<ForumTopic>> {
    protected final int id;
    protected ForumTopicType type;

    public MangaForumQuery(Jikan jikan, int id) {
        super(jikan);
        this.id = id;
    }

    public MangaForumQuery type(ForumTopicType type) {
        this.type = type;
        return this;
    }

    @Override
    public QueryUrlBuilder getUrl() {
        return QueryUrlBuilder.create().path("/manga/" + this.id + "/forum").param("filter", this.type, ForumTopicType::getValue);
    }

    @Override
    public Flux<ForumTopic> process(Mono<DataListHolder<ForumTopic>> content) {
        return content.flatMapMany(results -> Flux.fromIterable(results.data));
    }
}

