/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.jikan.query.manga;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.sandrohc.jikan.Jikan;
import net.sandrohc.jikan.model.DataListHolderWithPagination;
import net.sandrohc.jikan.model.common.Genre;
import net.sandrohc.jikan.model.enums.SortOrder;
import net.sandrohc.jikan.model.manga.Manga;
import net.sandrohc.jikan.model.manga.MangaOrderBy;
import net.sandrohc.jikan.model.manga.MangaStatus;
import net.sandrohc.jikan.model.manga.MangaType;
import net.sandrohc.jikan.query.QueryUrlBuilder;
import net.sandrohc.jikan.query.QueryableQuery;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MangaSearchQuery
extends QueryableQuery<DataListHolderWithPagination<Manga>, Flux<Manga>, MangaSearchQuery> {
    protected MangaType type;
    protected Double score;
    protected Double minimumScore;
    protected Double maximumScore;
    protected MangaStatus status;
    protected Boolean sfw;
    protected Genre[] genres;
    protected Genre[] genresExclude;
    protected MangaOrderBy orderBy;
    protected SortOrder sort;
    protected String suffix;
    protected Integer[] magazineIds;

    public MangaSearchQuery(Jikan jikan) {
        super(jikan);
    }

    public MangaSearchQuery type(MangaType type) {
        this.type = type;
        return this;
    }

    public MangaSearchQuery score(Double moreThan) {
        this.score = moreThan;
        return this;
    }

    public MangaSearchQuery minimumScore(Double minScore) {
        this.minimumScore = minScore;
        return this;
    }

    public MangaSearchQuery maximumScore(Double maxScore) {
        this.maximumScore = maxScore;
        return this;
    }

    public MangaSearchQuery status(MangaStatus status) {
        this.status = status;
        return this;
    }

    public MangaSearchQuery safeForWork(Boolean sfwOnly) {
        this.sfw = sfwOnly;
        return this;
    }

    public MangaSearchQuery genres(Genre ... genres) {
        this.genres = genres;
        return this;
    }

    public MangaSearchQuery excludeGenres(Genre ... excludeGenres) {
        this.genresExclude = excludeGenres;
        return this;
    }

    public MangaSearchQuery orderBy(MangaOrderBy orderBy, SortOrder sortOrder) {
        this.orderBy = orderBy;
        this.sort = sortOrder;
        return this;
    }

    public MangaSearchQuery suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public MangaSearchQuery magazines(Integer ... magazineIds) {
        this.magazineIds = magazineIds;
        return this;
    }

    @Override
    public QueryUrlBuilder getInnerUrl() {
        return QueryUrlBuilder.create().path("/manga").param("type", this.type, MangaType::getSearch).param("score", this.score).param("min_score", this.minimumScore).param("max_score", this.maximumScore).param("status", this.status, MangaStatus::getSearch).param("sfw", this.sfw).param("genres", this.genres, MangaSearchQuery::extractGenreIds).param("genres_exclude", this.genresExclude, MangaSearchQuery::extractGenreIds).param("order_by", this.orderBy, MangaOrderBy::getSearch).param("sort", this.sort, SortOrder::getSearch).param("letter", this.suffix).param("magazine", this.magazineIds);
    }

    @Override
    public Flux<Manga> process(Mono<DataListHolderWithPagination<Manga>> content) {
        return content.flatMapMany(holder -> Flux.fromIterable((Iterable)holder.data));
    }

    protected static Collection<Integer> extractGenreIds(Genre[] genres) {
        if (genres == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(Arrays.stream(genres).map(Genre::mangaId).collect(Collectors.toCollection(TreeSet::new)));
    }
}

